/*
 * Decompiled with CFR 0.152.
 */
package jerozgen.languagereload.gui;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import jerozgen.languagereload.access.ILanguageOptionsScreen;
import jerozgen.languagereload.config.Config;
import jerozgen.languagereload.gui.LanguageListWidget;
import net.minecraft.class_1077;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_344;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_5348;
import net.minecraft.class_8000;
import net.minecraft.class_8666;
import org.joml.Vector2i;

public class LanguageEntry
extends class_4280.class_4281<LanguageEntry> {
    private static final class_2561 DEFAULT_LANGUAGE_TOOLTIP = class_2561.method_43471((String)"language.default.tooltip");
    private static final class_8666 ADD_TEXTURES = new class_8666(class_2960.method_60655((String)"languagereload", (String)"language_selection/add"), class_2960.method_60655((String)"languagereload", (String)"language_selection/add_highlighted"));
    private static final class_8666 REMOVE_TEXTURES = new class_8666(class_2960.method_60655((String)"languagereload", (String)"language_selection/remove"), class_2960.method_60655((String)"languagereload", (String)"language_selection/remove_highlighted"));
    private static final class_8666 MOVE_UP_TEXTURES = new class_8666(class_2960.method_60655((String)"languagereload", (String)"language_selection/move_up"), class_2960.method_60655((String)"languagereload", (String)"language_selection/move_up_highlighted"));
    private static final class_8666 MOVE_DOWN_TEXTURES = new class_8666(class_2960.method_60655((String)"languagereload", (String)"language_selection/move_down"), class_2960.method_60655((String)"languagereload", (String)"language_selection/move_down_highlighted"));
    private final class_310 client = class_310.method_1551();
    private final String code;
    private final class_1077 language;
    private final LinkedList<String> selectedLanguages;
    private final Runnable refreshListsAction;
    private final List<class_339> buttons = new ArrayList<class_339>();
    private final class_4185 addButton = this.addButton(15, 24, ADD_TEXTURES, __ -> this.add());
    private final class_4185 removeButton = this.addButton(15, 24, REMOVE_TEXTURES, __ -> this.remove());
    private final class_4185 moveUpButton = this.addButton(11, 11, MOVE_UP_TEXTURES, __ -> this.moveUp());
    private final class_4185 moveDownButton = this.addButton(11, 11, MOVE_DOWN_TEXTURES, __ -> this.moveDown());
    private LanguageListWidget parentList;

    public LanguageEntry(Runnable refreshListsAction, String code, class_1077 language, LinkedList<String> selectedLanguages) {
        this.code = code;
        this.language = language;
        this.selectedLanguages = selectedLanguages;
        this.refreshListsAction = refreshListsAction;
    }

    protected class_4185 addButton(int width, int height, class_8666 textures, class_4185.class_4241 action) {
        class_344 button = new class_344(0, 0, width, height, textures, action);
        button.field_22764 = false;
        this.buttons.add((class_339)button);
        return button;
    }

    private boolean isDefault() {
        return this.code.equals("en_us");
    }

    private boolean isSelected() {
        return this.selectedLanguages.contains(this.code);
    }

    private boolean isFirst() {
        return this.code.equals(this.selectedLanguages.peekFirst());
    }

    private boolean isLast() {
        return this.code.equals(this.selectedLanguages.peekLast());
    }

    private void add() {
        if (this.method_25370()) {
            this.parentList.method_25395(null);
        }
        this.selectedLanguages.addFirst(this.code);
        this.refreshListsAction.run();
    }

    private void remove() {
        if (this.method_25370()) {
            this.parentList.method_25395(null);
        }
        this.selectedLanguages.remove(this.code);
        this.refreshListsAction.run();
    }

    public void toggle() {
        if (!this.isSelected()) {
            this.add();
        } else {
            this.remove();
        }
    }

    public void moveUp() {
        if (!this.isSelected()) {
            return;
        }
        if (this.isFirst()) {
            return;
        }
        int index = this.selectedLanguages.indexOf(this.code);
        this.selectedLanguages.add(index - 1, this.selectedLanguages.remove(index));
        this.refreshListsAction.run();
    }

    public void moveDown() {
        if (!this.isSelected()) {
            return;
        }
        if (this.isLast()) {
            return;
        }
        int index = this.selectedLanguages.indexOf(this.code);
        this.selectedLanguages.add(index + 1, this.selectedLanguages.remove(index));
        this.refreshListsAction.run();
    }

    public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        x -= 2;
        y -= 2;
        if (hovered || this.method_25370() || ((Boolean)this.client.field_1690.method_42446().method_41753()).booleanValue()) {
            int x1 = x + 1;
            int y1 = y + 1;
            int x2 = this.parentList.getHoveredSelectionRight() - 1;
            int y2 = y + entryHeight + 3;
            context.method_25294(x1, y1, x2, y2, hovered || this.method_25370() ? -1601138544 : 0x50909090);
            this.buttons.forEach(button -> {
                button.field_22764 = false;
            });
            this.renderButtons((button, buttonX, buttonY) -> {
                button.method_46421(buttonX);
                button.method_46419(buttonY);
                button.field_22764 = true;
                button.method_25394(context, mouseX, mouseY, tickDelta);
            }, x, y);
            if ((hovered || this.method_25370()) && this.isDefault()) {
                this.renderDefaultLanguageTooltip(context, x, y);
            }
        }
        context.method_25303(this.client.field_1772, this.language.comp_1199(), x + 29, y + 3, -1);
        context.method_25303(this.client.field_1772, this.language.comp_1198(), x + 29, y + 14, -8355712);
    }

    private void renderButtons(ButtonRenderer renderer, int x, int y) {
        if (this.isSelected()) {
            if (!this.isDefault() || Config.getInstance().removableDefaultLanguage) {
                renderer.render(this.removeButton, x, y);
            }
            if (!this.isFirst()) {
                renderer.render(this.moveUpButton, x + this.removeButton.method_25368() + 1, y);
            }
            if (!this.isLast()) {
                renderer.render(this.moveDownButton, x + this.removeButton.method_25368() + 1, y + this.moveUpButton.method_25364() + 2);
            }
        } else {
            renderer.render(this.addButton, x + 7, y);
        }
    }

    private void renderDefaultLanguageTooltip(class_332 context, int x, int y) {
        List tooltip = this.client.field_1772.method_1728((class_5348)DEFAULT_LANGUAGE_TOOLTIP, this.parentList.method_25322() - 6);
        class_8000 positioner = (screenWidth, screenHeight, mouseX, mouseY, width, height) -> {
            Vector2i pos = new Vector2i(x + 3 + (this.parentList.method_25322() - width - 6) / 2, y + this.parentList.getRowHeight() + 4);
            if (pos.y > this.parentList.method_55443() + 2 || pos.y + height + 5 > screenHeight) {
                pos.y = y - height - 6;
            }
            return pos;
        };
        context.method_51436(this.client.field_1772, tooltip, positioner, 0, 0, true);
    }

    public class_2561 method_37006() {
        return class_2561.method_43469((String)"narrator.select", (Object[])new Object[]{this.language.method_48303()});
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        for (class_339 widget : this.buttons) {
            if (!widget.method_25402(mouseX, mouseY, button)) continue;
            ((ILanguageOptionsScreen)this.parentList.getScreen()).languagereload_focusList(this.parentList);
            return true;
        }
        return false;
    }

    public void setParent(LanguageListWidget list) {
        this.parentList = list;
    }

    public LanguageListWidget getParent() {
        return this.parentList;
    }

    public String getCode() {
        return this.code;
    }

    public class_1077 getLanguage() {
        return this.language;
    }

    @FunctionalInterface
    private static interface ButtonRenderer {
        public void render(class_4185 var1, int var2, int var3);
    }
}

