/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.defaultoptions.keys;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.blay09.mods.defaultoptions.DefaultOptions;
import net.blay09.mods.defaultoptions.DefaultOptionsInitializer;
import net.blay09.mods.defaultoptions.DefaultOptionsKeyMapping;
import net.blay09.mods.defaultoptions.PlatformBindings;
import net.blay09.mods.defaultoptions.api.DefaultOptionsCategory;
import net.blay09.mods.defaultoptions.api.DefaultOptionsHandler;
import net.blay09.mods.defaultoptions.api.DefaultOptionsLoadStage;
import net.blay09.mods.defaultoptions.keys.DefaultKeyMapping;
import net.blay09.mods.defaultoptions.keys.KeyModifier;
import net.blay09.mods.defaultoptions.mixin.KeyMappingAccessor;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;

public class KeyMappingDefaultsHandler
implements DefaultOptionsHandler {
    private static final Pattern KEY_PATTERN = Pattern.compile("key_([^:]+):([^:]+)(?::(.+)?)?");
    private static final Map<String, DefaultKeyMapping> defaultKeys = new HashMap<String, DefaultKeyMapping>();

    private File getDefaultOptionsFile() {
        return new File(DefaultOptions.getDefaultOptionsFolder(), "keybindings.txt");
    }

    @Override
    public String getId() {
        return "keymappings";
    }

    @Override
    public DefaultOptionsCategory getCategory() {
        return DefaultOptionsCategory.KEYS;
    }

    @Override
    public DefaultOptionsLoadStage getLoadStage() {
        return DefaultOptionsLoadStage.POST_LOAD;
    }

    @Override
    public void saveCurrentOptions() {
        class_310.method_1551().field_1690.method_1640();
    }

    @Override
    public void saveCurrentOptionsAsDefault() {
        try (PrintWriter writer = new PrintWriter(new FileWriter(new File(DefaultOptions.getDefaultOptionsFolder(), "keybindings.txt")));){
            for (class_304 keyMapping : class_310.method_1551().field_1690.field_1839) {
                class_3675.class_306 key = PlatformBindings.INSTANCE.getKey(keyMapping);
                Set<KeyModifier> keyModifiers = PlatformBindings.INSTANCE.getKeyModifiers(keyMapping);
                writer.println("key_" + keyMapping.method_1431() + ":" + key.method_1441() + ":" + keyModifiers.stream().map(Enum::name).collect(Collectors.joining(",")));
            }
        }
        catch (Exception e) {
            DefaultOptions.logger.error("Failed to save default key mappings", (Throwable)e);
        }
        this.loadDefaults();
    }

    @Override
    public boolean hasDefaults() {
        return this.getDefaultOptionsFile().exists();
    }

    @Override
    public boolean shouldLoadDefaults() {
        return true;
    }

    @Override
    public void loadDefaults() {
        DefaultOptionsInitializer.markUserSeenKeys(class_310.method_1551().field_1690);
        defaultKeys.clear();
        File defaultKeysFile = new File(DefaultOptions.getDefaultOptionsFolder(), "keybindings.txt");
        if (defaultKeysFile.exists()) {
            block18: {
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(defaultKeysFile));
                    block9: while (true) {
                        String line;
                        while ((line = reader.readLine()) != null) {
                            if (line.isEmpty()) continue;
                            Matcher matcher = KEY_PATTERN.matcher(line);
                            if (!matcher.matches()) {
                                DefaultOptions.logger.debug("Skipping line {} as the format is invalid", (Object)line);
                                continue;
                            }
                            try {
                                String[] keyModifierNames = matcher.group(3) != null ? matcher.group(3).split(",") : new String[]{};
                                Set<KeyModifier> modifiers = Arrays.stream(keyModifierNames).map(KeyModifier::valueOf).collect(Collectors.toSet());
                                String keyMappingName = matcher.group(1);
                                defaultKeys.put(keyMappingName, new DefaultKeyMapping(class_3675.method_15981((String)matcher.group(2)), modifiers));
                                DefaultOptions.logger.debug("Registered a default key binding for {} ({}:{})", (Object)keyMappingName, (Object)matcher.group(2), (Object)matcher.group(3));
                                continue block9;
                            }
                            catch (Exception e) {
                                DefaultOptions.logger.error("Error loading default key binding for {}", (Object)line, (Object)e);
                            }
                        }
                        break block18;
                        {
                            continue block9;
                            break;
                        }
                        break;
                    }
                    finally {
                        reader.close();
                    }
                }
                catch (Exception e) {
                    DefaultOptions.logger.error("Error loading default key bindings", (Throwable)e);
                }
            }
            DefaultOptions.logger.info("Loaded {} default key bindings.", (Object)defaultKeys.size());
        } else {
            DefaultOptions.logger.info("No default key bindings file found.");
        }
        int defaultsApplied = 0;
        int bindingsOverridden = 0;
        for (class_304 keyMapping : class_310.method_1551().field_1690.field_1839) {
            DefaultKeyMapping originalDefaultMapping = new DefaultKeyMapping(keyMapping.method_1429(), PlatformBindings.INSTANCE.getDefaultKeyModifiers(keyMapping));
            if (defaultKeys.containsKey(keyMapping.method_1431())) {
                DefaultKeyMapping defaultKeyMapping = defaultKeys.get(keyMapping.method_1431());
                ((KeyMappingAccessor)keyMapping).setDefaultKey(defaultKeyMapping.input());
                PlatformBindings.INSTANCE.setDefaultKeyModifiers(keyMapping, defaultKeyMapping.modifiers());
                ++defaultsApplied;
                if (!((DefaultOptionsKeyMapping)keyMapping).defaultoptions$wasSeen() && originalDefaultMapping.matches(keyMapping) && !defaultKeyMapping.matches(keyMapping)) {
                    Set<KeyModifier> defaultKeyModifiers = PlatformBindings.INSTANCE.getDefaultKeyModifiers(keyMapping);
                    PlatformBindings.INSTANCE.setKeyModifiers(keyMapping, defaultKeyModifiers);
                    keyMapping.method_1422(keyMapping.method_1429());
                    ++bindingsOverridden;
                    DefaultOptions.logger.debug("Key mapping {} was previously on the original default. Configuring to new default.", (Object)keyMapping.method_1431());
                    continue;
                }
                DefaultOptions.logger.debug("Key mapping {} has been previously set, skipping.", (Object)keyMapping.method_1431());
                continue;
            }
            DefaultOptions.logger.debug("No default key mapping configured for {}, skipping.", (Object)keyMapping.method_1431());
        }
        DefaultOptions.logger.info("Applied {} defaults to key mappings ({} keys were reconfigured).", (Object)defaultsApplied, (Object)bindingsOverridden);
        if (bindingsOverridden > 0) {
            class_304.method_1426();
            this.saveCurrentOptions();
        }
    }
}

