/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.api.fluid;

import net.blay09.mods.balm.api.fluid.FluidTank;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_7922;
import net.minecraft.class_7923;

public class DefaultFluidTank
implements FluidTank {
    private final int capacity;
    private final int maxFill;
    private final int maxDrain;
    private class_3611 fluid = class_3612.field_15906;
    private int amount;

    public DefaultFluidTank(int capacity) {
        this(capacity, capacity, capacity, 0);
    }

    public DefaultFluidTank(int capacity, int maxTransfer) {
        this(maxTransfer, capacity, maxTransfer, 0);
    }

    public DefaultFluidTank(int capacity, int maxFill, int maxDrain) {
        this(maxDrain, capacity, maxFill, 0);
    }

    public DefaultFluidTank(int maxDrain, int capacity, int maxFill, int amount) {
        this.capacity = capacity;
        this.maxFill = maxFill;
        this.maxDrain = maxDrain;
        this.amount = Math.max(0, Math.min(capacity, amount));
    }

    @Override
    public int fill(class_3611 fluid, int maxFill, boolean simulate) {
        if (!this.canFill(fluid)) {
            return 0;
        }
        if (this.fluid.method_15780(class_3612.field_15906)) {
            this.fluid = fluid;
        }
        int filled = Math.min(this.capacity - this.amount, Math.min(this.maxFill, maxFill));
        if (!simulate) {
            this.amount += filled;
            this.setChanged();
        }
        return filled;
    }

    @Override
    public int drain(class_3611 fluid, int maxDrain, boolean simulate) {
        if (!this.canDrain(fluid)) {
            return 0;
        }
        int drained = Math.min(this.amount, Math.min(this.maxDrain, maxDrain));
        if (!simulate) {
            this.amount -= drained;
            this.setChanged();
        }
        return drained;
    }

    @Override
    public class_3611 getFluid() {
        return this.amount >= 0 ? this.fluid : class_3612.field_15906;
    }

    @Override
    public void setFluid(class_3611 fluid, int amount) {
        this.fluid = fluid;
        this.amount = amount;
        this.setChanged();
    }

    @Override
    public int getAmount() {
        return this.amount;
    }

    @Override
    public void setAmount(int amount) {
        this.amount = amount;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public boolean canDrain(class_3611 fluid) {
        return (this.fluid.method_15780(fluid) || this.fluid.method_15780(class_3612.field_15906)) && this.maxDrain > 0;
    }

    @Override
    public boolean canFill(class_3611 fluid) {
        return (this.fluid.method_15780(fluid) || this.fluid.method_15780(class_3612.field_15906)) && this.maxFill > 0;
    }

    @Override
    public boolean isEmpty() {
        return this.amount <= 0 || this.fluid.method_15780(class_3612.field_15906);
    }

    public void serialize(class_11372 output) {
        output.method_71469("Fluid", class_7923.field_41173.method_10221((Object)this.fluid).toString());
        output.method_71465("Amount", this.amount);
    }

    public void deserialize(class_11368 input) {
        this.fluid = input.method_71441("Fluid").map(class_2960::method_12829).map(arg_0 -> ((class_7922)class_7923.field_41173).method_63535(arg_0)).orElse(class_3612.field_15906);
        this.amount = input.method_71424("Amount", 0);
    }

    @Deprecated(forRemoval=true, since="1.22")
    public class_2487 serialize() {
        class_2487 tag = new class_2487();
        tag.method_10582("Fluid", class_7923.field_41173.method_10221((Object)this.fluid).toString());
        tag.method_10569("Amount", this.amount);
        return tag;
    }

    @Deprecated(forRemoval=true, since="1.22")
    public void deserialize(class_2487 tag) {
        this.fluid = tag.method_10558("Fluid").map(class_2960::method_12829).map(arg_0 -> ((class_7922)class_7923.field_41173).method_63535(arg_0)).orElse(class_3612.field_15906);
        this.amount = tag.method_68083("Amount", 0);
    }

    public void setChanged() {
    }
}

