/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.starlight.interndep.flowsched.scheduler;

import ca.spottedleaf.starlight.interndep.flowsched.scheduler.Cancellable;
import ca.spottedleaf.starlight.interndep.flowsched.scheduler.CancellationSignaller;
import ca.spottedleaf.starlight.interndep.flowsched.scheduler.ExceptionHandlingAction;
import ca.spottedleaf.starlight.interndep.flowsched.scheduler.ItemHolder;
import ca.spottedleaf.starlight.interndep.flowsched.scheduler.ItemStatus;
import ca.spottedleaf.starlight.interndep.flowsched.scheduler.ItemTicket;
import ca.spottedleaf.starlight.interndep.flowsched.scheduler.KeyStatusPair;
import ca.spottedleaf.starlight.interndep.flowsched.scheduler.ObjectFactory;
import ca.spottedleaf.starlight.interndep.flowsched.util.Assertions;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.schedulers.Schedulers;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.StampedLock;

public abstract class StatusAdvancingScheduler<K, V, Ctx, UserData> {
    public static final Runnable NO_OP = () -> {};
    private final StampedLock itemsLock = new StampedLock();
    private final Object2ReferenceOpenHashMap<K, ItemHolder<K, V, Ctx, UserData>> items = new Object2ReferenceOpenHashMap();
    private final AtomicInteger updateSize = new AtomicInteger();
    private final Queue<K> pendingUpdates;
    private final ObjectLinkedOpenHashSet<K> pendingUpdatesInternal = new ObjectLinkedOpenHashSet<K>(){

        protected void rehash(int newN) {
            if (this.n < newN) {
                super.rehash(newN);
            }
        }
    };
    private final ObjectFactory objectFactory;

    protected StatusAdvancingScheduler() {
        this(new ObjectFactory.DefaultObjectFactory());
    }

    protected StatusAdvancingScheduler(ObjectFactory objectFactory) {
        this.objectFactory = Objects.requireNonNull(objectFactory);
        this.pendingUpdates = this.objectFactory.newMPSCQueue();
    }

    protected abstract Executor getExecutor();

    protected Scheduler getSchedulerBackedByExecutor() {
        return Schedulers.from((Executor)this.getExecutor());
    }

    protected Executor getBackgroundExecutor() {
        return this.getExecutor();
    }

    protected Scheduler getSchedulerBackedByBackgroundExecutor() {
        return Schedulers.from((Executor)this.getBackgroundExecutor());
    }

    protected abstract ItemStatus<K, V, Ctx> getUnloadedStatus();

    protected abstract Ctx makeContext(ItemHolder<K, V, Ctx, UserData> var1, ItemStatus<K, V, Ctx> var2, KeyStatusPair<K, V, Ctx>[] var3, boolean var4);

    protected ExceptionHandlingAction handleTransactionException(ItemHolder<K, V, Ctx, UserData> holder, ItemStatus<K, V, Ctx> nextStatus, boolean isUpgrade, Throwable throwable) {
        throwable.printStackTrace();
        return ExceptionHandlingAction.MARK_BROKEN;
    }

    protected void handleUnrecoverableException(Throwable throwable) {
    }

    protected void onItemCreation(ItemHolder<K, V, Ctx, UserData> holder) {
    }

    protected void onItemRemoval(ItemHolder<K, V, Ctx, UserData> holder) {
    }

    protected void onItemUpgrade(ItemHolder<K, V, Ctx, UserData> holder, ItemStatus<K, V, Ctx> statusReached) {
    }

    protected void onItemDowngrade(ItemHolder<K, V, Ctx, UserData> holder, ItemStatus<K, V, Ctx> statusReached) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tick() {
        K key;
        while ((key = this.pendingUpdates.poll()) != null) {
            this.pendingUpdatesInternal.addAndMoveToLast(key);
            this.updateSize.decrementAndGet();
        }
        boolean hasWork = false;
        while (!this.pendingUpdatesInternal.isEmpty()) {
            hasWork = true;
            Object key2 = this.pendingUpdatesInternal.removeFirst();
            ItemHolder<Object, V, Ctx, UserData> holder = this.getHolder(key2);
            if (holder == null) continue;
            ItemHolder<Object, V, Ctx, UserData> itemHolder = holder;
            synchronized (itemHolder) {
                ItemStatus<Object, V, Ctx> current = holder.getStatus();
                ItemStatus<Object, V, Ctx> nextStatus = this.getNextStatus(current, holder.getTargetStatus());
                if (holder.isBusy()) {
                    ItemStatus<Object, V, Ctx> projectedCurrent;
                    ItemStatus<Object, V, Ctx> upgradingStatusTo = holder.upgradingStatusTo();
                    ItemStatus<Object, V, Ctx> itemStatus = projectedCurrent = upgradingStatusTo != null ? upgradingStatusTo : current;
                    if (projectedCurrent.ordinal() > nextStatus.ordinal()) {
                        this.getExecutor().execute(holder::tryCancelUpgradeAction);
                    }
                    holder.consolidateMarkDirty(this);
                    continue;
                }
                if (nextStatus == current) {
                    if (current.equals(this.getUnloadedStatus())) {
                        if (holder.isDependencyDirty()) {
                            holder.submitOp(CompletableFuture.runAsync(() -> holder.cleanupDependencies(this), this.getBackgroundExecutor()));
                            holder.consolidateMarkDirty(this);
                            continue;
                        }
                        if (holder.holdsDependency()) {
                            if (holder.isDependencyDirty()) {
                                this.markDirty(holder.getKey());
                                continue;
                            }
                            System.err.println(String.format("BUG: %s still holds some dependencies when ready for unloading", holder.getKey()));
                        }
                        this.onItemRemoval(holder);
                        holder.release();
                        long lock = this.itemsLock.writeLock();
                        try {
                            this.items.remove(key2);
                        }
                        finally {
                            this.itemsLock.unlockWrite(lock);
                        }
                        continue;
                    }
                    holder.submitOp(CompletableFuture.runAsync(() -> holder.cleanupDependencies(this), this.getBackgroundExecutor()));
                    continue;
                }
                if (current.ordinal() < nextStatus.ordinal()) {
                    if ((holder.getFlags() & 2) != 0) {
                        continue;
                    }
                    holder.submitOp(CompletableFuture.runAsync(() -> this.advanceStatus0(holder, nextStatus, key2), this.getBackgroundExecutor()));
                } else {
                    boolean success = holder.setStatus(nextStatus, false);
                    if (!success) {
                        continue;
                    }
                    holder.submitOp(CompletableFuture.runAsync(() -> this.downgradeStatus0(holder, current, nextStatus, key2), this.getExecutor()));
                }
            }
        }
        return hasWork;
    }

    private void downgradeStatus0(ItemHolder<K, V, Ctx, UserData> holder, ItemStatus<K, V, Ctx> current, ItemStatus<K, V, Ctx> nextStatus, K key) {
        KeyStatusPair[] dependencies = holder.getDependencies(current);
        Assertions.assertTrue(dependencies != null, "No dependencies for downgrade");
        Cancellable cancellable = new Cancellable();
        Completable completable = Completable.defer(() -> {
            Assertions.assertTrue(holder.isBusy());
            Ctx ctx = this.makeContext(holder, current, dependencies, false);
            CompletionStage<Void> stage = current.downgradeFromThis(ctx, cancellable);
            return Completable.fromCompletionStage(stage);
        }).subscribeOn(this.getSchedulerBackedByBackgroundExecutor()).observeOn(this.getSchedulerBackedByExecutor()).doOnEvent(throwable -> {
            try {
                Assertions.assertTrue(holder.isBusy());
                Throwable actual = throwable;
                while (actual instanceof CompletionException) {
                    CompletionException ex = (CompletionException)actual;
                    actual = ex.getCause();
                }
                if (cancellable.isCancelled() && actual instanceof CancellationException) {
                    holder.setStatus(current, true);
                    holder.consolidateMarkDirty(this);
                    return;
                }
                ExceptionHandlingAction action = this.tryHandleTransactionException(holder, nextStatus, false, (Throwable)throwable);
                switch (action) {
                    case PROCEED: {
                        this.releaseDependencies(holder, current);
                        break;
                    }
                    case MARK_BROKEN: {
                        holder.setFlag(2);
                        this.clearDependencies0(holder, current);
                    }
                }
                holder.consolidateMarkDirty(this);
                this.onItemDowngrade(holder, nextStatus);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        });
        holder.subscribeOp(completable);
    }

    private void advanceStatus0(ItemHolder<K, V, Ctx, UserData> holder, ItemStatus<K, V, Ctx> nextStatus, K key) {
        KeyStatusPair[] dependencies = nextStatus.getDependencies(holder);
        CancellationSignaller dependencyCompletable = this.getDependencyFuture0(dependencies, holder, nextStatus);
        Cancellable cancellable = new Cancellable();
        CancellationSignaller signaller = new CancellationSignaller(unused -> {
            cancellable.cancel();
            dependencyCompletable.cancel();
        });
        Completable completable = Completable.create(emitter -> dependencyCompletable.addListener(throwable -> {
            if (throwable != null) {
                emitter.onError(throwable);
            } else {
                emitter.onComplete();
            }
        })).observeOn(this.getSchedulerBackedByBackgroundExecutor()).andThen((CompletableSource)Completable.defer(() -> {
            Assertions.assertTrue(holder.isBusy());
            Ctx ctx = this.makeContext(holder, nextStatus, dependencies, false);
            CompletionStage<Void> stage = nextStatus.upgradeToThis(ctx, cancellable);
            return Completable.fromCompletionStage(stage).cache();
        })).observeOn(this.getSchedulerBackedByBackgroundExecutor()).doOnEvent(throwable -> {
            try {
                Assertions.assertTrue(holder.isBusy());
                Throwable actual = throwable;
                while (actual instanceof CompletionException) {
                    CompletionException ex = (CompletionException)actual;
                    actual = ex.getCause();
                }
                if (cancellable.isCancelled() && actual instanceof CancellationException) {
                    if (holder.getDependencies(nextStatus) != null) {
                        this.releaseDependencies(holder, nextStatus);
                    }
                    try {
                        signaller.fireComplete(actual);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    holder.consolidateMarkDirty(this);
                    return;
                }
                Assertions.assertTrue(holder.getDependencies(nextStatus) != null);
                ExceptionHandlingAction action = this.tryHandleTransactionException(holder, nextStatus, true, (Throwable)throwable);
                switch (action) {
                    case PROCEED: {
                        holder.setStatus(nextStatus, false);
                        this.rerequestDependencies(holder, nextStatus);
                        holder.consolidateMarkDirty(this);
                        this.onItemUpgrade(holder, nextStatus);
                        break;
                    }
                    case MARK_BROKEN: {
                        holder.setFlag(2);
                        this.clearDependencies0(holder, nextStatus);
                        holder.consolidateMarkDirty(this);
                    }
                }
                try {
                    signaller.fireComplete(null);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            catch (Throwable t) {
                try {
                    holder.setFlag(2);
                    this.clearDependencies0(holder, nextStatus);
                    holder.consolidateMarkDirty(this);
                }
                catch (Throwable t1) {
                    t.addSuppressed(t1);
                }
                t.printStackTrace();
            }
        }).onErrorComplete().cache();
        holder.submitUpgradeAction(signaller, nextStatus);
        holder.subscribeOp(completable);
        completable.subscribe(() -> signaller.fireComplete(null), signaller::fireComplete);
    }

    private void rerequestDependencies(ItemHolder<K, V, Ctx, UserData> holder, ItemStatus<K, V, Ctx> status) {
        KeyStatusPair<K, V, Ctx>[] curDep = holder.getDependencies(status);
        KeyStatusPair<K, V, Ctx>[] newDep = status.getDependencies(holder);
        KeyStatusPair<K, V, Ctx>[] toAdd = status.getDependenciesToAdd(holder);
        KeyStatusPair<K, V, Ctx>[] toRemove = status.getDependenciesToRemove(holder);
        holder.setDependencies(status, null);
        holder.setDependencies(status, newDep);
        for (KeyStatusPair<K, V, Ctx> pair : toAdd) {
            holder.addDependencyTicket(this, pair.key(), pair.status(), NO_OP);
        }
        for (KeyStatusPair<K, V, Ctx> pair : toRemove) {
            holder.removeDependencyTicket(pair.key(), pair.status());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemHolder<K, V, Ctx, UserData> getHolder(K key) {
        long stamp = this.itemsLock.tryOptimisticRead();
        if (stamp != 0L) {
            try {
                ItemHolder holder = (ItemHolder)this.items.get(key);
                if (this.itemsLock.validate(stamp)) {
                    return holder;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        stamp = this.itemsLock.readLock();
        try {
            ItemHolder itemHolder = (ItemHolder)this.items.get(key);
            return itemHolder;
        }
        finally {
            this.itemsLock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ItemHolder<K, V, Ctx, UserData> getOrCreateHolder(K key) {
        ItemHolder<K, V, Ctx, UserData> holder = this.getHolder(key);
        if (holder != null) {
            return holder;
        }
        long lock = this.itemsLock.writeLock();
        try {
            ItemHolder itemHolder = (ItemHolder)this.items.computeIfAbsent(key, this::createHolder);
            return itemHolder;
        }
        finally {
            this.itemsLock.unlockWrite(lock);
        }
    }

    public int itemCount() {
        VarHandle.acquireFence();
        return this.items.size();
    }

    protected void markDirty(K key) {
        boolean needWakeup = this.updateSize.getAndIncrement() == 0;
        this.pendingUpdates.add(key);
        if (needWakeup) {
            this.wakeUp();
        }
    }

    protected void wakeUp() {
    }

    private CancellationSignaller getDependencyFuture0(KeyStatusPair<K, V, Ctx>[] dependencies, ItemHolder<K, V, Ctx, UserData> holder, ItemStatus<K, V, Ctx> nextStatus) {
        AtomicInteger satisfied = new AtomicInteger(0);
        int size = dependencies.length;
        holder.setDependencies(nextStatus, dependencies);
        if (size == 0) {
            return CancellationSignaller.COMPLETED;
        }
        AtomicBoolean finished = new AtomicBoolean(false);
        CancellationSignaller signaller = new CancellationSignaller(signaller1 -> {
            if (satisfied.get() == 0) {
                // empty if block
            }
            if (finished.compareAndSet(false, true)) {
                this.releaseDependencies(holder, nextStatus);
                signaller1.fireComplete(new CancellationException());
            }
        });
        try {
            KeyStatusPair<K, V, Ctx> keyStatusPair = new KeyStatusPair<K, V, Ctx>(holder.getKey(), nextStatus);
            for (KeyStatusPair<K, V, Ctx> dependency : dependencies) {
                Assertions.assertTrue(!dependency.key().equals(holder.getKey()));
                holder.addDependencyTicket(this, dependency.key(), dependency.status(), () -> {
                    int incrementAndGet = satisfied.incrementAndGet();
                    Assertions.assertTrue(incrementAndGet <= size, "Satisfied more than expected");
                    if (incrementAndGet == size && finished.compareAndSet(false, true)) {
                        this.getExecutor().execute(() -> signaller.fireComplete(null));
                    }
                });
            }
        }
        catch (Throwable t) {
            signaller.fireComplete(t);
        }
        return signaller;
    }

    public ItemHolder<K, V, Ctx, UserData> addTicket(K key, ItemStatus<K, V, Ctx> targetStatus, Runnable callback) {
        return this.addTicket(key, key, targetStatus, callback);
    }

    public ItemHolder<K, V, Ctx, UserData> addTicket(K key, Object source, ItemStatus<K, V, Ctx> targetStatus, Runnable callback) {
        return this.addTicket(key, ItemTicket.TicketType.EXTERNAL, source, targetStatus, callback);
    }

    public ItemHolder<K, V, Ctx, UserData> addTicket(K key, ItemTicket.TicketType type, Object source, ItemStatus<K, V, Ctx> targetStatus, Runnable callback) {
        return this.addTicket0(key, new ItemTicket<K, V, Ctx>(type, source, targetStatus, callback));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ItemHolder<K, V, Ctx, UserData> addTicket0(K key, ItemTicket<K, V, Ctx> ticket) {
        if (this.getUnloadedStatus().equals(ticket.getTargetStatus())) {
            throw new IllegalArgumentException("Cannot add ticket to unloaded status");
        }
        try {
            ItemHolder<K, V, Ctx, UserData> holder;
            while (true) {
                ItemHolder<K, V, Ctx, UserData> itemHolder = holder = this.getOrCreateHolder(key);
                synchronized (itemHolder) {
                    if (holder.isOpen()) break;
                }
            }
            {
                holder.busyRefCounter().incrementRefCount();
            }
            try {
                holder.addTicket(ticket);
                holder.consolidateMarkDirty(this);
                return holder;
            }
            finally {
                holder.busyRefCounter().decrementRefCount();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(t);
        }
    }

    private ItemHolder<K, V, Ctx, UserData> createHolder(K k) {
        ItemHolder holder1 = new ItemHolder(this.getUnloadedStatus(), k, this.objectFactory);
        this.onItemCreation(holder1);
        VarHandle.fullFence();
        return holder1;
    }

    public void removeTicket(K key, ItemStatus<K, V, Ctx> targetStatus) {
        this.removeTicket(key, ItemTicket.TicketType.EXTERNAL, key, targetStatus);
    }

    public void removeTicket(K key, ItemTicket.TicketType type, Object source, ItemStatus<K, V, Ctx> targetStatus) {
        ItemHolder<K, V, Ctx, UserData> holder = this.getHolder(key);
        if (holder == null) {
            throw new IllegalStateException("No such item");
        }
        holder.removeTicket(new ItemTicket<K, V, Ctx>(type, source, targetStatus, null));
        this.markDirty(key);
    }

    private ItemStatus<K, V, Ctx> getNextStatus(ItemStatus<K, V, Ctx> current, ItemStatus<K, V, Ctx> target) {
        Assertions.assertTrue(target != null);
        int compare = Integer.compare(current.ordinal(), target.ordinal());
        if (compare < 0) {
            return current.getNext();
        }
        if (compare == 0) {
            return current;
        }
        return current.getPrev();
    }

    private ExceptionHandlingAction tryHandleTransactionException(ItemHolder<K, V, Ctx, UserData> holder, ItemStatus<K, V, Ctx> nextStatus, boolean isUpgrade, Throwable throwable) {
        if (throwable == null) {
            return ExceptionHandlingAction.PROCEED;
        }
        try {
            return this.handleTransactionException(holder, nextStatus, isUpgrade, throwable);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return ExceptionHandlingAction.MARK_BROKEN;
        }
    }

    private void clearDependencies0(ItemHolder<K, V, Ctx, UserData> holder, ItemStatus<K, V, Ctx> fromStatus) {
        for (int i = fromStatus.ordinal(); i > 0; --i) {
            ItemStatus<K, V, Ctx> status = this.getUnloadedStatus().getAllStatuses()[i];
            this.releaseDependencies(holder, status);
            holder.setDependencies(status, new KeyStatusPair[0]);
        }
    }

    private void releaseDependencies(ItemHolder<K, V, Ctx, UserData> holder, ItemStatus<K, V, Ctx> status) {
        KeyStatusPair<K, V, Ctx>[] dependencies;
        for (KeyStatusPair<K, V, Ctx> dependency : dependencies = holder.getDependencies(status)) {
            holder.removeDependencyTicket(dependency.key(), dependency.status());
        }
        holder.setDependencies(status, null);
    }

    protected boolean hasPendingUpdates() {
        return !this.pendingUpdates.isEmpty();
    }

    protected boolean continueProcessWork() {
        return this.updateSize.get() != 0;
    }
}

