/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps;

import com.minelittlepony.common.util.GamePaths;
import eu.ha3.mc.quick.update.TargettedVersion;
import eu.ha3.mc.quick.update.UpdateChecker;
import eu.ha3.mc.quick.update.UpdaterConfig;
import eu.ha3.presencefootsteps.PFConfig;
import eu.ha3.presencefootsteps.PFDebugHud;
import eu.ha3.presencefootsteps.PFOptionsScreen;
import eu.ha3.presencefootsteps.sound.SoundEngine;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3675;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PresenceFootsteps
implements ClientModInitializer {
    public static final Logger logger = LogManager.getLogger((String)"PFSolver");
    private static final String MODID = "presencefootsteps";
    private static final String KEY_BINDING_CATEGORY = "key.category.presencefootsteps";
    private static final String UPDATER_ENDPOINT = "https://raw.githubusercontent.com/Sollace/Presence-Footsteps/master/version/latest.json";
    public static final class_2561 MOD_NAME = class_2561.method_43471((String)"mod.presencefootsteps.name");
    private static PresenceFootsteps instance;
    private SoundEngine engine;
    private PFConfig config;
    private PFDebugHud debugHud;
    private UpdateChecker updater;
    private class_304 optionsKeyBinding;
    private class_304 toggleKeyBinding;
    private boolean toggleTriggered;
    private final AtomicBoolean configChanged = new AtomicBoolean();

    public static class_2960 id(String name) {
        return class_2960.method_60655((String)MODID, (String)name);
    }

    public static PresenceFootsteps getInstance() {
        return instance;
    }

    public PresenceFootsteps() {
        instance = this;
    }

    public PFDebugHud getDebugHud() {
        return this.debugHud;
    }

    public SoundEngine getEngine() {
        return this.engine;
    }

    public PFConfig getConfig() {
        return this.config;
    }

    public class_304 getOptionsKeyBinding() {
        return this.optionsKeyBinding;
    }

    public UpdateChecker getUpdateChecker() {
        return this.updater;
    }

    public void onInitializeClient() {
        Path pfFolder = GamePaths.getConfigDirectory().resolve(MODID);
        this.updater = new UpdateChecker(new UpdaterConfig(pfFolder.resolve("updater.json")), MODID, UPDATER_ENDPOINT, this::onUpdate);
        this.config = new PFConfig(pfFolder.resolve("userconfig.json"), this);
        this.config.load();
        this.config.onChangedExternally(c -> this.configChanged.set(true));
        this.optionsKeyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.presencefootsteps.settings", class_3675.class_307.field_1668, 299, KEY_BINDING_CATEGORY));
        this.toggleKeyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.presencefootsteps.toggle", class_3675.class_307.field_1668, class_3675.field_16237.method_1444(), KEY_BINDING_CATEGORY));
        this.engine = new SoundEngine(this.config);
        this.debugHud = new PFDebugHud(this.engine);
        ClientTickEvents.END_CLIENT_TICK.register(this::onTick);
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)this.engine);
    }

    private void onTick(class_310 client) {
        class_437 class_4372 = client.field_1755;
        if (class_4372 instanceof PFOptionsScreen) {
            PFOptionsScreen screen = (PFOptionsScreen)class_4372;
            if (this.configChanged.getAndSet(false)) {
                screen.method_25423(client, screen.field_22789, screen.field_22790);
            }
        }
        Optional.ofNullable(client.field_1724).filter(e -> !e.method_31481()).ifPresent(cameraEntity -> {
            if (client.field_1755 == null) {
                if (this.optionsKeyBinding.method_1434()) {
                    client.method_1507((class_437)new PFOptionsScreen(client.field_1755));
                }
                if (this.toggleKeyBinding.method_1434()) {
                    if (!this.toggleTriggered) {
                        this.toggleTriggered = true;
                        this.config.toggleDisabled();
                    }
                } else {
                    this.toggleTriggered = false;
                }
            }
            this.engine.onFrame(client, (class_1297)cameraEntity);
            if (!FabricLoader.getInstance().isModLoaded("modmenu")) {
                this.updater.attempt();
            }
        });
    }

    private void onUpdate(TargettedVersion newVersion, TargettedVersion currentVersion) {
        this.showSystemToast((class_2561)class_2561.method_43471((String)"pf.update.title"), (class_2561)class_2561.method_43469((String)"pf.update.text", (Object[])new Object[]{newVersion.version().getFriendlyString(), newVersion.minecraft().getFriendlyString()}));
    }

    void onEnabledStateChange(boolean enabled) {
        this.engine.reload();
        this.showSystemToast(MOD_NAME, (class_2561)class_2561.method_43471((String)("key.presencefootsteps.toggle." + (enabled ? "enabled" : "disabled"))).method_27692(enabled ? class_124.field_1060 : class_124.field_1080));
    }

    public void showSystemToast(class_2561 title, class_2561 body) {
        class_310 client = class_310.method_1551();
        client.method_1566().method_1999((class_368)class_370.method_29047((class_310)client, (class_370.class_9037)class_370.class_9037.field_47585, (class_2561)title, (class_2561)body));
    }
}

