/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.utils.ProjectionMatrixBackup;
import com.moulberry.axiom.utils.RenderHelper;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Vector4f;

public class ProjectedText {
    private static ProjectionMatrixBackup projectionMatrixBackup = null;
    private static class_327 font;
    private static float scale;
    private static float width;
    private static float height;

    public static void setupProjectedText() {
        if (projectionMatrixBackup != null) {
            if (Axiom.enableAssertions) {
                throw new RuntimeException("finishProjectedText() called without setupProjectedText()");
            }
            return;
        }
        font = class_310.method_1551().field_1772;
        scale = 2.0f * Math.max(1.0f, Math.min(EditorUI.getIO().getDisplayFramebufferScaleX(), EditorUI.getIO().getDisplayFramebufferScaleY()));
        width = (float)class_310.method_1551().method_22683().method_4489() / scale;
        height = (float)class_310.method_1551().method_22683().method_4506() / scale;
        projectionMatrixBackup = ProjectionMatrixBackup.create();
        RenderHelper.setOrthoProjectionMatrix(width, height);
        Matrix4fStack poseStack = RenderSystem.getModelViewStack();
        poseStack.pushMatrix();
        poseStack.identity();
        poseStack.translate(0.0f, 0.0f, -1001.0f);
        RenderHelper.tryApplyModelViewMatrix();
        RenderHelper.pushDisableFog();
    }

    public static void renderProjectedText(String text, class_4587 matrix, Matrix4f projection, float x, float y, float z) {
        if (projectionMatrixBackup == null) {
            if (Axiom.enableAssertions) {
                throw new RuntimeException("renderProjectedText() called without setupProjectedText()");
            }
            return;
        }
        Vector4f transformed = matrix.method_23760().method_23761().transform(new Vector4f(x, y, z, 1.0f));
        transformed = projection.transform(transformed);
        int stringWidth = font.method_1727(text);
        if (transformed.w < 0.0f) {
            return;
        }
        float screenX = (float)Math.round(((transformed.x / transformed.w * 0.5f + 0.5f) * width - (float)stringWidth / 2.0f) * scale) / scale;
        float f = (-transformed.y / transformed.w * 0.5f + 0.5f) * height;
        Objects.requireNonNull(font);
        float screenY = (float)Math.round((f - 9.0f / 2.0f) * scale) / scale;
        font.method_37296(class_2561.method_43470((String)text).method_30937(), screenX, screenY, -3351041, -13420737, new Matrix4f(), (class_4597)class_310.method_1551().method_22940().method_23000(), 0xF000F0);
    }

    public static void finishProjectedText() {
        if (projectionMatrixBackup == null) {
            if (Axiom.enableAssertions) {
                throw new RuntimeException("finishProjectedText() called without setupProjectedText()");
            }
            return;
        }
        class_310.method_1551().method_22940().method_23000().method_22993();
        RenderHelper.popDisableFog();
        Matrix4fStack poseStack = RenderSystem.getModelViewStack();
        poseStack.popMatrix();
        RenderHelper.tryApplyModelViewMatrix();
        projectionMatrixBackup.restore();
        projectionMatrixBackup = null;
    }

    static {
        scale = 0.0f;
        width = 0.0f;
        height = 0.0f;
    }
}

