/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.utils;

public class ColourUtils {
    public static String formatHex(int value) {
        if ((value & 0xFF000000) == 0) {
            return String.format("%06x", value);
        }
        return String.format("%08x", value);
    }

    public static int argbToAbgr(int argb) {
        int red = argb >> 16 & 0xFF;
        int blue = argb & 0xFF;
        return argb & 0xFF00FF00 | blue << 16 | red;
    }

    public static int abgrToArgb(int abgr) {
        int blue = abgr >> 16 & 0xFF;
        int red = abgr & 0xFF;
        return abgr & 0xFF00FF00 | red << 16 | blue;
    }

    public static int blendARGB(int srcColour, int dstColour) {
        float srcA = (float)(srcColour >> 24 & 0xFF) / 255.0f;
        float srcR = (float)(srcColour >> 16 & 0xFF) / 255.0f;
        float srcG = (float)(srcColour >> 8 & 0xFF) / 255.0f;
        float srcB = (float)(srcColour & 0xFF) / 255.0f;
        float dstA = (float)(dstColour >> 24 & 0xFF) / 255.0f;
        float dstR = (float)(dstColour >> 16 & 0xFF) / 255.0f;
        float dstG = (float)(dstColour >> 8 & 0xFF) / 255.0f;
        float dstB = (float)(dstColour & 0xFF) / 255.0f;
        float resultAlpha = 1.0f - (1.0f - dstA) * (1.0f - srcA);
        if ((double)resultAlpha < 1.0E-6) {
            return (int)(resultAlpha * 255.0f) << 24;
        }
        float resultRed = dstR * dstA / resultAlpha + srcR * srcA * (1.0f - dstA) / resultAlpha;
        float resultGreen = dstG * dstA / resultAlpha + srcG * srcA * (1.0f - dstA) / resultAlpha;
        float resultBlue = dstB * dstA / resultAlpha + srcB * srcA * (1.0f - dstA) / resultAlpha;
        return (int)(resultAlpha * 255.0f) << 24 | (int)(resultRed * 255.0f) << 16 | (int)(resultGreen * 255.0f) << 8 | (int)(resultBlue * 255.0f);
    }

    public static void HSBtoRGB(float hue, float saturation, float brightness, float[] rgb) {
        float r = 0.0f;
        float g2 = 0.0f;
        float b = 0.0f;
        if (saturation == 0.0f) {
            g2 = b = brightness * 255.0f;
            r = b;
        } else {
            float h2 = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h2 - (float)Math.floor(h2);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t2 = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h2) {
                case 0: {
                    r = brightness * 255.0f;
                    g2 = t2 * 255.0f;
                    b = p * 255.0f;
                    break;
                }
                case 1: {
                    r = q * 255.0f;
                    g2 = brightness * 255.0f;
                    b = p * 255.0f;
                    break;
                }
                case 2: {
                    r = p * 255.0f;
                    g2 = brightness * 255.0f;
                    b = t2 * 255.0f;
                    break;
                }
                case 3: {
                    r = p * 255.0f;
                    g2 = q * 255.0f;
                    b = brightness * 255.0f;
                    break;
                }
                case 4: {
                    r = t2 * 255.0f;
                    g2 = p * 255.0f;
                    b = brightness * 255.0f;
                    break;
                }
                case 5: {
                    r = brightness * 255.0f;
                    g2 = p * 255.0f;
                    b = q * 255.0f;
                }
            }
        }
        rgb[0] = r;
        rgb[1] = g2;
        rgb[2] = b;
    }

    public static void RGBtoHSB(float r, float g2, float b, float[] hsbvals) {
        float hue;
        float cmin;
        float cmax = Math.max(r, g2);
        if (b > cmax) {
            cmax = b;
        }
        if (b < (cmin = Math.min(r, g2))) {
            cmin = b;
        }
        float brightness = cmax / 255.0f;
        float saturation = cmax != 0.0f ? (cmax - cmin) / cmax : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (cmax - r) / (cmax - cmin);
            float greenc = (cmax - g2) / (cmax - cmin);
            float bluec = (cmax - b) / (cmax - cmin);
            hue = r == cmax ? bluec - greenc : (g2 == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        hsbvals[0] = hue;
        hsbvals[1] = saturation;
        hsbvals[2] = brightness;
    }
}

