/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.slope;

import com.mojang.blaze3d.vertex.VertexFormat;
import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.core_rendering.AxiomBufferUsage;
import com.moulberry.axiom.core_rendering.AxiomDrawBuffer;
import com.moulberry.axiom.core_rendering.AxiomRenderPipelines;
import com.moulberry.axiom.core_rendering.AxiomRenderer;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.tutorial.Tutorial;
import com.moulberry.axiom.editor.widgets.FalloffWidget;
import com.moulberry.axiom.editor.widgets.PresetWidget;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.mask.MaskContext;
import com.moulberry.axiom.mask.MaskElement;
import com.moulberry.axiom.mask.MaskManager;
import com.moulberry.axiom.rasterization.Rasterization3D;
import com.moulberry.axiom.render.ChunkRenderOverrider;
import com.moulberry.axiom.render.VertexConsumerProvider;
import com.moulberry.axiom.render.regions.ChunkedBooleanRegion;
import com.moulberry.axiom.restrictions.AxiomPermission;
import com.moulberry.axiom.tools.HeightmapApplier;
import com.moulberry.axiom.tools.SimpleRadiusAdjustment;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.utils.ProjectedText;
import com.moulberry.axiom.utils.RegionHelper;
import com.moulberry.axiom.utils.RenderHelper;
import imgui.ImGui;
import it.unimi.dsi.fastutil.floats.FloatUnaryOperator;
import java.text.NumberFormat;
import java.util.EnumSet;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_2902;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_9801;
import org.joml.Matrix4f;

public class SlopeTool
implements Tool {
    private final ChunkedBooleanRegion previewRegion = new ChunkedBooleanRegion();
    private int lastPreviewRadius = -1;
    private int lastPreviewHeight = -1;
    private AxiomDrawBuffer gridBuffer = null;
    private final HeightmapApplier heightmapApplier = new HeightmapApplier();
    private boolean usingTool = false;
    private class_2338 lastPosition = null;
    private MaskElement cachedSourceMask = null;
    private MaskContext cachedMaskContext = null;
    private final float[] falloffLut = new float[1057];
    private int falloffLutSize = this.falloffLut.length;
    private class_2338 currentTargetPos = null;
    private class_2338 pendingTargetPos = null;
    private class_243 pendingTargetPosVec3 = null;
    private float coneSlope = 0.0f;
    private class_243 planeNormal = null;
    private double planarK = 0.0;
    private static final int MODE_RAISE = 0;
    private static final int MODE_LOWER = 1;
    private static final int MODE_BOTH_RAISE_LOWER = 2;
    private static final int SHAPE_PLANE = 0;
    private static final int SHAPE_CONE = 1;
    private final int[] radius = new int[]{8};
    private final int[] height = new int[]{63};
    private final float[] smoothing = new float[]{1.0f};
    private final int[] raiseLowerMode = new int[]{0};
    private int shape = 0;
    private final FalloffWidget falloffWidget = new FalloffWidget();
    private final PresetWidget presetWidget = new PresetWidget(this, "slope");
    private final float[] baseRadiusAdjustment = new float[]{0.0f};

    @Override
    public void reset() {
        if (this.usingTool) {
            this.usingTool = false;
            ChunkRenderOverrider.release("slope_tool");
        }
        this.cachedSourceMask = null;
        this.cachedMaskContext = null;
        this.previewRegion.clear();
        this.lastPreviewRadius = -1;
        this.lastPreviewHeight = -1;
        this.pendingTargetPos = null;
        this.pendingTargetPosVec3 = null;
        this.lastPosition = null;
        this.planeNormal = null;
        this.planarK = 0.0;
        this.coneSlope = 0.0f;
        this.heightmapApplier.reset(this.smoothing[0]);
        if (this.gridBuffer != null) {
            this.gridBuffer.close();
            this.gridBuffer = null;
        }
    }

    @Override
    public void toolDeselected() {
        this.falloffWidget.unload();
    }

    @Override
    public UserAction.ActionResult callAction(UserAction action, Object object) {
        switch (action) {
            case ESCAPE: 
            case DELETE: {
                if (this.pendingTargetPos == null && !this.usingTool) break;
                this.reset();
                return UserAction.ActionResult.USED_STOP;
            }
            case RIGHT_MOUSE: {
                RayCaster.RaycastResult result = Tool.raycastBlock(false, false, false);
                if (result == null) {
                    return UserAction.ActionResult.USED_STOP;
                }
                if (this.pendingTargetPos == null) {
                    this.pendingTargetPos = result.blockPos();
                    this.pendingTargetPosVec3 = result.worldPos();
                    return UserAction.ActionResult.USED_STOP;
                }
                this.currentTargetPos = this.pendingTargetPos;
                this.reset();
                class_243 first = class_243.method_24953((class_2382)this.currentTargetPos);
                class_243 second = class_243.method_24953((class_2382)result.blockPos());
                if (this.shape == 0) {
                    if (first.method_1022(second) < 0.5) {
                        this.planeNormal = new class_243(0.0, 1.0, 0.0);
                    } else {
                        dx = first.field_1352 - second.field_1352;
                        dy = first.field_1351 - second.field_1351;
                        dz = first.field_1350 - second.field_1350;
                        if (dy == 0.0) {
                            this.planeNormal = new class_243(0.0, 1.0, 0.0);
                        } else {
                            double horzDist = Math.sqrt(dx * dx + dz * dz);
                            this.planeNormal = new class_243(dx / horzDist, -1.0 / (dy / horzDist), dz / horzDist).method_1029();
                        }
                    }
                    this.planarK = -(first.field_1352 * this.planeNormal.field_1352 + first.field_1351 * this.planeNormal.field_1351 + first.field_1350 * this.planeNormal.field_1350);
                } else {
                    dx = first.field_1352 - second.field_1352;
                    dy = first.field_1351 - second.field_1351;
                    dz = first.field_1350 - second.field_1350;
                    this.coneSlope = (float)(dy / Math.sqrt(dx * dx + dz * dz));
                }
                int radius = this.radius[0];
                this.falloffLutSize = Math.min(this.falloffLut.length, radius * radius + radius + 1);
                FloatUnaryOperator operator = this.falloffWidget.getFalloffFunction();
                for (int i = 0; i < this.falloffLutSize; ++i) {
                    double distance = Math.sqrt(i) / Math.sqrt(this.falloffLutSize - 1);
                    this.falloffLut[i] = operator.apply((float)distance);
                }
                if (!this.usingTool) {
                    this.usingTool = true;
                    ChunkRenderOverrider.acquire("slope_tool");
                }
                return UserAction.ActionResult.USED_STOP;
            }
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    @Override
    public void render(class_4184 camera, float tickDelta, long time, class_4587 matrix, Matrix4f projection) {
        Selection.render(camera, time, matrix, projection, 4);
        if (!this.usingTool) {
            RayCaster.RaycastResult result = Tool.raycastBlock(false, false, false);
            if (result == null) {
                return;
            }
            int radius = this.radius[0];
            int height = this.height[0];
            if (this.lastPreviewRadius != radius || this.lastPreviewHeight != height) {
                this.lastPreviewRadius = radius;
                this.lastPreviewHeight = height;
                this.previewRegion.clear();
                float maxRadiusSq = ((float)radius + 0.5f) * ((float)radius + 0.5f);
                for (int x2 = -radius; x2 <= radius; ++x2) {
                    for (int z2 = -radius; z2 <= radius; ++z2) {
                        if (!((float)(x2 * x2 + z2 * z2) < maxRadiusSq)) continue;
                        for (int y2 = -height; y2 <= height; ++y2) {
                            this.previewRegion.add(x2, y2, z2);
                        }
                    }
                }
            }
            if (this.pendingTargetPos != null) {
                this.previewRegion.render(camera, class_243.method_24954((class_2382)result.getBlockPos()), matrix, projection, time, 2);
                this.renderTargetTrianglePreview(camera, matrix, projection, result);
            } else {
                this.previewRegion.render(camera, class_243.method_24954((class_2382)result.getBlockPos()), matrix, projection, time, 3);
            }
        } else if (Tool.cancelUsing()) {
            this.reset();
        } else if (!Tool.isMouseDown(1)) {
            String countString = NumberFormat.getInstance().format(this.heightmapApplier.blockRegion.count());
            String historyDescription = AxiomI18n.get("axiom.history_description.slope_tool", countString);
            RegionHelper.pushBlockRegionChange(this.heightmapApplier.blockRegion, historyDescription);
            this.reset();
        } else {
            class_638 level = class_310.method_1551().field_1687;
            if (level == null) {
                return;
            }
            class_746 player = class_310.method_1551().field_1724;
            if (player == null) {
                return;
            }
            int radius = this.radius[0];
            int height = this.height[0];
            class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
            class_243 lookFrom = player.method_33571();
            class_243 look = Tool.getLookDirection();
            if (look != null) {
                double t2;
                if (this.shape == 0) {
                    float y0 = -((float)((lookFrom.field_1352 * this.planeNormal.field_1352 + lookFrom.field_1350 * this.planeNormal.field_1350 + this.planarK) / this.planeNormal.field_1351));
                    double denom = this.planeNormal.field_1352 * look.field_1352 + this.planeNormal.field_1351 * look.field_1351 + this.planeNormal.field_1350 * look.field_1350;
                    t2 = Math.abs(denom) > (double)1.0E-5f ? ((double)y0 - lookFrom.field_1351) * this.planeNormal.field_1351 / denom : Double.NaN;
                } else {
                    class_243 from = lookFrom.method_1023((double)((float)this.currentTargetPos.method_10263() + 0.5f), (double)((float)this.currentTargetPos.method_10264() + 0.5f), (double)((float)this.currentTargetPos.method_10260() + 0.5f));
                    double c = from.field_1351 * from.field_1351 - (double)(this.coneSlope * this.coneSlope) * (from.field_1352 * from.field_1352 + from.field_1350 * from.field_1350);
                    double b = 2.0 * look.field_1351 * from.field_1351 - (double)(this.coneSlope * this.coneSlope) * (2.0 * look.field_1352 * from.field_1352 + 2.0 * look.field_1350 * from.field_1350);
                    double a = look.field_1351 * look.field_1351 - (double)(this.coneSlope * this.coneSlope) * (look.field_1352 * look.field_1352 + look.field_1350 * look.field_1350);
                    if (Math.abs(a) < 1.0E-5) {
                        t2 = Double.NaN;
                    } else {
                        double discrim = b * b - 4.0 * a * c;
                        if (Math.abs(discrim) < 1.0E-5) {
                            t2 = -b / (2.0 * a);
                            if (t2 < 0.0 || from.field_1351 + t2 * look.field_1351 < 0.0 == this.coneSlope < 0.0f) {
                                t2 = Double.NaN;
                            }
                        } else if (discrim < 0.0) {
                            t2 = Double.NaN;
                        } else {
                            double sqrt2 = Math.sqrt(discrim);
                            double t1 = (-b + sqrt2) / (2.0 * a);
                            double t22 = (-b - sqrt2) / (2.0 * a);
                            if (t1 < 0.0 || from.field_1351 + t1 * look.field_1351 < 0.0 == this.coneSlope < 0.0f) {
                                t1 = Double.NaN;
                            }
                            if (t22 < 0.0 || from.field_1351 + t22 * look.field_1351 < 0.0 == this.coneSlope < 0.0f) {
                                t22 = Double.NaN;
                            }
                            t2 = !Double.isFinite(t1) ? t22 : (!Double.isFinite(t22) ? t1 : Math.min(t1, t22));
                        }
                    }
                }
                if (t2 > 0.0 && t2 < 1024.0) {
                    int intersectionX = (int)Math.round(lookFrom.field_1352 + t2 * look.field_1352);
                    int intersectionY = (int)Math.round(lookFrom.field_1351 + t2 * look.field_1351);
                    int intersectionZ = (int)Math.round(lookFrom.field_1350 + t2 * look.field_1350);
                    if (this.lastPosition == null) {
                        this.apply(level, radius, height, mutableBlockPos, intersectionX, intersectionY, intersectionZ);
                        this.lastPosition = new class_2338(intersectionX, intersectionY, intersectionZ);
                    } else {
                        class_2338 newPosition = new class_2338(intersectionX, intersectionY, intersectionZ);
                        Rasterization3D.ddaSkipFrom(this.lastPosition, newPosition, (x, y, z) -> this.apply(level, radius, height, mutableBlockPos, x, y, z));
                        this.lastPosition = newPosition;
                    }
                } else {
                    this.lastPosition = null;
                }
            }
            if (this.currentTargetPos != null) {
                if (this.gridBuffer == null) {
                    this.renderGridBuffer();
                }
                matrix.method_22903();
                matrix.method_22904((double)this.currentTargetPos.method_10263() - camera.method_19326().field_1352, (double)this.currentTargetPos.method_10264() - camera.method_19326().field_1351, (double)this.currentTargetPos.method_10260() - camera.method_19326().field_1350);
                RenderHelper.pushModelViewMatrix(matrix.method_23760().method_23761());
                RenderHelper.pushDisableFog();
                AxiomRenderPipelines.LINES_WITHOUT_WRITE_DEPTH.render(this.gridBuffer);
                RenderHelper.popDisableFog();
                RenderHelper.popModelViewStack();
            }
            matrix.method_22909();
            float opacity = (float)Math.sin((float)time / 1000000.0f / 50.0f / 8.0f);
            this.heightmapApplier.update();
            this.heightmapApplier.blockRegion.render(camera, class_243.field_1353, matrix, projection, 0.75f + opacity * 0.25f, 0.3f - opacity * 0.2f);
            this.heightmapApplier.removeRegion.render(camera, class_243.field_1353, matrix, projection, time, 8);
        }
    }

    private void renderTargetTrianglePreview(class_4184 camera, class_4587 matrix, Matrix4f projection, RayCaster.RaycastResult result) {
        class_243 from = this.pendingTargetPosVec3;
        class_243 to = result.worldPos();
        class_243 mid = from.method_35590(to, 0.5);
        from = from.method_1020(mid);
        to = to.method_1020(mid);
        double dx = to.field_1352 - from.field_1352;
        double dy = to.field_1351 - from.field_1351;
        double dz = to.field_1350 - from.field_1350;
        double horzDist = Math.sqrt(dx * dx + dz * dz);
        double dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
        float nx = (float)(dx / dist);
        float ny = (float)(dy / dist);
        float nz = (float)(dz / dist);
        float nxh = (float)(dx / horzDist);
        float nzh = (float)(dz / horzDist);
        matrix.method_22903();
        matrix.method_22904(mid.field_1352 - camera.method_19326().field_1352, mid.field_1351 - camera.method_19326().field_1351, mid.field_1350 - camera.method_19326().field_1350);
        class_4587.class_4665 pose = matrix.method_23760();
        VertexConsumerProvider provider = VertexConsumerProvider.shared();
        class_287 bufferBuilder = provider.begin(VertexFormat.class_5596.field_27377, class_290.field_29337);
        bufferBuilder.method_56824(pose, (float)from.field_1352, (float)from.field_1351, (float)from.field_1350).method_39415(-2147418368).method_60831(pose, nx, ny, nz);
        bufferBuilder.method_56824(pose, (float)to.field_1352, (float)to.field_1351, (float)to.field_1350).method_39415(-2147418368).method_60831(pose, nx, ny, nz);
        bufferBuilder.method_56824(pose, (float)from.field_1352, (float)from.field_1351, (float)from.field_1350).method_39415(-2147418368).method_60831(pose, 0.0f, 1.0f, 0.0f);
        bufferBuilder.method_56824(pose, (float)from.field_1352, (float)to.field_1351, (float)from.field_1350).method_39415(-2147418368).method_60831(pose, 0.0f, 1.0f, 0.0f);
        bufferBuilder.method_56824(pose, (float)from.field_1352, (float)to.field_1351, (float)from.field_1350).method_39415(-2147418368).method_60831(pose, nxh, 0.0f, nzh);
        bufferBuilder.method_56824(pose, (float)to.field_1352, (float)to.field_1351, (float)to.field_1350).method_39415(-2147418368).method_60831(pose, nxh, 0.0f, nzh);
        class_9801 meshData = bufferBuilder.method_60794();
        AxiomRenderer.setShaderColour(1.0f, 1.0f, 1.0f, 1.0f);
        AxiomRenderer.renderPipeline(AxiomRenderPipelines.LINES_WITHOUT_WRITE_DEPTH, null, meshData, false);
        AxiomRenderer.setShaderColour(0.66f, 0.66f, 0.66f, 0.875f);
        AxiomRenderer.renderPipeline(AxiomRenderPipelines.LINES_IGNORE_DEPTH, null, meshData, true);
        AxiomRenderer.setShaderColour(1.0f, 1.0f, 1.0f, 1.0f);
        this.renderInfoText(matrix, projection, result, from, to);
        matrix.method_22909();
    }

    private void renderInfoText(class_4587 matrix, Matrix4f projection, RayCaster.RaycastResult result, class_243 from, class_243 to) {
        int dz;
        int dx;
        float targetHorizontalDistance;
        ProjectedText.setupProjectedText();
        int targetHeight = Math.abs(this.pendingTargetPos.method_10264() - result.getBlockPos().method_10264());
        if (targetHeight > 0) {
            ProjectedText.renderProjectedText(String.valueOf(targetHeight), matrix, projection, (float)from.field_1352, (float)(from.field_1351 + to.field_1351) / 2.0f, (float)from.field_1350);
        }
        if ((targetHorizontalDistance = (float)Math.sqrt((dx = this.pendingTargetPos.method_10263() - result.getBlockPos().method_10263()) * dx + (dz = this.pendingTargetPos.method_10260() - result.getBlockPos().method_10260()) * dz)) > 0.0f) {
            ProjectedText.renderProjectedText(String.format("%.2f", Float.valueOf(targetHorizontalDistance)), matrix, projection, (float)(from.field_1352 + to.field_1352) / 2.0f, (float)to.field_1351, (float)(from.field_1350 + to.field_1350) / 2.0f);
        }
        float targetAngle = (float)Math.abs(Math.atan2(targetHeight, targetHorizontalDistance));
        ProjectedText.renderProjectedText(String.format("%.2f\u00b0", Math.toDegrees(targetAngle)), matrix, projection, (float)(from.field_1352 + to.field_1352) / 2.0f, (float)(from.field_1351 + to.field_1351) / 2.0f, (float)(from.field_1350 + to.field_1350) / 2.0f);
        ProjectedText.finishProjectedText();
    }

    private void renderGridBuffer() {
        class_9801 meshData;
        if (this.gridBuffer == null) {
            this.gridBuffer = new AxiomDrawBuffer(AxiomBufferUsage.STATIC_WRITE);
        }
        VertexConsumerProvider provider = VertexConsumerProvider.shared();
        class_287 bufferBuilder = provider.begin(VertexFormat.class_5596.field_27377, class_290.field_29337);
        int horzColour = -1438588720;
        int vertColour = -2147418368;
        if (this.shape == 0) {
            float nz;
            float ny;
            float nx;
            float distance;
            float dz;
            float dy;
            float dx;
            float y2;
            float y1;
            float z2;
            float z1;
            float x2;
            float x1;
            double angle = Math.atan2(this.planeNormal.field_1352, this.planeNormal.field_1350);
            for (int h2 = -256; h2 <= 256; h2 += 8) {
                x1 = (float)((double)h2 * Math.sin(angle) - 256.0 * Math.cos(angle));
                x2 = (float)((double)h2 * Math.sin(angle) + 256.0 * Math.cos(angle));
                z1 = (float)((double)h2 * Math.cos(angle) + 256.0 * Math.sin(angle));
                z2 = (float)((double)h2 * Math.cos(angle) - 256.0 * Math.sin(angle));
                x1 = (float)((double)x1 + ((double)this.currentTargetPos.method_10263() + 0.5));
                x2 = (float)((double)x2 + ((double)this.currentTargetPos.method_10263() + 0.5));
                z1 = (float)((double)z1 + ((double)this.currentTargetPos.method_10260() + 0.5));
                z2 = (float)((double)z2 + ((double)this.currentTargetPos.method_10260() + 0.5));
                y1 = -((float)((((double)x1 + 0.5) * this.planeNormal.field_1352 + ((double)z1 + 0.5) * this.planeNormal.field_1350 + this.planarK) / this.planeNormal.field_1351)) - (float)this.currentTargetPos.method_10264();
                y2 = -((float)((((double)x2 + 0.5) * this.planeNormal.field_1352 + ((double)z2 + 0.5) * this.planeNormal.field_1350 + this.planarK) / this.planeNormal.field_1351)) - (float)this.currentTargetPos.method_10264();
                dx = (x2 -= (float)this.currentTargetPos.method_10263()) - (x1 -= (float)this.currentTargetPos.method_10263());
                dy = y2 - y1;
                dz = (z2 -= (float)this.currentTargetPos.method_10260()) - (z1 -= (float)this.currentTargetPos.method_10260());
                distance = (float)Math.sqrt(dx * dx + dz * dz + dy * dy);
                nx = dx / distance;
                ny = dy / distance;
                nz = dz / distance;
                bufferBuilder.method_22912(x1, y1, z1).method_39415(horzColour).method_22914(nx, ny, nz);
                bufferBuilder.method_22912(x1 + dx * 0.25f, y1 + dy * 0.25f, z1 + dz * 0.25f).method_39415(horzColour).method_22914(nx, ny, nz);
                bufferBuilder.method_22912(x1 + dx * 0.25f, y1 + dy * 0.25f, z1 + dz * 0.25f).method_39415(horzColour).method_22914(nx, ny, nz);
                bufferBuilder.method_22912(x1 + dx * 0.5f, y1 + dy * 0.5f, z1 + dz * 0.5f).method_39415(horzColour).method_22914(nx, ny, nz);
                bufferBuilder.method_22912(x1 + dx * 0.5f, y1 + dy * 0.5f, z1 + dz * 0.5f).method_39415(horzColour).method_22914(nx, ny, nz);
                bufferBuilder.method_22912(x1 + dx * 0.75f, y1 + dy * 0.75f, z1 + dz * 0.75f).method_39415(horzColour).method_22914(nx, ny, nz);
                bufferBuilder.method_22912(x1 + dx * 0.75f, y1 + dy * 0.75f, z1 + dz * 0.75f).method_39415(horzColour).method_22914(nx, ny, nz);
                bufferBuilder.method_22912(x2, y2, z2).method_39415(horzColour).method_22914(nx, ny, nz);
            }
            angle += 1.5707963267948966;
            for (int v = -256; v <= 256; v += 8) {
                x1 = (float)((double)v * Math.sin(angle) - 256.0 * Math.cos(angle));
                x2 = (float)((double)v * Math.sin(angle) + 256.0 * Math.cos(angle));
                z1 = (float)((double)v * Math.cos(angle) + 256.0 * Math.sin(angle));
                z2 = (float)((double)v * Math.cos(angle) - 256.0 * Math.sin(angle));
                x1 = (float)((double)x1 + ((double)this.currentTargetPos.method_10263() + 0.5));
                x2 = (float)((double)x2 + ((double)this.currentTargetPos.method_10263() + 0.5));
                z1 = (float)((double)z1 + ((double)this.currentTargetPos.method_10260() + 0.5));
                z2 = (float)((double)z2 + ((double)this.currentTargetPos.method_10260() + 0.5));
                y1 = -((float)((((double)x1 + 0.5) * this.planeNormal.field_1352 + ((double)z1 + 0.5) * this.planeNormal.field_1350 + this.planarK) / this.planeNormal.field_1351)) - (float)this.currentTargetPos.method_10264();
                y2 = -((float)((((double)x2 + 0.5) * this.planeNormal.field_1352 + ((double)z2 + 0.5) * this.planeNormal.field_1350 + this.planarK) / this.planeNormal.field_1351)) - (float)this.currentTargetPos.method_10264();
                dx = (x2 -= (float)this.currentTargetPos.method_10263()) - (x1 -= (float)this.currentTargetPos.method_10263());
                dy = y2 - y1;
                dz = (z2 -= (float)this.currentTargetPos.method_10260()) - (z1 -= (float)this.currentTargetPos.method_10260());
                distance = (float)Math.sqrt(dx * dx + dz * dz + dy * dy);
                nx = dx / distance;
                ny = dy / distance;
                nz = dz / distance;
                bufferBuilder.method_22912(x1, y1, z1).method_39415(vertColour).method_22914(nx, ny, nz);
                bufferBuilder.method_22912(x1 + dx * 0.25f, y1 + dy * 0.25f, z1 + dz * 0.25f).method_39415(vertColour).method_22914(nx, ny, nz);
                bufferBuilder.method_22912(x1 + dx * 0.25f, y1 + dy * 0.25f, z1 + dz * 0.25f).method_39415(vertColour).method_22914(nx, ny, nz);
                bufferBuilder.method_22912(x1 + dx * 0.5f, y1 + dy * 0.5f, z1 + dz * 0.5f).method_39415(vertColour).method_22914(nx, ny, nz);
                bufferBuilder.method_22912(x1 + dx * 0.5f, y1 + dy * 0.5f, z1 + dz * 0.5f).method_39415(vertColour).method_22914(nx, ny, nz);
                bufferBuilder.method_22912(x1 + dx * 0.75f, y1 + dy * 0.75f, z1 + dz * 0.75f).method_39415(vertColour).method_22914(nx, ny, nz);
                bufferBuilder.method_22912(x1 + dx * 0.75f, y1 + dy * 0.75f, z1 + dz * 0.75f).method_39415(vertColour).method_22914(nx, ny, nz);
                bufferBuilder.method_22912(x2, y2, z2).method_39415(vertColour).method_22914(nx, ny, nz);
            }
        } else {
            for (int angle = 0; angle < 360; angle += 8) {
                float dx;
                float z2;
                float sin2 = (float)Math.sin(Math.toRadians(angle));
                float cos2 = (float)Math.cos(Math.toRadians(angle));
                float sinPlus8 = (float)Math.sin(Math.toRadians(angle + 8));
                float cosPlus8 = (float)Math.cos(Math.toRadians(angle + 8));
                for (int v = 8; v <= 256; v += 8) {
                    float y = 0.5f - this.coneSlope * (float)v;
                    float x1 = 0.5f + (float)v * sin2;
                    float z1 = 0.5f + (float)v * cos2;
                    float x2 = 0.5f + (float)v * sinPlus8;
                    z2 = 0.5f + (float)v * cosPlus8;
                    dx = x2 - x1;
                    float dz = z2 - z1;
                    float distance = (float)Math.sqrt(dx * dx + dz * dz);
                    float nx = dx / distance;
                    float nz = dz / distance;
                    bufferBuilder.method_22912(x1, y, z1).method_39415(horzColour).method_22914(nx, 0.0f, nz);
                    bufferBuilder.method_22912(x1 + dx * 0.25f, y, z1 + dz * 0.25f).method_39415(horzColour).method_22914(nx, 0.0f, nz);
                    bufferBuilder.method_22912(x1 + dx * 0.25f, y, z1 + dz * 0.25f).method_39415(horzColour).method_22914(nx, 0.0f, nz);
                    bufferBuilder.method_22912(x1 + dx * 0.5f, y, z1 + dz * 0.5f).method_39415(horzColour).method_22914(nx, 0.0f, nz);
                    bufferBuilder.method_22912(x1 + dx * 0.5f, y, z1 + dz * 0.5f).method_39415(horzColour).method_22914(nx, 0.0f, nz);
                    bufferBuilder.method_22912(x1 + dx * 0.75f, y, z1 + dz * 0.75f).method_39415(horzColour).method_22914(nx, 0.0f, nz);
                    bufferBuilder.method_22912(x1 + dx * 0.75f, y, z1 + dz * 0.75f).method_39415(horzColour).method_22914(nx, 0.0f, nz);
                    bufferBuilder.method_22912(x2, y, z2).method_39415(horzColour).method_22914(nx, 0.0f, nz);
                }
                float x1 = 0.5f;
                float y1 = 0.5f;
                float z1 = 0.5f;
                float x2 = x1 + 256.0f * sin2;
                float y2 = y1 - this.coneSlope * 256.0f;
                z2 = z1 + 256.0f * cos2;
                dx = x2 - x1;
                float dy = y2 - y1;
                float dz = z2 - z1;
                float distance = (float)Math.sqrt(dx * dx + dz * dz + dy * dy);
                float nx = dx / distance;
                float ny = dy / distance;
                float nz = dz / distance;
                bufferBuilder.method_22912(x1, y1, z1).method_39415(vertColour).method_22914(nx, ny, nz);
                bufferBuilder.method_22912(x1 + dx * 0.25f, y1 + dy * 0.25f, z1 + dz * 0.25f).method_39415(vertColour).method_22914(nx, ny, nz);
                bufferBuilder.method_22912(x1 + dx * 0.25f, y1 + dy * 0.25f, z1 + dz * 0.25f).method_39415(vertColour).method_22914(nx, ny, nz);
                bufferBuilder.method_22912(x1 + dx * 0.5f, y1 + dy * 0.5f, z1 + dz * 0.5f).method_39415(vertColour).method_22914(nx, ny, nz);
                bufferBuilder.method_22912(x1 + dx * 0.5f, y1 + dy * 0.5f, z1 + dz * 0.5f).method_39415(vertColour).method_22914(nx, ny, nz);
                bufferBuilder.method_22912(x1 + dx * 0.75f, y1 + dy * 0.75f, z1 + dz * 0.75f).method_39415(vertColour).method_22914(nx, ny, nz);
                bufferBuilder.method_22912(x1 + dx * 0.75f, y1 + dy * 0.75f, z1 + dz * 0.75f).method_39415(vertColour).method_22914(nx, ny, nz);
                bufferBuilder.method_22912(x2, y2, z2).method_39415(vertColour).method_22914(nx, ny, nz);
            }
        }
        if ((meshData = bufferBuilder.method_60794()) != null) {
            this.gridBuffer.upload(meshData);
        }
    }

    private void apply(class_638 level, int maxRadius, int height, class_2338.class_2339 mutableBlockPos, int x, int y, int z) {
        float maxRadiusSq = ((float)maxRadius + 0.5f) * ((float)maxRadius + 0.5f);
        float expandedMaxRadiusSq = ((float)maxRadius + 1.5f) * ((float)maxRadius + 1.5f);
        if (this.cachedSourceMask == null) {
            this.cachedSourceMask = MaskManager.getSourceMask();
            this.cachedMaskContext = new MaskContext((class_1937)level);
        }
        for (int xo = -maxRadius - 1; xo <= maxRadius + 1; ++xo) {
            block1: for (int zo = -maxRadius - 1; zo <= maxRadius + 1; ++zo) {
                int startY;
                double desiredY;
                int radiusSq = xo * xo + zo * zo;
                if (!((float)radiusSq <= expandedMaxRadiusSq)) continue;
                if (this.shape == 0) {
                    desiredY = -(((double)(x + xo) + 0.5) * this.planeNormal.field_1352 + ((double)(z + zo) + 0.5) * this.planeNormal.field_1350 + this.planarK) / this.planeNormal.field_1351;
                } else {
                    int dx = x + xo - this.currentTargetPos.method_10263();
                    int dz = z + zo - this.currentTargetPos.method_10260();
                    desiredY = 0.5 + (double)this.currentTargetPos.method_10264() - (double)this.coneSlope * Math.sqrt(dx * dx + dz * dz);
                }
                int currentOriginalHeight = this.heightmapApplier.getOriginalY(x + xo, z + zo);
                if (currentOriginalHeight != Integer.MIN_VALUE) {
                    double oldDesiredDelta;
                    if (!((float)radiusSq <= maxRadiusSq)) continue;
                    float falloff = this.falloffLut[radiusSq * (this.falloffLutSize - 1) / (maxRadius * maxRadius + maxRadius)];
                    int newY = (int)Math.floor(((double)currentOriginalHeight + 0.5) * (double)(1.0f - falloff) + desiredY * (double)falloff);
                    if (this.raiseLowerMode[0] == 0) {
                        newY = Math.max(newY, currentOriginalHeight);
                    } else if (this.raiseLowerMode[0] == 1) {
                        newY = Math.min(newY, currentOriginalHeight);
                    }
                    int oldModifiedHeight = this.heightmapApplier.getModifiedY(x + xo, z + zo);
                    if (oldModifiedHeight == Integer.MIN_VALUE) {
                        this.heightmapApplier.setModifiedY(x + xo, z + zo, newY);
                        continue;
                    }
                    double newDesiredDelta = Math.abs((double)newY - desiredY);
                    if (!(newDesiredDelta < (oldDesiredDelta = Math.abs((double)oldModifiedHeight - desiredY)))) continue;
                    this.heightmapApplier.setModifiedY(x + xo, z + zo, newY);
                    continue;
                }
                int motionBlockingHeight = level.method_8624(class_2902.class_2903.field_13197, x + xo, z + zo);
                for (int h2 = startY = Math.min(motionBlockingHeight, y + height); h2 >= y - height; --h2) {
                    mutableBlockPos.method_10103(x + xo, h2, z + zo);
                    class_2680 block = level.method_8320((class_2338)mutableBlockPos);
                    if (!block.method_51366()) continue;
                    if ((float)radiusSq <= maxRadiusSq && this.cachedSourceMask.test(this.cachedMaskContext.reset(), x + xo, h2, z + zo)) {
                        float falloff = this.falloffLut[radiusSq * (this.falloffLutSize - 1) / (maxRadius * maxRadius + maxRadius)];
                        int newY = (int)Math.floor(((double)h2 + 0.5) * (double)(1.0f - falloff) + desiredY * (double)falloff);
                        if (this.raiseLowerMode[0] == 0) {
                            newY = Math.max(newY, h2);
                        } else if (this.raiseLowerMode[0] == 1) {
                            newY = Math.min(newY, h2);
                        }
                        this.heightmapApplier.setOriginalY(x + xo, z + zo, h2);
                        this.heightmapApplier.setModifiedY(x + xo, z + zo, newY);
                        continue block1;
                    }
                    int oldModifiedY = this.heightmapApplier.getModifiedY(x + xo, z + zo);
                    if (oldModifiedY != Integer.MIN_VALUE && oldModifiedY <= h2) continue block1;
                    this.heightmapApplier.setModifiedY(x + xo, z + zo, h2);
                    continue block1;
                }
                int temporaryHeight = Math.min(motionBlockingHeight, y - height - 1);
                int oldModifiedY = this.heightmapApplier.getModifiedY(x + xo, z + zo);
                if (oldModifiedY != Integer.MIN_VALUE && oldModifiedY <= temporaryHeight) continue;
                this.heightmapApplier.setModifiedY(x + xo, z + zo, temporaryHeight);
            }
        }
    }

    @Override
    public void displayImguiOptions() {
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.generic.brush"));
        boolean changed = ImGui.sliderInt(AxiomI18n.get("axiom.tool.generic.brush_radius"), this.radius, 1, 32);
        int[] modifiedHeight = new int[]{this.height[0] + 1};
        changed |= ImGui.sliderInt(AxiomI18n.get("axiom.tool.heightmap.y_limit"), modifiedHeight, 1, 64);
        this.height[0] = modifiedHeight[0] - 1;
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.slope"));
        changed |= ImGuiHelper.combo(AxiomI18n.get("axiom.tool.elevation.mode"), this.raiseLowerMode, new String[]{AxiomI18n.get("axiom.tool.elevation.raise"), AxiomI18n.get("axiom.tool.elevation.lower"), AxiomI18n.get("axiom.tool.elevation.raise_and_lower")});
        changed |= ImGui.sliderFloat(AxiomI18n.get("axiom.tool.heightmap.smoothing"), this.smoothing, 0.0f, 1.0f);
        int newShape = -1;
        if (this.shape == 0) {
            ImGui.beginDisabled();
        }
        if (ImGui.button(AxiomI18n.get("axiom.tool.slope.shape_plane"))) {
            newShape = 0;
        }
        if (this.shape == 0) {
            ImGui.endDisabled();
        }
        ImGui.sameLine();
        if (this.shape == 1) {
            ImGui.beginDisabled();
        }
        if (ImGui.button(AxiomI18n.get("axiom.tool.slope.shape_cone"))) {
            newShape = 1;
        }
        if (this.shape == 1) {
            ImGui.endDisabled();
        }
        ImGui.sameLine();
        ImGui.text(AxiomI18n.get("axiom.tool.slope.shape"));
        if (newShape != -1) {
            this.shape = newShape;
            changed = true;
        }
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.heightmap.falloff"));
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.widget.presets"));
        this.presetWidget.displayImgui(changed |= this.falloffWidget.displayImgui());
    }

    @Override
    public String listenForEsc() {
        if (this.pendingTargetPos != null || this.usingTool) {
            return AxiomI18n.get("axiom.widget.cancel");
        }
        return null;
    }

    @Override
    public boolean initiateAdjustment() {
        return SimpleRadiusAdjustment.initiateAdjustment(this.radius, this.baseRadiusAdjustment);
    }

    @Override
    public class_241 renderAdjustment(float mouseX, float mouseY, class_241 mouseDelta) {
        return SimpleRadiusAdjustment.renderAdjustment(mouseX, mouseY, mouseDelta, 32, this.radius, this.baseRadiusAdjustment);
    }

    @Override
    public String name() {
        return AxiomI18n.get("axiom.tool.slope");
    }

    @Override
    public Tutorial getTutorial() {
        return Tutorial.SLOPE_TOOL;
    }

    @Override
    public void writeSettings(class_2487 tag) {
        this.falloffWidget.writeSettings(tag);
        tag.method_10569("BrushRadius", this.radius[0]);
        tag.method_10569("Height", this.height[0]);
        tag.method_10548("Smoothing", this.smoothing[0]);
        tag.method_10567("RaiseLowerMode", (byte)this.raiseLowerMode[0]);
        tag.method_10567("Shape", (byte)this.shape);
    }

    @Override
    public void loadSettings(class_2487 tag) {
        this.falloffWidget.loadSettings(tag);
        this.radius[0] = tag.method_68083("BrushRadius", 8);
        this.height[0] = tag.method_68083("Height", 63);
        this.smoothing[0] = tag.method_66563("Smoothing", 1.0f);
        this.raiseLowerMode[0] = tag.method_68083("RaiseLowerMode", 0);
        this.shape = tag.method_68083("Shape", 0);
    }

    @Override
    public char iconChar() {
        return '\ue918';
    }

    @Override
    public String keybindId() {
        return "slope";
    }

    @Override
    public EnumSet<AxiomPermission> requiredPermissions() {
        return EnumSet.of(AxiomPermission.TOOL_SLOPE, AxiomPermission.BUILD_SECTION);
    }
}

