/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.noise_painter;

import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.block_maps.FamilyMap;
import com.moulberry.axiom.brush_shapes.BrushShape;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.custom_blocks.CustomBlockState;
import com.moulberry.axiom.custom_blocks.ServerCustomBlocks;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.widgets.BrushWidget;
import com.moulberry.axiom.editor.widgets.PresetWidget;
import com.moulberry.axiom.editor.widgets.SelectBlockWidget;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.mask.MaskContext;
import com.moulberry.axiom.mask.MaskElement;
import com.moulberry.axiom.mask.MaskManager;
import com.moulberry.axiom.noise.FBMNoise;
import com.moulberry.axiom.noise.MetaballNoise;
import com.moulberry.axiom.noise.NoiseInterface;
import com.moulberry.axiom.noise.SimplexNoise;
import com.moulberry.axiom.noise.SplatterNoise;
import com.moulberry.axiom.noise.VoronoiEdgesNoise;
import com.moulberry.axiom.noise.WhiteNoise;
import com.moulberry.axiom.noise.WorleyNoise;
import com.moulberry.axiom.pather.async.AsyncToolPathProvider;
import com.moulberry.axiom.pather.async.AsyncToolPather;
import com.moulberry.axiom.pather.async.AsyncToolPatherUnique;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.restrictions.AxiomPermission;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.utils.AutoCleaningDynamicTexture;
import com.moulberry.axiom.utils.BlockManipulation;
import com.moulberry.axiom.utils.BlockWithFloat;
import com.moulberry.axiom.utils.NbtHelper;
import com.moulberry.axiom.utils.RegionHelper;
import imgui.ImGui;
import imgui.type.ImInt;
import imgui.type.ImString;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_1011;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class NoisePainterTool
implements Tool {
    private final ChunkedBlockRegion chunkedBlockRegion = new ChunkedBlockRegion();
    private boolean painting = false;
    private AsyncToolPathProvider pathProvider = null;
    private NoiseInterface currentNoise = null;
    private AutoCleaningDynamicTexture previewTexture = null;
    private AutoCleaningDynamicTexture cumulativeDistributionTexture = null;
    private AutoCleaningDynamicTexture probabilityDensityTexture = null;
    private final int[] frequencyCounts = new int[64];
    private int frequencyIterations = 0;
    private int maxFrequency = 0;
    private boolean previewDirty = false;
    private final BrushWidget brushWidget = new BrushWidget();
    private boolean threeDimensionalMode = true;
    private boolean maskSurface = true;
    private boolean anisotropic = false;
    private boolean copyProperties = false;
    private boolean typeReplace = false;
    private final ImInt noiseScaleX = new ImInt(8);
    private final ImInt noiseScaleY = new ImInt(8);
    private final ImInt noiseScaleZ = new ImInt(8);
    private final int[] noiseType = new int[]{0};
    private final ImString noiseSeed = new ImString();
    private final int[] octaves = new int[]{1};
    private final float[] lacunarity = new float[]{2.0f};
    private final float[] gain = new float[]{0.5f};
    private final float[] jitter = new float[]{1.0f};
    private final float[] worleyFirstFactor = new float[]{-1.0f};
    private final float[] worleySecondFactor = new float[]{0.7f};
    private final float[] worleyThirdFactor = new float[]{0.3f};
    private final float[] metaballRange = new float[]{1.0f};
    private final int[] blockMode = new int[]{0};
    private final List<BlockWithFloat> blockThresholds = new ArrayList<BlockWithFloat>();
    private final SelectBlockWidget selectBlockWidget = new SelectBlockWidget(false);
    private final PresetWidget presetWidget = new PresetWidget(this, "noise_painter");
    private final int defaultRandomValue = ThreadLocalRandom.current().nextInt();

    public NoisePainterTool() {
        this.blockThresholds.add(new BlockWithFloat((CustomBlockState)class_2246.field_10340.method_9564(), new float[]{50.0f}, null));
        this.noiseSeed.set(String.valueOf(this.defaultRandomValue), false);
    }

    @Override
    public void reset() {
        this.painting = false;
        this.chunkedBlockRegion.clear();
        if (this.pathProvider != null) {
            this.pathProvider.close();
            this.pathProvider = null;
        }
    }

    @Override
    public UserAction.ActionResult callAction(UserAction action, Object object) {
        switch (action) {
            case RIGHT_MOUSE: {
                this.reset();
                AsyncToolPather pather = this.createToolPather(this.brushWidget.getBrushShape());
                if (pather == null) {
                    return UserAction.ActionResult.NOT_HANDLED;
                }
                this.painting = true;
                this.pathProvider = new AsyncToolPathProvider(pather);
                return UserAction.ActionResult.USED_STOP;
            }
            case ESCAPE: {
                if (!this.painting) break;
                this.reset();
                return UserAction.ActionResult.USED_STOP;
            }
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    @Override
    public void render(class_4184 camera, float tickDelta, long time, class_4587 matrices, Matrix4f projection) {
        if (this.previewTexture == null) {
            this.previewTexture = new AutoCleaningDynamicTexture(64, 64, true);
            this.cumulativeDistributionTexture = new AutoCleaningDynamicTexture(256, 64, true);
            this.probabilityDensityTexture = new AutoCleaningDynamicTexture(256, 64, true);
        }
        if (!this.painting) {
            RayCaster.RaycastResult result = Tool.raycastBlock();
            if (result == null) {
                Selection.render(camera, time, matrices, projection, 7);
                return;
            }
            Selection.render(camera, time, matrices, projection, 4);
            this.brushWidget.renderPreview(camera, class_243.method_24954((class_2382)result.getBlockPos()), matrices, projection, time, 3);
        } else if (Tool.cancelUsing()) {
            this.reset();
        } else if (!Tool.isMouseDown(1)) {
            this.pathProvider.finish();
            String countString = NumberFormat.getInstance().format(this.chunkedBlockRegion.count());
            String historyDescription = AxiomI18n.get("axiom.history_description.painted", countString);
            RegionHelper.pushBlockRegionChange(this.chunkedBlockRegion, historyDescription);
            this.reset();
        } else {
            class_638 level = class_310.method_1551().field_1687;
            if (level == null) {
                return;
            }
            Selection.render(camera, time, matrices, projection, 4);
            this.pathProvider.update();
            float opacity = (float)Math.sin((float)time / 1000000.0f / 50.0f / 8.0f);
            this.chunkedBlockRegion.render(camera, class_243.field_1353, matrices, projection, 0.75f + opacity * 0.25f, 0.3f - opacity * 0.2f);
        }
    }

    private AsyncToolPather createToolPather(BrushShape brushShape) {
        List<CalculatedBlockThreshold> thresholdInformation;
        int scaleZ;
        int scaleY;
        int scaleX;
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return null;
        }
        MaskElement solidDestMask = MaskManager.createSolidDestMask();
        MaskContext maskContext = new MaskContext((class_1937)level);
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        if (this.currentNoise == null) {
            Arrays.fill(this.frequencyCounts, 0);
            this.frequencyIterations = 0;
            this.maxFrequency = 0;
        }
        this.updateNoise();
        NoiseInterface noiseInterface = this.currentNoise;
        int n = scaleX = this.noiseType[0] == 4 ? 1 : this.noiseScaleX.get();
        int n2 = this.noiseType[0] == 4 ? 1 : (scaleY = this.anisotropic ? this.noiseScaleY.get() : this.noiseScaleX.get());
        int n3 = this.noiseType[0] == 4 ? 1 : (scaleZ = this.anisotropic ? this.noiseScaleZ.get() : this.noiseScaleX.get());
        if (this.blockMode[0] == 0 && this.noiseType[0] != 4 && this.frequencyIterations < 128) {
            if (Runtime.getRuntime().availableProcessors() <= 1) {
                while (this.frequencyIterations < 128) {
                    this.updateFrequenciesWithSampling();
                }
            } else {
                ForkJoinPool forkJoinPool = new ForkJoinPool();
                ArrayList<Future> futures = new ArrayList<Future>();
                boolean threeDimensionalMode = this.threeDimensionalMode;
                int frequencyLength = this.frequencyCounts.length;
                int count = 128 - this.frequencyIterations;
                for (int i = 0; i < count; ++i) {
                    Future future = forkJoinPool.submit(() -> {
                        int[] samples = new int[frequencyLength];
                        this.updateFrequenciesWithSamplingForArray(samples, scaleX, scaleY, scaleZ, threeDimensionalMode);
                        return samples;
                    });
                    futures.add(future);
                }
                for (Future future : futures) {
                    int[] samples = (int[])((ForkJoinTask)future).join();
                    for (int i = 0; i < samples.length; ++i) {
                        int n4 = i;
                        this.frequencyCounts[n4] = this.frequencyCounts[n4] + samples[i];
                    }
                }
                for (Object frequencyCount : (Object)this.frequencyCounts) {
                    if (frequencyCount <= this.maxFrequency) continue;
                    this.maxFrequency = (int)frequencyCount;
                }
                this.frequencyIterations = 128;
            }
            this.previewDirty = true;
        }
        if ((thresholdInformation = this.calculateBlockThresholds()).isEmpty()) {
            return null;
        }
        boolean copyProperties = this.canCopyProperties() && this.copyProperties;
        boolean typeReplace = this.canTypeReplace() && this.typeReplace;
        return new AsyncToolPatherUnique(brushShape, (x, y, z) -> {
            if (!solidDestMask.test(maskContext.reset(), x, y, z)) {
                return;
            }
            if (!(!this.maskSurface || level.method_8320((class_2338)mutableBlockPos.method_10103(x + 1, y, z)).method_45474() || level.method_8320((class_2338)mutableBlockPos.method_10103(x - 1, y, z)).method_45474() || level.method_8320((class_2338)mutableBlockPos.method_10103(x, y + 1, z)).method_45474() || level.method_8320((class_2338)mutableBlockPos.method_10103(x, y - 1, z)).method_45474() || level.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z + 1)).method_45474() || level.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z - 1)).method_45474())) {
                return;
            }
            float noise = this.threeDimensionalMode ? noiseInterface.evaluate(((double)x + 0.5) / (double)scaleX, ((double)y + 0.5) / (double)scaleY, ((double)z + 0.5) / (double)scaleZ) : noiseInterface.evaluate(((double)x + 0.5) / (double)scaleX, ((double)z + 0.5) / (double)scaleY);
            for (CalculatedBlockThreshold information : thresholdInformation) {
                if (!(noise <= information.threshold)) continue;
                BlockManipulation.setWithCopyPropertiesAndTypeReplace(this.chunkedBlockRegion, x, y, z, information.blockState, typeReplace, copyProperties, information.randomizedProperties, maskContext, mutableBlockPos);
                return;
            }
        });
    }

    @Override
    public void displayImguiOptions() {
        BlockWithFloat.ExtraRenderType extraRenderType;
        if (this.previewTexture == null) {
            this.previewTexture = new AutoCleaningDynamicTexture(64, 64, true);
            this.cumulativeDistributionTexture = new AutoCleaningDynamicTexture(256, 64, true);
            this.probabilityDensityTexture = new AutoCleaningDynamicTexture(256, 64, true);
        }
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.generic.brush"));
        boolean settingsChanged = this.brushWidget.displayImgui();
        boolean frequencyChanged = false;
        if (this.noiseType[0] != 4) {
            if (!this.anisotropic) {
                frequencyChanged |= ImGui.sliderScalar(AxiomI18n.get("axiom.tool.noise_painter.scale"), 4, this.noiseScaleX, 1, 64, "%d");
            } else {
                frequencyChanged |= ImGui.sliderScalar(AxiomI18n.get("axiom.tool.noise_painter.scale") + " X", 4, this.noiseScaleX, 1, 64, "%d");
                frequencyChanged |= ImGui.sliderScalar(AxiomI18n.get("axiom.tool.noise_painter.scale") + " Y", 4, this.noiseScaleY, 1, 64, "%d");
                if (this.threeDimensionalMode) {
                    frequencyChanged |= ImGui.sliderScalar(AxiomI18n.get("axiom.tool.noise_painter.scale") + " Z", 4, this.noiseScaleZ, 1, 64, "%d");
                }
            }
        }
        if (ImGui.checkbox(AxiomI18n.get("axiom.tool.noise_painter.3d_mode"), this.threeDimensionalMode)) {
            this.threeDimensionalMode = !this.threeDimensionalMode;
            frequencyChanged = true;
        }
        ImGui.sameLine();
        if (ImGui.checkbox(AxiomI18n.get("axiom.tool.generic.mask_surface_short"), this.maskSurface)) {
            this.maskSurface = !this.maskSurface;
            settingsChanged = true;
        }
        if (this.noiseType[0] != 4) {
            ImGui.sameLine();
            if (ImGui.checkbox(AxiomI18n.get("axiom.tool.noise_painter.anisotropic"), this.anisotropic)) {
                this.anisotropic = !this.anisotropic;
                frequencyChanged = true;
            }
        }
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.generic.noise"));
        frequencyChanged |= ImGuiHelper.combo("##NoiseCombo", this.noiseType, new String[]{AxiomI18n.get("axiom.tool.noise_painter.simplex_noise"), AxiomI18n.get("axiom.tool.noise_painter.voronoi_edges"), AxiomI18n.get("axiom.tool.noise_painter.worley_noise"), AxiomI18n.get("axiom.tool.noise_painter.metaball_noise"), AxiomI18n.get("axiom.tool.noise_painter.white_noise"), AxiomI18n.get("axiom.tool.noise_painter.splatter_noise")});
        switch (this.noiseType[0]) {
            case 1: {
                frequencyChanged |= ImGui.sliderFloat(AxiomI18n.get("axiom.tool.noise_painter.jitter"), this.jitter, 0.0f, 1.0f, "%.2f");
                break;
            }
            case 2: {
                frequencyChanged |= ImGui.sliderFloat(AxiomI18n.get("axiom.tool.noise_painter.jitter"), this.jitter, 0.0f, 1.0f, "%.2f");
                frequencyChanged |= ImGui.sliderFloat("W1", this.worleyFirstFactor, -1.0f, 1.0f, "%.2f");
                frequencyChanged |= ImGui.sliderFloat("W2", this.worleySecondFactor, -1.0f, 1.0f, "%.2f");
                frequencyChanged |= ImGui.sliderFloat("W3", this.worleyThirdFactor, -1.0f, 1.0f, "%.2f");
                break;
            }
            case 3: {
                frequencyChanged |= ImGui.sliderFloat(AxiomI18n.get("axiom.tool.noise_painter.jitter"), this.jitter, 0.0f, 1.0f, "%.2f");
                frequencyChanged |= ImGui.sliderFloat(AxiomI18n.get("axiom.tool.noise_painter.metaball_range"), this.metaballRange, 0.0f, 1.5f, "%.2f");
            }
        }
        if (this.noiseType[0] != 4 && this.noiseType[0] != 5) {
            frequencyChanged |= ImGui.sliderInt(AxiomI18n.get("axiom.tool.noise_painter.octaves"), this.octaves, 1, 8);
            if (this.octaves[0] > 1) {
                frequencyChanged |= ImGui.sliderFloat(AxiomI18n.get("axiom.tool.noise_painter.lacunarity"), this.lacunarity, 1.0f, 3.0f);
                frequencyChanged |= ImGui.sliderFloat(AxiomI18n.get("axiom.tool.noise_painter.gain"), this.gain, 0.0f, 1.0f);
            }
        }
        settingsChanged |= ImGui.inputText(AxiomI18n.get("axiom.tool.generic.noise_seed"), this.noiseSeed);
        if (ImGui.button(AxiomI18n.get("axiom.tool.generic.noise_seed_do_randomize"))) {
            settingsChanged = true;
            this.noiseSeed.set(String.valueOf(ThreadLocalRandom.current().nextInt()), false);
        }
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.noise_painter.blocks"));
        settingsChanged |= ImGuiHelper.combo(AxiomI18n.get("axiom.tool.noise_painter.block_mode") + "##BlockMode", this.blockMode, new String[]{AxiomI18n.get("axiom.tool.noise_painter.block_mode_count"), AxiomI18n.get("axiom.tool.noise_painter.block_mode_threshold")});
        BlockWithFloat.ExtraRenderType extraRenderType2 = extraRenderType = this.blockMode[0] == 0 ? BlockWithFloat.ExtraRenderType.PERCENTAGE : BlockWithFloat.ExtraRenderType.FLOAT;
        if (BlockWithFloat.renderList(this.blockThresholds, this.selectBlockWidget, extraRenderType, 1, true)) {
            settingsChanged = true;
        }
        if (this.canCopyProperties() && ImGui.checkbox(AxiomI18n.get("axiom.editorui.window.replace.copy_properties"), this.copyProperties)) {
            boolean bl = this.copyProperties = !this.copyProperties;
        }
        if (this.canTypeReplace() && ImGui.checkbox(AxiomI18n.get("axiom.contextmenu.type_replace"), this.typeReplace)) {
            this.typeReplace = !this.typeReplace;
        }
        settingsChanged |= frequencyChanged;
        if (frequencyChanged || this.currentNoise == null) {
            Arrays.fill(this.frequencyCounts, 0);
            this.frequencyIterations = 0;
            this.maxFrequency = 0;
            this.previewDirty = true;
        }
        if (settingsChanged || this.currentNoise == null) {
            this.updateNoise();
            this.previewDirty = true;
        }
        if (this.frequencyIterations < 128) {
            this.updateFrequenciesWithSampling();
            this.previewDirty = true;
        }
        if (this.previewDirty) {
            int x;
            int scaleX;
            this.previewDirty = false;
            class_1011 pixels = this.previewTexture.method_4525();
            List<CalculatedBlockThreshold> colourInformation = this.calculateBlockThresholds();
            int n = scaleX = this.noiseType[0] == 4 ? 1 : this.noiseScaleX.get();
            int scaleY = this.noiseType[0] == 4 ? 1 : (this.anisotropic ? this.noiseScaleY.get() : this.noiseScaleX.get());
            for (int x2 = 0; x2 < 64; ++x2) {
                for (int y = 0; y < 64; ++y) {
                    float noise = this.threeDimensionalMode ? this.currentNoise.evaluate(((double)x2 + 0.5) / (double)scaleX, ((double)y + 0.5) / (double)scaleY, 0.5) : this.currentNoise.evaluate(((double)x2 + 0.5) / (double)scaleX, ((double)y + 0.5) / (double)scaleY);
                    int argb = 0;
                    for (CalculatedBlockThreshold information : colourInformation) {
                        if (!(noise <= information.threshold)) continue;
                        argb = information.argb;
                        break;
                    }
                    pixels.method_61941(x2, y, argb);
                }
            }
            this.previewTexture.method_4524();
            class_1011 cumulativePixels = this.cumulativeDistributionTexture.method_4525();
            class_1011 densityPixels = this.probabilityDensityTexture.method_4525();
            ArrayList<BlockWithFloat> nonZeroBlockThresholds = new ArrayList<BlockWithFloat>();
            for (BlockWithFloat blockWithFloat : this.blockThresholds) {
                if (!((double)blockWithFloat.percentage()[0] > 1.0E-5)) continue;
                nonZeroBlockThresholds.add(blockWithFloat);
            }
            boolean[] thresholdMarkers = new boolean[256];
            if (!nonZeroBlockThresholds.isEmpty()) {
                if (this.blockMode[0] == 1 || this.noiseType[0] == 4) {
                    float thresholdTotal = 0.0f;
                    for (int i = 0; i < nonZeroBlockThresholds.size(); ++i) {
                        BlockWithFloat blockThreshold = (BlockWithFloat)nonZeroBlockThresholds.get(i);
                        thresholdTotal += blockThreshold.percentage()[0] / 100.0f;
                    }
                    if (thresholdTotal < 1.0f) {
                        thresholdTotal = 1.0f;
                    }
                    float thresholdSum = 0.0f;
                    for (int i = 0; i < nonZeroBlockThresholds.size(); ++i) {
                        BlockWithFloat blockThreshold = (BlockWithFloat)nonZeroBlockThresholds.get(i);
                        if ((thresholdSum += blockThreshold.percentage()[0] / 100.0f / thresholdTotal) > 0.99f && i == nonZeroBlockThresholds.size() - 1) {
                            thresholdSum = 1.0f;
                        }
                        if (thresholdSum > 1.0f) {
                            thresholdSum = 1.0f;
                        }
                        int lowerThreshold = Math.round(thresholdSum * 255.0f - 1.0f);
                        int upperThreshold = Math.round(thresholdSum * 255.0f + 1.0f);
                        if (lowerThreshold < 0) {
                            lowerThreshold = 0;
                        }
                        if (upperThreshold > 255) {
                            upperThreshold = 255;
                        }
                        for (int j = lowerThreshold; j <= upperThreshold; ++j) {
                            thresholdMarkers[j] = true;
                        }
                    }
                } else {
                    float thresholdTotal = 0.0f;
                    for (int i = 0; i < nonZeroBlockThresholds.size(); ++i) {
                        BlockWithFloat blockThreshold = (BlockWithFloat)nonZeroBlockThresholds.get(i);
                        thresholdTotal += blockThreshold.percentage()[0] / 100.0f;
                    }
                    if (thresholdTotal < 1.0f) {
                        thresholdTotal = 1.0f;
                    }
                    float totalSamples = this.frequencyIterations * 8192;
                    int thresholdIndex = 0;
                    float thresholdAmount = ((BlockWithFloat)nonZeroBlockThresholds.get(0)).percentage()[0] / 100.0f / thresholdTotal;
                    float currentAmount = 0.0f;
                    float totalThreshold = thresholdAmount;
                    for (int frequencyIndex = 0; frequencyIndex < this.frequencyCounts.length; ++frequencyIndex) {
                        float oldCurrentAmount = currentAmount;
                        if (!((currentAmount += (float)this.frequencyCounts[frequencyIndex] / totalSamples) >= thresholdAmount)) continue;
                        float partialDistance = (thresholdAmount - oldCurrentAmount) / (currentAmount - oldCurrentAmount);
                        float thresholdSum = ((float)(frequencyIndex - 1) + partialDistance) / 63.0f;
                        if (totalThreshold > 0.995f && thresholdIndex == nonZeroBlockThresholds.size() - 1) {
                            thresholdSum = 1.0f;
                        }
                        int lowerThreshold = Math.round(thresholdSum * 255.0f - 1.0f);
                        int upperThreshold = Math.round(thresholdSum * 255.0f + 1.0f);
                        if (lowerThreshold < 0) {
                            lowerThreshold = 0;
                        }
                        if (upperThreshold > 255) {
                            upperThreshold = 255;
                        }
                        for (int j = lowerThreshold; j <= upperThreshold; ++j) {
                            thresholdMarkers[j] = true;
                        }
                        currentAmount -= thresholdAmount;
                        if (++thresholdIndex >= nonZeroBlockThresholds.size()) break;
                        thresholdAmount = ((BlockWithFloat)nonZeroBlockThresholds.get(thresholdIndex)).percentage()[0] / 100.0f / thresholdTotal;
                        totalThreshold += thresholdAmount;
                    }
                    if (thresholdIndex < nonZeroBlockThresholds.size()) {
                        thresholdMarkers[254] = true;
                        thresholdMarkers[255] = true;
                    }
                }
            }
            int minSize = 0;
            if (this.noiseType[0] == 3 && this.metaballRange[0] > 0.0f) {
                minSize = 1;
            }
            float sum = 0.0f;
            float[] cumulative = new float[256];
            for (x = 0; x < 256; ++x) {
                int y;
                float indexF = (float)x / 255.0f * 63.0f;
                int indexLower = (int)Math.floor(indexF);
                int indexUpper = (int)Math.ceil(indexF);
                float frac = indexF - (float)indexLower;
                float frequencyCountLower = this.frequencyCounts[indexLower];
                float frequencyCountUpper = this.frequencyCounts[indexUpper];
                float count = frequencyCountLower * (1.0f - frac) + frequencyCountUpper * frac;
                cumulative[x] = sum += count;
                int size = (int)Math.floor(count / (float)this.maxFrequency * 64.0f);
                if (size > 64) {
                    size = 64;
                }
                if (size < minSize) {
                    size = minSize;
                }
                int set = -1;
                int unset = -16777216;
                if (thresholdMarkers[x]) {
                    set = -65536;
                    unset = -8388608;
                }
                for (y = 0; y < size; ++y) {
                    densityPixels.method_61941(x, y, set);
                }
                for (y = size; y < 64; ++y) {
                    densityPixels.method_61941(x, y, unset);
                }
            }
            for (x = 0; x < 256; ++x) {
                int y;
                int size = (int)Math.floor(cumulative[x] / sum * 64.0f);
                if (size > 64) {
                    size = 64;
                }
                if (size < minSize) {
                    size = minSize;
                }
                int set = -1;
                int unset = -16777216;
                if (thresholdMarkers[x]) {
                    set = -65536;
                    unset = -8388608;
                }
                for (y = 0; y < size; ++y) {
                    cumulativePixels.method_61941(x, y, set);
                }
                for (y = size; y < 64; ++y) {
                    cumulativePixels.method_61941(x, y, unset);
                }
            }
            this.cumulativeDistributionTexture.method_4524();
            this.probabilityDensityTexture.method_4524();
        }
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.widget.presets"));
        this.presetWidget.displayImgui(settingsChanged);
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.noise_painter.noise_preview"));
        ImGui.image(this.previewTexture.getId(), 256.0f, 256.0f, 0.0f, 1.0f, 1.0f, 0.0f);
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.noise_painter.cumulative_distribution"));
        ImGui.image(this.cumulativeDistributionTexture.getId(), 256.0f, 64.0f, 0.0f, 1.0f, 1.0f, 0.0f);
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.noise_painter.probability_density"));
        ImGui.image(this.probabilityDensityTexture.getId(), 256.0f, 64.0f, 0.0f, 1.0f, 1.0f, 0.0f);
    }

    private boolean canCopyProperties() {
        for (BlockWithFloat blockThreshold : this.blockThresholds) {
            if (blockThreshold.blockState().getProperties().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean canTypeReplace() {
        for (BlockWithFloat blockThreshold : this.blockThresholds) {
            if (FamilyMap.getFamilyForBase(blockThreshold.blockState().getVanillaState().method_26204()) != null) continue;
            return false;
        }
        return true;
    }

    private void updateFrequenciesWithSampling() {
        int scaleY;
        int scaleX;
        if (this.currentNoise == null) {
            this.updateNoise();
        }
        int n = scaleX = this.noiseType[0] == 4 ? 1 : this.noiseScaleX.get();
        int n2 = this.noiseType[0] == 4 ? 1 : (scaleY = this.anisotropic ? this.noiseScaleY.get() : this.noiseScaleX.get());
        int scaleZ = this.noiseType[0] == 4 ? 1 : (this.anisotropic ? this.noiseScaleZ.get() : this.noiseScaleX.get());
        this.updateFrequenciesWithSamplingForArray(this.frequencyCounts, scaleX, scaleY, scaleZ, this.threeDimensionalMode);
        for (int frequencyCount : this.frequencyCounts) {
            if (frequencyCount <= this.maxFrequency) continue;
            this.maxFrequency = frequencyCount;
        }
        ++this.frequencyIterations;
    }

    private void updateFrequenciesWithSamplingForArray(int[] frequencyCounts, int scaleX, int scaleY, int scaleZ, boolean threeDimensionalMode) {
        if (this.currentNoise == null) {
            throw new FaultyImplementationError();
        }
        ThreadLocalRandom random2 = ThreadLocalRandom.current();
        for (int i = 0; i < 8192; ++i) {
            int index;
            float noise;
            int x = ((Random)random2).nextInt() & 0xBFFFFFFF;
            int y = ((Random)random2).nextInt() & 0xBFFFFFFF;
            if (threeDimensionalMode) {
                int z = ((Random)random2).nextInt() & 0xBFFFFFFF;
                noise = this.currentNoise.evaluate(((double)x + 0.5) / (double)scaleX, ((double)y + 0.5) / (double)scaleY, ((double)z + 0.5) / (double)scaleZ);
            } else {
                noise = this.currentNoise.evaluate(((double)x + 0.5) / (double)scaleX, ((double)y + 0.5) / (double)scaleY);
            }
            int n = index = Math.round(noise * (float)(frequencyCounts.length - 1));
            frequencyCounts[n] = frequencyCounts[n] + 1;
        }
    }

    private void updateNoise() {
        int seed;
        int octaves = this.octaves[0];
        String seedStr = ImGuiHelper.getString(this.noiseSeed).trim();
        if (seedStr.isEmpty()) {
            seed = this.defaultRandomValue;
        } else {
            try {
                seed = Integer.parseInt(seedStr);
            }
            catch (NumberFormatException numberFormatException) {
                seed = 0;
                for (char c : seedStr.toCharArray()) {
                    seed = 31 * seed + c;
                }
            }
        }
        this.currentNoise = switch (this.noiseType[0]) {
            case 0 -> {
                if (octaves <= 1) {
                    yield new SimplexNoise(seed);
                }
                NoiseInterface[] noises = new NoiseInterface[octaves];
                for (int i = 0; i < octaves; ++i) {
                    noises[i] = new SimplexNoise(seed + i);
                }
                yield new FBMNoise(this.lacunarity[0], this.gain[0], noises);
            }
            case 1 -> {
                int i;
                float jitter = this.jitter[0];
                if (octaves <= 1) {
                    yield new VoronoiEdgesNoise(seed, jitter);
                }
                NoiseInterface[] noises = new NoiseInterface[octaves];
                for (i = 0; i < octaves; ++i) {
                    noises[i] = new VoronoiEdgesNoise((long)seed + 10L * (long)i, jitter);
                }
                yield new FBMNoise(this.lacunarity[0], this.gain[0], noises);
            }
            case 2 -> {
                float jitter = this.jitter[0];
                float firstFactor = this.worleyFirstFactor[0];
                float secondFactor = this.worleySecondFactor[0];
                float thirdFactor = this.worleyThirdFactor[0];
                if (octaves <= 1) {
                    yield new WorleyNoise(seed, jitter, firstFactor, secondFactor, thirdFactor);
                }
                NoiseInterface[] noises = new NoiseInterface[octaves];
                for (int i = 0; i < octaves; ++i) {
                    noises[i] = new WorleyNoise(seed + i, jitter, firstFactor, secondFactor, thirdFactor);
                }
                yield new FBMNoise(this.lacunarity[0], this.gain[0], noises);
            }
            case 3 -> {
                int i;
                float jitter = this.jitter[0];
                if (octaves <= 1) {
                    yield new MetaballNoise(seed, jitter, this.metaballRange[0]);
                }
                NoiseInterface[] noises = new NoiseInterface[octaves];
                for (i = 0; i < octaves; ++i) {
                    noises[i] = new MetaballNoise(seed + i, jitter, this.metaballRange[0]);
                }
                yield new FBMNoise(this.lacunarity[0], this.gain[0], noises);
            }
            case 4 -> new WhiteNoise(seed);
            case 5 -> {
                int scaleX = this.noiseScaleX.get();
                int scaleY = this.anisotropic ? this.noiseScaleY.get() : this.noiseScaleX.get();
                int scaleZ = this.anisotropic ? this.noiseScaleZ.get() : this.noiseScaleX.get();
                yield new SplatterNoise(seed, scaleX, scaleY, scaleZ);
            }
            default -> throw new FaultyImplementationError();
        };
    }

    @NotNull
    private List<CalculatedBlockThreshold> calculateBlockThresholds() {
        ArrayList<CalculatedBlockThreshold> thresholdInformation = new ArrayList<CalculatedBlockThreshold>();
        ArrayList<BlockWithFloat> nonZeroBlockThresholds = new ArrayList<BlockWithFloat>();
        for (BlockWithFloat blockWithFloat : this.blockThresholds) {
            if (!((double)blockWithFloat.percentage()[0] > 1.0E-5)) continue;
            nonZeroBlockThresholds.add(blockWithFloat);
        }
        if (nonZeroBlockThresholds.isEmpty()) {
            return List.of();
        }
        if (this.blockMode[0] == 1 || this.noiseType[0] == 4) {
            float thresholdTotal = 0.0f;
            for (int i = 0; i < nonZeroBlockThresholds.size(); ++i) {
                BlockWithFloat blockThreshold = (BlockWithFloat)nonZeroBlockThresholds.get(i);
                thresholdTotal += blockThreshold.percentage()[0] / 100.0f;
            }
            if (thresholdTotal < 1.0f) {
                thresholdTotal = 1.0f;
            }
            float thresholdSum = 0.0f;
            for (int i = 0; i < nonZeroBlockThresholds.size(); ++i) {
                BlockWithFloat blockThreshold = (BlockWithFloat)nonZeroBlockThresholds.get(i);
                if ((thresholdSum += blockThreshold.percentage()[0] / 100.0f / thresholdTotal) > 0.99f && i == nonZeroBlockThresholds.size() - 1) {
                    thresholdSum = 1.0f;
                }
                int colour = Math.round(255.0f - 255.0f * (float)i / (float)nonZeroBlockThresholds.size());
                thresholdInformation.add(new CalculatedBlockThreshold(thresholdSum, 0xFF000000 | colour * 65793, blockThreshold.blockState(), blockThreshold.randomProperties()));
            }
        } else {
            float thresholdTotal = 0.0f;
            for (int i = 0; i < nonZeroBlockThresholds.size(); ++i) {
                BlockWithFloat blockThreshold = (BlockWithFloat)nonZeroBlockThresholds.get(i);
                thresholdTotal += blockThreshold.percentage()[0] / 100.0f;
            }
            if (thresholdTotal < 1.0f) {
                thresholdTotal = 1.0f;
            }
            float totalSamples = this.frequencyIterations * 8192;
            int thresholdIndex = 0;
            float thresholdAmount = ((BlockWithFloat)nonZeroBlockThresholds.get(0)).percentage()[0] / 100.0f / thresholdTotal;
            float currentAmount = 0.0f;
            float totalThreshold = thresholdAmount;
            block4: for (int frequencyIndex = 0; frequencyIndex < this.frequencyCounts.length; ++frequencyIndex) {
                float oldCurrentAmount = currentAmount;
                currentAmount += (float)this.frequencyCounts[frequencyIndex] / totalSamples;
                while (currentAmount >= thresholdAmount) {
                    int distanceFromEnd;
                    float thresholdSumMax;
                    float partialDistance = (thresholdAmount - oldCurrentAmount) / (currentAmount - oldCurrentAmount);
                    float thresholdSum = ((float)(frequencyIndex - 1) + partialDistance) / 63.0f;
                    if (totalThreshold > 0.995f && thresholdIndex == nonZeroBlockThresholds.size() - 1) {
                        thresholdSum = 1.0f;
                    }
                    if (thresholdSum > (thresholdSumMax = 1.0f - 0.001f * (float)(distanceFromEnd = nonZeroBlockThresholds.size() - 1 - thresholdIndex))) {
                        thresholdSum = thresholdSumMax;
                    }
                    int colour = Math.round(255.0f - 255.0f * (float)thresholdIndex / (float)nonZeroBlockThresholds.size());
                    BlockWithFloat blockWithFloat = (BlockWithFloat)nonZeroBlockThresholds.get(thresholdIndex);
                    thresholdInformation.add(new CalculatedBlockThreshold(thresholdSum, 0xFF000000 | colour * 65793, blockWithFloat.blockState(), blockWithFloat.randomProperties()));
                    currentAmount -= thresholdAmount;
                    if (++thresholdIndex >= nonZeroBlockThresholds.size()) break block4;
                    thresholdAmount = ((BlockWithFloat)nonZeroBlockThresholds.get(thresholdIndex)).percentage()[0] / 100.0f / thresholdTotal;
                    totalThreshold += thresholdAmount;
                }
            }
            if (thresholdIndex < nonZeroBlockThresholds.size()) {
                int colour = Math.round(255.0f - 255.0f * (float)thresholdIndex / (float)nonZeroBlockThresholds.size());
                BlockWithFloat blockWithFloat = (BlockWithFloat)nonZeroBlockThresholds.get(thresholdIndex);
                thresholdInformation.add(new CalculatedBlockThreshold(1.0f, 0xFF000000 | colour * 65793, blockWithFloat.blockState(), blockWithFloat.randomProperties()));
            }
        }
        return thresholdInformation;
    }

    @Override
    public String listenForEsc() {
        if (!this.painting) {
            return null;
        }
        return AxiomI18n.get("axiom.widget.cancel");
    }

    @Override
    public boolean initiateAdjustment() {
        return this.brushWidget.initiateAdjustment();
    }

    @Override
    public class_241 renderAdjustment(float mouseX, float mouseY, class_241 mouseDelta) {
        return this.brushWidget.renderAdjustment(mouseX, mouseY, mouseDelta);
    }

    @Override
    public String name() {
        return AxiomI18n.get("axiom.tool.noise_painter");
    }

    @Override
    public void writeSettings(class_2487 tag) {
        this.brushWidget.writeSettings(tag);
        tag.method_10556("ThreeDimensional", this.threeDimensionalMode);
        tag.method_10556("MaskSurface", this.maskSurface);
        tag.method_10556("Anisotropic", this.anisotropic);
        tag.method_10569("NoiseScaleX", this.noiseScaleX.get());
        tag.method_10569("NoiseScaleY", this.noiseScaleY.get());
        tag.method_10569("NoiseScaleZ", this.noiseScaleZ.get());
        tag.method_10569("NoiseType", this.noiseType[0]);
        tag.method_10582("NoiseSeed", ImGuiHelper.getString(this.noiseSeed));
        tag.method_10569("Octaves", this.octaves[0]);
        tag.method_10548("Lacunarity", this.lacunarity[0]);
        tag.method_10548("Gain", this.gain[0]);
        tag.method_10548("Jitter", this.jitter[0]);
        tag.method_10548("W1", this.worleyFirstFactor[0]);
        tag.method_10548("W2", this.worleySecondFactor[0]);
        tag.method_10548("W3", this.worleyThirdFactor[0]);
        tag.method_10548("MetaballRange", this.metaballRange[0]);
        tag.method_10569("BlockMode", this.blockMode[0]);
        class_2499 blockThresholds = new class_2499();
        for (BlockWithFloat blockWithFloat : this.blockThresholds) {
            class_2487 blockWithFloatTag = new class_2487();
            blockWithFloatTag.method_10582("Block", ServerCustomBlocks.serialize(blockWithFloat.blockState()));
            blockWithFloatTag.method_10548("Percentage", blockWithFloat.percentage()[0]);
            blockThresholds.add((Object)blockWithFloatTag);
        }
        tag.method_10566("BlockThresholds", (class_2520)blockThresholds);
    }

    @Override
    public void loadSettings(class_2487 tag) {
        this.brushWidget.loadSettings(tag);
        this.threeDimensionalMode = tag.method_68566("ThreeDimensional", true);
        this.maskSurface = tag.method_68566("MaskSurface", true);
        this.anisotropic = tag.method_68566("Anisotropic", false);
        this.noiseScaleX.set(tag.method_68083("NoiseScaleX", 8));
        this.noiseScaleY.set(tag.method_68083("NoiseScaleY", 8));
        this.noiseScaleZ.set(tag.method_68083("NoiseScaleZ", 8));
        this.noiseType[0] = tag.method_68083("NoiseType", 0);
        this.noiseSeed.set(tag.method_68564("NoiseSeed", String.valueOf(this.defaultRandomValue)), false);
        this.octaves[0] = tag.method_68083("Octaves", 1);
        this.lacunarity[0] = tag.method_66563("Lacunarity", 2.0f);
        this.gain[0] = tag.method_66563("Gain", 0.5f);
        this.jitter[0] = tag.method_66563("Jitter", 1.0f);
        this.worleyFirstFactor[0] = tag.method_66563("W1", -1.0f);
        this.worleySecondFactor[0] = tag.method_66563("W2", 0.7f);
        this.worleyThirdFactor[0] = tag.method_66563("W3", 0.3f);
        this.metaballRange[0] = tag.method_66563("MetaballRange", 1.0f);
        this.blockMode[0] = tag.method_68083("BlockMode", 0);
        this.blockThresholds.clear();
        class_2499 blockPercentages = NbtHelper.getList(tag, "BlockThresholds", 10);
        for (class_2520 blockPercentageTag : blockPercentages) {
            class_2487 blockPercentage = (class_2487)blockPercentageTag;
            String block = (String)blockPercentage.method_10558("Block").get();
            float percentage = ((Float)blockPercentage.method_10583("Percentage").get()).floatValue();
            this.blockThresholds.add(new BlockWithFloat(Objects.requireNonNullElse(ServerCustomBlocks.deserialize(block), (CustomBlockState)class_2246.field_10340.method_9564()), new float[]{percentage}, null));
        }
        if (this.blockThresholds.isEmpty()) {
            this.blockThresholds.add(new BlockWithFloat((CustomBlockState)class_2246.field_10340.method_9564(), new float[]{50.0f}, null));
        }
        this.currentNoise = null;
    }

    @Override
    public boolean showToolSmoothing() {
        return true;
    }

    @Override
    public char iconChar() {
        return '\ue90f';
    }

    @Override
    public String keybindId() {
        return "noise_painter";
    }

    @Override
    public int defaultKeybind() {
        return 79;
    }

    @Override
    public EnumSet<AxiomPermission> requiredPermissions() {
        return EnumSet.of(AxiomPermission.TOOL_NOISEPAINTER, AxiomPermission.BUILD_SECTION);
    }

    record CalculatedBlockThreshold(float threshold, int argb, CustomBlockState blockState, Set<class_2769<?>> randomizedProperties) {
    }
}

