/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.freehand;

import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.brush_shapes.BrushShape;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.widgets.BrushWidget;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.mask.MaskContext;
import com.moulberry.axiom.mask.MaskElement;
import com.moulberry.axiom.mask.MaskManager;
import com.moulberry.axiom.pather.async.AsyncToolPathProvider;
import com.moulberry.axiom.pather.async.AsyncToolPather;
import com.moulberry.axiom.pather.async.AsyncToolPatherUnique;
import com.moulberry.axiom.render.regions.ChunkedBooleanRegion;
import com.moulberry.axiom.restrictions.AxiomPermission;
import com.moulberry.axiom.tools.Tool;
import java.util.EnumSet;
import net.minecraft.class_1937;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import org.joml.Matrix4f;

public class FreehandSelect
implements Tool {
    private ChunkedBooleanRegion chunkedBooleanRegion = new ChunkedBooleanRegion();
    private boolean usingTool = false;
    private AsyncToolPathProvider pathProvider = null;
    private final BrushWidget brushWidget = new BrushWidget();
    private final int[] mode = new int[]{1};
    private static final int MODE_REPLACE = 0;
    private static final int MODE_ADD = 1;
    private static final int MODE_SUBTRACT = 2;
    private static final int MODE_INTERSECT = 3;

    @Override
    public void reset() {
        this.usingTool = false;
        this.chunkedBooleanRegion.clear();
        if (this.pathProvider != null) {
            this.pathProvider.close();
            this.pathProvider = null;
        }
    }

    @Override
    public UserAction.ActionResult callAction(UserAction action, Object object) {
        switch (action) {
            case RIGHT_MOUSE: {
                this.reset();
                this.usingTool = true;
                this.pathProvider = new AsyncToolPathProvider(this.createToolPather(this.brushWidget.getBrushShape()));
                return UserAction.ActionResult.USED_STOP;
            }
            case ESCAPE: {
                if (!this.usingTool) break;
                this.reset();
                return UserAction.ActionResult.USED_STOP;
            }
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    @Override
    public void render(class_4184 camera, float tickDelta, long time, class_4587 matrices, Matrix4f projection) {
        if (!this.usingTool) {
            RayCaster.RaycastResult result = Tool.raycastBlock(false, true, Tool.defaultIncludeFluids());
            if (result == null) {
                Selection.render(camera, time, matrices, projection, 7);
                return;
            }
            Selection.render(camera, time, matrices, projection, 4);
            this.brushWidget.renderPreview(camera, class_243.method_24954((class_2382)result.getBlockPos()), matrices, projection, time, 3);
        } else if (Tool.cancelUsing()) {
            this.reset();
        } else if (!Tool.isMouseDown(1)) {
            this.pathProvider.finish();
            PositionSet positionSet = this.chunkedBooleanRegion.unsafeGetPositionSet();
            switch (this.mode[0]) {
                default: {
                    throw new FaultyImplementationError();
                }
                case 0: {
                    Selection.clearSelection();
                    Selection.addSet(positionSet);
                    break;
                }
                case 1: {
                    Selection.addSet(positionSet);
                    break;
                }
                case 2: {
                    Selection.subtractSet(positionSet);
                    break;
                }
                case 3: {
                    Selection.intersectSet(positionSet);
                }
            }
            this.reset();
        } else {
            class_638 level = class_310.method_1551().field_1687;
            if (level == null) {
                return;
            }
            this.pathProvider.update();
            Selection.render(camera, time, matrices, projection, 4);
            this.chunkedBooleanRegion.render(camera, class_243.field_1353, matrices, projection, time, 3);
        }
    }

    private AsyncToolPather createToolPather(BrushShape brushShape) {
        MaskContext maskContext = new MaskContext((class_1937)class_310.method_1551().field_1687);
        MaskElement destMask = MaskManager.getSelectionMask();
        return new AsyncToolPatherUnique(brushShape, (x, y, z) -> {
            if (destMask.test(maskContext.reset(), x, y, z)) {
                this.chunkedBooleanRegion.add(x, y, z);
            }
        });
    }

    @Override
    public void displayImguiOptions() {
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.generic.brush"));
        this.brushWidget.displayImgui();
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.selection"));
        ImGuiHelper.combo(AxiomI18n.get("axiom.tool.selection.mode"), this.mode, new String[]{AxiomI18n.get("axiom.tool.selection.replace"), AxiomI18n.get("axiom.tool.selection.add"), AxiomI18n.get("axiom.tool.selection.subtract"), AxiomI18n.get("axiom.tool.selection.intersect")});
    }

    @Override
    public String listenForEsc() {
        if (!this.usingTool) {
            return null;
        }
        return AxiomI18n.get("axiom.widget.cancel");
    }

    @Override
    public boolean initiateAdjustment() {
        return this.brushWidget.initiateAdjustment();
    }

    @Override
    public class_241 renderAdjustment(float mouseX, float mouseY, class_241 mouseDelta) {
        return this.brushWidget.renderAdjustment(mouseX, mouseY, mouseDelta);
    }

    @Override
    public String name() {
        return AxiomI18n.get("axiom.tool.freehand_select");
    }

    @Override
    public void writeSettings(class_2487 tag) {
        this.brushWidget.writeSettings(tag);
        tag.method_10567("Mode", (byte)this.mode[0]);
    }

    @Override
    public void loadSettings(class_2487 tag) {
        this.brushWidget.loadSettings(tag);
        this.mode[0] = tag.method_68083("Mode", 1);
    }

    @Override
    public boolean showToolSmoothing() {
        return true;
    }

    @Override
    public char iconChar() {
        return '\ue913';
    }

    @Override
    public String keybindId() {
        return "freehand_select";
    }

    @Override
    public int defaultKeybind() {
        return 78;
    }

    @Override
    public EnumSet<AxiomPermission> requiredPermissions() {
        return EnumSet.of(AxiomPermission.TOOL_FREEHANDSELECT);
    }
}

