/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools;

import com.mojang.blaze3d.vertex.VertexFormat;
import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.core_rendering.AxiomRenderPipelines;
import com.moulberry.axiom.core_rendering.AxiomRenderer;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.keybinds.Keybinds;
import com.moulberry.axiom.editor.tutorial.Tutorial;
import com.moulberry.axiom.render.Shapes;
import com.moulberry.axiom.render.VertexConsumerProvider;
import com.moulberry.axiom.restrictions.AxiomPermission;
import java.util.EnumSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_3486;
import net.minecraft.class_3726;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.lwjgl.glfw.GLFW;

public interface Tool {
    public static final ExecutorService sharedSingleThreadExecutor = Executors.newSingleThreadExecutor();
    public static final ForkJoinPool sharedPoolThreadExecutor = (ForkJoinPool)Executors.newWorkStealingPool();

    public static class_2680 getActiveBlock() {
        if (EditorUI.isActive()) {
            return EditorUI.getActiveBlock();
        }
        return class_2246.field_10340.method_9564();
    }

    @Nullable
    public static class_243 getLookDirection() {
        if (class_310.method_1551().field_1755 != null) {
            return null;
        }
        if (EditorUI.isActive()) {
            if (EditorUI.isMovingCamera()) {
                return null;
            }
            return EditorUI.getMouseLookVector();
        }
        if (class_310.method_1551().field_1719 != null) {
            return class_310.method_1551().field_1719.method_5720();
        }
        return null;
    }

    public static boolean isShiftDown() {
        if (EditorUI.isActive()) {
            return EditorUI.getIO().getKeyShift();
        }
        long window = class_310.method_1551().method_22683().method_4490();
        return GLFW.glfwGetKey((long)window, (int)340) != 0 || GLFW.glfwGetKey((long)window, (int)344) != 0;
    }

    public static boolean isMouseDown(int button) {
        if (EditorUI.isActive()) {
            if (button == 1) {
                return Keybinds.USE_TOOL.isDownIgnoreMods();
            }
            return EditorUI.getIO().getMouseDown(button);
        }
        if (button == 0) {
            return class_310.method_1551().field_1690.field_1886.method_1434();
        }
        if (button == 1) {
            return class_310.method_1551().field_1690.field_1904.method_1434();
        }
        if (button == 2) {
            return class_310.method_1551().field_1690.field_1871.method_1434();
        }
        throw new UnsupportedOperationException("Unknown mouse button id: " + button);
    }

    public static boolean cancelUsing() {
        return class_310.method_1551().field_1687 == null || class_310.method_1551().field_1724 == null || class_310.method_1551().field_1755 != null || !EditorUI.isEnabled();
    }

    public static boolean defaultIncludeFluids() {
        return Axiom.configuration.blockAttributes.makeFluidHitboxesSolid;
    }

    public static RayCaster.RaycastResult raycastBlock() {
        return Tool.raycastBlock(false, true, Tool.defaultIncludeFluids());
    }

    public static RayCaster.RaycastResult raycastBlock(boolean includeSelection, boolean includeNonSolid, boolean includeFluids) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return null;
        }
        class_1297 entity = class_310.method_1551().field_1719;
        if (entity == null) {
            return null;
        }
        class_243 view = Tool.getLookDirection();
        if (view == null) {
            return null;
        }
        class_243 start = entity.method_5836(1.0f);
        return RayCaster.raycast((class_1937)level, start, view, includeSelection, includeFluids &= !entity.method_5777(class_3486.field_15517) && !entity.method_5777(class_3486.field_15518), includeNonSolid);
    }

    public static void renderRaycastOverlay(RayCaster.RaycastResult result, class_4587 matrices, class_4184 camera) {
        if (result != null) {
            Tool.renderRaycastOverlay(result.blockPos(), matrices, camera);
        }
    }

    public static void renderRaycastOverlay(class_2338 pos, class_4587 matrices, class_4184 camera) {
        if (pos != null) {
            class_638 level = class_310.method_1551().field_1687;
            if (level == null) {
                return;
            }
            VertexConsumerProvider provider = VertexConsumerProvider.shared();
            class_287 bufferBuilder = provider.begin(VertexFormat.class_5596.field_27377, class_290.field_29337);
            matrices.method_22903();
            matrices.method_22904((double)pos.method_10263() - camera.method_19326().field_1352, (double)pos.method_10264() - camera.method_19326().field_1351, (double)pos.method_10260() - camera.method_19326().field_1350);
            class_2680 blockState = level.method_8320(pos);
            class_265 voxelShape = blockState.method_26172((class_1922)level, pos, class_3726.method_16195((class_1297)camera.method_19331()));
            Shapes.blockOutline(bufferBuilder, matrices.method_23760(), voxelShape, -668862);
            AxiomRenderer.setShaderColour(1.0f, 1.0f, 1.0f, 1.0f);
            AxiomRenderPipelines.LINES_WITHOUT_WRITE_DEPTH.render(bufferBuilder.method_60794());
            matrices.method_22909();
        }
    }

    default public UserAction.ActionResult callAction(UserAction action, Object object) {
        return UserAction.ActionResult.NOT_HANDLED;
    }

    default public void displayImguiOptions() {
    }

    public void reset();

    default public void toolDeselected() {
    }

    public void render(class_4184 var1, float var2, long var3, class_4587 var5, Matrix4f var6);

    default public class_241 renderAdjustment(float mouseX, float mouseY, class_241 mouseDelta) {
        return mouseDelta;
    }

    default public boolean initiateAdjustment() {
        return false;
    }

    public String name();

    default public Tutorial getTutorial() {
        return null;
    }

    default public String listenForEsc() {
        return null;
    }

    default public String listenForEnter() {
        return null;
    }

    default public void afterBlockBufferUndo() {
    }

    default public void afterBlockBufferRedo() {
    }

    public void writeSettings(class_2487 var1);

    public void loadSettings(class_2487 var1);

    public char iconChar();

    default public boolean showToolSmoothing() {
        return false;
    }

    public String keybindId();

    default public int defaultKeybind() {
        return 0;
    }

    public EnumSet<AxiomPermission> requiredPermissions();
}

