/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.operations;

import com.moulberry.axiom.block_maps.FamilyMap;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.clipboard.SelectionBuffer;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.utils.IntWrapper;
import com.moulberry.axiom.world_modification.BlockBuffer;
import com.moulberry.axiom.world_modification.BlockOrBiomeBuffer;
import com.moulberry.axiom.world_modification.Dispatcher;
import com.moulberry.axiom.world_modification.HistoryEntry;
import java.text.NumberFormat;
import java.util.Map;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_638;

public class TypeReplaceOperation {
    public static void replace(FamilyMap.AxiomBlockFamily from, FamilyMap.AxiomBlockFamily to) {
        SelectionBuffer selectionBuffer = Selection.getSelectionBuffer();
        if (selectionBuffer instanceof SelectionBuffer.AABB) {
            SelectionBuffer.AABB aabb = (SelectionBuffer.AABB)selectionBuffer;
            TypeReplaceOperation.replaceAABB(aabb, from, to);
        } else if (selectionBuffer instanceof SelectionBuffer.Set) {
            SelectionBuffer.Set set = (SelectionBuffer.Set)selectionBuffer;
            TypeReplaceOperation.replaceSet(set, from, to);
        }
    }

    private static <T extends Comparable<T>> class_2680 copyProperty(class_2680 blockState, class_2680 blockState2, class_2769<T> property) {
        return (class_2680)blockState2.method_11657(property, blockState.method_11654(property));
    }

    private static void replaceAABB(SelectionBuffer.AABB aabb, FamilyMap.AxiomBlockFamily from, FamilyMap.AxiomBlockFamily to) {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        BlockBuffer setOperation = new BlockBuffer();
        BlockBuffer previousBlocksForUndo = new BlockBuffer();
        int changeCount = 0;
        int minX = aabb.min().method_10263();
        int minY = aabb.min().method_10264();
        int minZ = aabb.min().method_10260();
        int maxX = aabb.max().method_10263();
        int maxY = aabb.max().method_10264();
        int maxZ = aabb.max().method_10260();
        minY = Math.max(world.method_31607(), minY);
        maxY = Math.min(world.method_31600(), maxY);
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_2680 blockState = world.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
                    if (blockState.method_26204() == class_2246.field_10243) continue;
                    if (blockState.method_26204() == from.getBaseBlock()) {
                        setOperation.set(x, y, z, to.getBaseBlock().method_9564());
                        previousBlocksForUndo.set(x, y, z, blockState);
                        ++changeCount;
                        continue;
                    }
                    if (FamilyMap.getFamilyFor(blockState.method_26204()) != from) continue;
                    FamilyMap.AxiomBlockVariant variant = FamilyMap.getVariantFor(blockState.method_26204());
                    class_2680 toState = null;
                    class_2248 toBlock = to.getVariant(variant);
                    if (toBlock == null) {
                        Map<FamilyMap.AxiomBlockVariant, FamilyMap.VariantConverter> converters = FamilyMap.getVariantConverters(variant);
                        if (converters != null) {
                            for (Map.Entry<FamilyMap.AxiomBlockVariant, FamilyMap.VariantConverter> entry : converters.entrySet()) {
                                toBlock = to.getVariant(entry.getKey());
                                if (toBlock == null) continue;
                                toState = toBlock.method_9564();
                                for (class_2769 property : blockState.method_28501()) {
                                    if (!toState.method_28498(property)) continue;
                                    toState = TypeReplaceOperation.copyProperty(blockState, toState, property);
                                }
                                toState = entry.getValue().convert(blockState, toState, mutableBlockPos.method_10062(), (class_1922)world);
                                break;
                            }
                        }
                    } else {
                        toState = toBlock.method_9564();
                        for (class_2769 property : blockState.method_28501()) {
                            if (!toState.method_28498(property)) continue;
                            toState = TypeReplaceOperation.copyProperty(blockState, toState, property);
                        }
                    }
                    if (toState == null) continue;
                    setOperation.set(x, y, z, toState);
                    previousBlocksForUndo.set(x, y, z, blockState);
                    ++changeCount;
                }
            }
        }
        if (changeCount == 0) {
            return;
        }
        String countString = NumberFormat.getInstance().format(changeCount);
        String blockName = AxiomI18n.get(to.getBaseBlock().method_63499());
        String historyDescription = AxiomI18n.get("axiom.history_description.set_n_blocks_to", countString, blockName);
        Dispatcher.push(new HistoryEntry<BlockOrBiomeBuffer>(setOperation, previousBlocksForUndo, aabb.center(), historyDescription, 0));
    }

    private static void replaceSet(SelectionBuffer.Set set, FamilyMap.AxiomBlockFamily from, FamilyMap.AxiomBlockFamily to) {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        BlockBuffer setOperation = new BlockBuffer();
        BlockBuffer previousBlocksForUndo = new BlockBuffer();
        IntWrapper changeCount = new IntWrapper();
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        set.selectionRegion.forEach((x, y, z) -> {
            class_2680 blockState = world.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
            if (blockState.method_26204() == class_2246.field_10243) {
                return;
            }
            if (blockState.method_26204() == from.getBaseBlock()) {
                setOperation.set(x, y, z, to.getBaseBlock().method_9564());
                previousBlocksForUndo.set(x, y, z, blockState);
                ++changeCount.value;
            } else if (FamilyMap.getFamilyFor(blockState.method_26204()) == from) {
                FamilyMap.AxiomBlockVariant variant = FamilyMap.getVariantFor(blockState.method_26204());
                class_2680 toState = null;
                class_2248 toBlock = to.getVariant(variant);
                if (toBlock == null) {
                    Map<FamilyMap.AxiomBlockVariant, FamilyMap.VariantConverter> converters = FamilyMap.getVariantConverters(variant);
                    if (converters != null) {
                        for (Map.Entry<FamilyMap.AxiomBlockVariant, FamilyMap.VariantConverter> entry : converters.entrySet()) {
                            toBlock = to.getVariant(entry.getKey());
                            if (toBlock == null) continue;
                            toState = toBlock.method_9564();
                            for (class_2769 property : blockState.method_28501()) {
                                if (!toState.method_28498(property)) continue;
                                toState = TypeReplaceOperation.copyProperty(blockState, toState, property);
                            }
                            toState = entry.getValue().convert(blockState, toState, mutableBlockPos.method_10062(), (class_1922)world);
                            break;
                        }
                    }
                } else {
                    toState = toBlock.method_9564();
                    for (class_2769 property : blockState.method_28501()) {
                        if (!toState.method_28498(property)) continue;
                        toState = TypeReplaceOperation.copyProperty(blockState, toState, property);
                    }
                }
                if (toState == null) {
                    return;
                }
                setOperation.set(x, y, z, toState);
                previousBlocksForUndo.set(x, y, z, blockState);
                ++changeCount.value;
            }
        });
        if (changeCount.value == 0) {
            return;
        }
        String countString = NumberFormat.getInstance().format(changeCount.value);
        String blockName = AxiomI18n.get(to.getBaseBlock().method_63499());
        String historyDescription = AxiomI18n.get("axiom.history_description.set_n_blocks_to", countString, blockName);
        Dispatcher.push(new HistoryEntry<BlockOrBiomeBuffer>(setOperation, previousBlocksForUndo, set.selectionRegion.getCenter(), historyDescription, 0));
    }
}

