/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.gizmo;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.moulberry.axiom.core_rendering.AxiomRenderPipelines;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.keybinds.Keybinds;
import com.moulberry.axiom.gizmo.GizmoTarget;
import com.moulberry.axiom.render.Shapes;
import com.moulberry.axiom.render.VertexConsumerProvider;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.utils.PositionUtils;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.joml.Intersectiond;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2d;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;

public class Gizmo {
    private class_243 targetPositionVec;
    private class_243 interpFromPosition;
    private float interpAmount = 0.0f;
    private long lastTime = 0L;
    private float axisMarkerTime = 0.0f;
    private GizmoTarget clickedTarget = null;
    private GizmoTarget hoveredTarget = null;
    private class_243 offsetFromBlockPos;
    public boolean enableRotation = false;
    public boolean yAxisRotationOnly = false;
    public boolean enableScale = false;
    public float rotationSnapRadians = 1.5707964f;
    public boolean enableAxes = true;
    public Quaternionf localRotation = null;
    public int translationSnapping = 1;
    public float minVisualScale = 10.0f;
    public int centerColour = 0xFFFFFF;
    private float lockedDistanceMultiplier = -1.0f;
    private boolean plusX = true;
    private boolean plusY = true;
    private boolean plusZ = true;
    private boolean targetPlusX = true;
    private boolean targetPlusY = true;
    private boolean targetPlusZ = true;
    private GizmoRotation rotation = null;
    private GizmoScale scale = null;
    private static final float SELECT_THRESHOLD = (float)Math.cos(Math.toRadians(1.5));
    private static final float TOO_CLOSE_THRESHOLD = (float)Math.cos(Math.toRadians(1.0));
    private static final float SUPER_TOO_CLOSE_THRESHOLD = (float)Math.cos(Math.toRadians(0.35f));

    public Gizmo(class_2338 target) {
        this(target, class_243.field_1353);
    }

    public Gizmo(class_2338 target, class_243 offsetFromBlockPos) {
        this.targetPositionVec = class_243.method_24953((class_2382)target);
        this.interpFromPosition = class_243.method_24954((class_2382)target);
        this.offsetFromBlockPos = offsetFromBlockPos;
    }

    public Gizmo(class_243 target) {
        this(target, class_243.field_1353);
    }

    public Gizmo(class_243 target, class_243 offsetFromBlockPos) {
        this.targetPositionVec = target;
        this.interpFromPosition = target.method_1023(0.5, 0.5, 0.5);
        this.offsetFromBlockPos = offsetFromBlockPos;
    }

    public class_2338 getTargetPosition() {
        return class_2338.method_49638((class_2374)this.targetPositionVec);
    }

    public class_243 getTargetVec() {
        return this.targetPositionVec;
    }

    @Nullable
    public Quaternionf peekRotation() {
        return this.rotation == null ? null : this.rotation.toQuaternion();
    }

    @Nullable
    public GizmoRotation peekGizmoRotation() {
        return this.rotation;
    }

    public GizmoRotation popRotation() {
        if (this.isGrabbed() || this.rotation == null) {
            return null;
        }
        GizmoRotation rotation = this.rotation;
        this.rotation = null;
        this.clickedTarget = null;
        return rotation;
    }

    @Nullable
    public GizmoScale peekScale() {
        return this.scale;
    }

    public GizmoScale popScale() {
        if (this.isGrabbed() || this.scale == null) {
            return null;
        }
        GizmoScale scale = this.scale;
        this.scale = null;
        this.clickedTarget = null;
        return scale;
    }

    public boolean isGrabbed() {
        return this.clickedTarget != null;
    }

    public boolean isScaleGrabbed() {
        return this.clickedTarget instanceof GizmoTarget.Scale1D;
    }

    public boolean isHovered() {
        return this.hoveredTarget != null;
    }

    public boolean isCenterGrabbed() {
        return this.clickedTarget instanceof GizmoTarget.Move3D;
    }

    public boolean isCenterHovered() {
        return this.hoveredTarget instanceof GizmoTarget.Move3D;
    }

    public class_243 snapPosition(class_243 position, boolean increaseSnap, boolean snapX, boolean snapY, boolean snapZ) {
        if (Tool.isShiftDown()) {
            return position;
        }
        double x = snapX ? (increaseSnap ? Math.floor(position.field_1352) : (double)Math.round((position.field_1352 - 0.5) * (double)this.translationSnapping) / (double)this.translationSnapping) : position.field_1352 - 0.5;
        double y = snapY ? (increaseSnap ? Math.floor(position.field_1351) : (double)Math.round((position.field_1351 - 0.5) * (double)this.translationSnapping) / (double)this.translationSnapping) : position.field_1351 - 0.5;
        double z = snapZ ? (increaseSnap ? Math.floor(position.field_1350) : (double)Math.round((position.field_1350 - 0.5) * (double)this.translationSnapping) / (double)this.translationSnapping) : position.field_1350 - 0.5;
        return new class_243(x + 0.5, y + 0.5, z + 0.5);
    }

    public class_243 getLowerCornerOfTargetPosition() {
        return new class_243(this.targetPositionVec.field_1352 - 0.5, this.targetPositionVec.field_1351 - 0.5, this.targetPositionVec.field_1350 - 0.5);
    }

    public class_243 getInterpPosition() {
        return this.interpFromPosition.method_35590(this.getLowerCornerOfTargetPosition(), (double)this.interpAmount).method_1031(0.5, 0.5, 0.5).method_1019(this.offsetFromBlockPos);
    }

    public void handleScroll(int xScroll, int yScroll, boolean isCtrlDown, class_243 look) {
        this.axisMarkerTime = 40.0f;
        if (this.clickedTarget == null) {
            class_2350[] directions = PositionUtils.orderedByNearest(look);
            class_2350 mainDirection = directions[0];
            class_2350 secondaryDirection = Gizmo.findSecondaryAxis(directions);
            int translationSnapping = isCtrlDown ? 1 : this.translationSnapping;
            class_243 newPosition = this.targetPositionVec.method_43206(mainDirection, (double)((float)yScroll / (float)translationSnapping)).method_43206(secondaryDirection, (double)((float)xScroll / (float)translationSnapping));
            this.moveToWithoutChangingAxisTarget(newPosition);
        } else {
            GizmoTarget directions = this.clickedTarget;
            if (directions instanceof GizmoTarget.Move3D) {
                GizmoTarget.Move3D move3D = (GizmoTarget.Move3D)directions;
                float translationSnapping = isCtrlDown ? 1.0f : (float)this.translationSnapping;
                move3D.distance += (float)yScroll / translationSnapping;
                if (move3D.distance < 1.0f) {
                    move3D.distance = 1.0f;
                }
            }
        }
    }

    private void moveToWithoutChangingAxisTarget(class_243 newPos) {
        if (!newPos.equals((Object)this.targetPositionVec)) {
            this.interpFromPosition = this.interpFromPosition.method_35590(this.getLowerCornerOfTargetPosition(), (double)this.interpAmount);
            this.targetPositionVec = newPos;
            this.interpAmount = 0.0f;
        }
    }

    public void moveToVec(class_243 newPosVec) {
        this.moveToWithoutChangingAxisTarget(newPosVec);
        GizmoTarget gizmoTarget = this.clickedTarget;
        if (gizmoTarget instanceof GizmoTarget.Move1D) {
            GizmoTarget.Move1D move1D = (GizmoTarget.Move1D)gizmoTarget;
            move1D.vector = move1D.vector.method_1019(newPosVec.method_1020(this.targetPositionVec));
        } else {
            gizmoTarget = this.clickedTarget;
            if (gizmoTarget instanceof GizmoTarget.Move2D) {
                GizmoTarget.Move2D move2D = (GizmoTarget.Move2D)gizmoTarget;
                move2D.origin = move2D.origin.method_1019(newPosVec.method_1020(this.targetPositionVec));
            }
        }
    }

    public void moveToVecInstantly(class_243 newPosVec) {
        this.moveToVec(newPosVec);
        this.interpAmount = 1.0f;
    }

    public void moveTo(class_2338 newPos) {
        this.moveToVec(class_243.method_24953((class_2382)newPos));
    }

    public void moveToInstantly(class_2338 newPos) {
        this.moveTo(newPos);
        this.interpAmount = 1.0f;
    }

    public void setAxisDirections(boolean plusX, boolean plusY, boolean plusZ) {
        this.targetPlusX = plusX;
        this.targetPlusY = plusY;
        this.targetPlusZ = plusZ;
    }

    public void setOffset(class_243 offsetFromBlockPos) {
        this.interpFromPosition = this.interpFromPosition.method_35590(this.getLowerCornerOfTargetPosition(), (double)this.interpAmount);
        this.interpAmount = 0.0f;
        class_243 delta = offsetFromBlockPos.method_1020(this.offsetFromBlockPos);
        this.interpFromPosition = this.interpFromPosition.method_1020(delta);
        this.offsetFromBlockPos = offsetFromBlockPos;
    }

    public void setOffsetInstantly(class_243 offsetFromBlockPos) {
        this.offsetFromBlockPos = offsetFromBlockPos;
        this.interpAmount = 1.0f;
    }

    public class_243 getOffset() {
        return this.offsetFromBlockPos;
    }

    private static class_2350 findSecondaryAxis(class_2350[] directions) {
        for (class_2350 direction : directions) {
            switch (direction) {
                case field_11043: {
                    return class_2350.field_11039;
                }
                case field_11035: {
                    return class_2350.field_11034;
                }
                case field_11039: {
                    return class_2350.field_11035;
                }
                case field_11034: {
                    return class_2350.field_11043;
                }
            }
        }
        return class_2350.field_11043;
    }

    public boolean leftClick() {
        if (this.hoveredTarget == null) {
            return false;
        }
        if (!this.enableAxes) {
            this.enableAxes = true;
        } else {
            this.clickedTarget = this.hoveredTarget;
        }
        return true;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void update(long time, class_243 lookDirection, boolean holdingLmb, boolean pressingCtrl, boolean showHover) {
        block83: {
            block81: {
                block86: {
                    block85: {
                        block84: {
                            block82: {
                                player = Objects.requireNonNull(class_310.method_1551().field_1724);
                                if (this.enableAxes && EditorUI.isActive() && EditorUI.canProcessKeybinds) {
                                    directions = class_2350.method_10159((class_1297)player);
                                    forwards = null;
                                    for (GizmoTarget direction : directions) {
                                        if (direction.method_10166() == class_2350.class_2351.field_11052) continue;
                                        forwards = direction;
                                        break;
                                    }
                                    if (forwards != null) {
                                        if (Keybinds.NUDGE_FORWARDS.isPressed(true)) {
                                            this.moveToVecInstantly(this.getTargetVec().method_43206((class_2350)forwards, 1.0));
                                        }
                                        if (Keybinds.NUDGE_BACKWARDS.isPressed(true)) {
                                            this.moveToVecInstantly(this.getTargetVec().method_43206(forwards.method_10153(), 1.0));
                                        }
                                        if (Keybinds.NUDGE_RIGHT.isPressed(true)) {
                                            this.moveToVecInstantly(this.getTargetVec().method_43206(forwards.method_10170(), 1.0));
                                        }
                                        if (Keybinds.NUDGE_LEFT.isPressed(true)) {
                                            this.moveToVecInstantly(this.getTargetVec().method_43206(forwards.method_10160(), 1.0));
                                        }
                                    }
                                    if (Keybinds.NUDGE_PLUS_Y.isPressed(true)) {
                                        this.moveToVecInstantly(this.getTargetVec().method_43206(class_2350.field_11036, 1.0));
                                    }
                                    if (Keybinds.NUDGE_MINUS_Y.isPressed(true)) {
                                        this.moveToVecInstantly(this.getTargetVec().method_43206(class_2350.field_11033, 1.0));
                                    }
                                }
                                if (!holdingLmb) {
                                    this.clickedTarget = null;
                                }
                                if (this.clickedTarget == null) {
                                    this.lockedDistanceMultiplier = -1.0f;
                                } else if (this.lockedDistanceMultiplier < 0.0f) {
                                    this.lockedDistanceMultiplier = this.getDistanceMultiplier(player.method_33571());
                                }
                                if (this.clickedTarget == null || lookDirection == null) break block81;
                                direction = this.clickedTarget;
                                if (!(direction instanceof GizmoTarget.Move3D)) break block82;
                                move3D = (GizmoTarget.Move3D)direction;
                                if (this.axisMarkerTime < 20.0f) {
                                    this.axisMarkerTime = 20.0f;
                                }
                                offset = lookDirection.method_1021((double)move3D.distance);
                                offset = player.method_33571().method_1020(this.offsetFromBlockPos).method_1019((class_243)offset);
                                this.moveToWithoutChangingAxisTarget(this.snapPosition((class_243)offset, pressingCtrl, true, true, true));
                                break block83;
                            }
                            offset = this.clickedTarget;
                            if (!(offset instanceof GizmoTarget.Move1D)) break block84;
                            move1D = (GizmoTarget.Move1D)offset;
                            if (!this.enableAxes) break block84;
                            if (this.axisMarkerTime < 20.0f) {
                                this.axisMarkerTime = 20.0f;
                            }
                            l1 = player.method_33571().method_1020(this.offsetFromBlockPos);
                            l2 = l1.method_1019(lookDirection.method_1021(2000.0));
                            intersection = new Vector3d();
                            Intersectiond.findClosestPointsLineSegments((double)(move1D.origin.field_1352 - move1D.vector.field_1352 * 500.0), (double)(move1D.origin.field_1351 - move1D.vector.field_1351 * 500.0), (double)(move1D.origin.field_1350 - move1D.vector.field_1350 * 500.0), (double)(move1D.origin.field_1352 + move1D.vector.field_1352 * 500.0), (double)(move1D.origin.field_1351 + move1D.vector.field_1351 * 500.0), (double)(move1D.origin.field_1350 + move1D.vector.field_1350 * 500.0), (double)l1.field_1352, (double)l1.field_1351, (double)l1.field_1350, (double)l2.field_1352, (double)l2.field_1351, (double)l2.field_1350, (Vector3d)intersection, (Vector3d)new Vector3d());
                            snapX = move1D.clickedAxis == class_2350.class_2351.field_11048;
                            snapY = move1D.clickedAxis == class_2350.class_2351.field_11052;
                            snapZ = move1D.clickedAxis == class_2350.class_2351.field_11051;
                            this.moveToWithoutChangingAxisTarget(this.snapPosition(new class_243(intersection.x - move1D.vector.field_1352, intersection.y - move1D.vector.field_1351, intersection.z - move1D.vector.field_1350), pressingCtrl, snapX, snapY, snapZ));
                            break block83;
                        }
                        if (!((l1 = this.clickedTarget) instanceof GizmoTarget.Move2D)) break block85;
                        move2D = (GizmoTarget.Move2D)l1;
                        if (!this.enableAxes) break block85;
                        if (this.axisMarkerTime < 20.0f) {
                            this.axisMarkerTime = 20.0f;
                        }
                        l1 = player.method_33571();
                        l2 = l1.method_1019(lookDirection.method_1021(2000.0));
                        targetPositionD = this.targetPositionVec.method_1019(this.offsetFromBlockPos);
                        intersection = new Vector3d();
                        switch (1.$SwitchMap$net$minecraft$core$Direction$Axis[move2D.axis.ordinal()]) {
                            default: {
                                throw new IncompatibleClassChangeError();
                            }
                            case 1: {
                                vector3d = new Vector3d(1.0, 0.0, 0.0);
                                if (this.localRotation != null) {
                                    this.localRotation.transform(vector3d);
                                }
                                if (Intersectiond.intersectLineSegmentPlane((double)l1.field_1352, (double)l1.field_1351, (double)l1.field_1350, (double)l2.field_1352, (double)l2.field_1351, (double)l2.field_1350, (double)vector3d.x, (double)vector3d.y, (double)vector3d.z, (double)(-(planeConstant = vector3d.x * targetPositionD.field_1352 + vector3d.y * targetPositionD.field_1351 + vector3d.z * targetPositionD.field_1350)), (Vector3d)intersection)) {
                                    break;
                                }
                                break block83;
                            }
                            case 2: {
                                vector3d = new Vector3d(0.0, 1.0, 0.0);
                                if (this.localRotation != null) {
                                    this.localRotation.transform(vector3d);
                                }
                                if (Intersectiond.intersectLineSegmentPlane((double)l1.field_1352, (double)l1.field_1351, (double)l1.field_1350, (double)l2.field_1352, (double)l2.field_1351, (double)l2.field_1350, (double)vector3d.x, (double)vector3d.y, (double)vector3d.z, (double)(-(planeConstant = vector3d.x * targetPositionD.field_1352 + vector3d.y * targetPositionD.field_1351 + vector3d.z * targetPositionD.field_1350)), (Vector3d)intersection)) {
                                    break;
                                }
                                break block83;
                            }
                            case 3: {
                                vector3d = new Vector3d(0.0, 0.0, 1.0);
                                if (this.localRotation != null) {
                                    this.localRotation.transform(vector3d);
                                }
                                if (Intersectiond.intersectLineSegmentPlane((double)l1.field_1352, (double)l1.field_1351, (double)l1.field_1350, (double)l2.field_1352, (double)l2.field_1351, (double)l2.field_1350, (double)vector3d.x, (double)vector3d.y, (double)vector3d.z, (double)(-(planeConstant = vector3d.x * targetPositionD.field_1352 + vector3d.y * targetPositionD.field_1351 + vector3d.z * targetPositionD.field_1350)), (Vector3d)intersection)) {
                                    break;
                                }
                                break block83;
                            }
                        }
                        snapX = move2D.axis != class_2350.class_2351.field_11048;
                        snapY = move2D.axis != class_2350.class_2351.field_11052;
                        snapZ = move2D.axis != class_2350.class_2351.field_11051;
                        this.moveToWithoutChangingAxisTarget(this.snapPosition(new class_243(intersection.x - move2D.origin.field_1352 - this.offsetFromBlockPos.field_1352, intersection.y - move2D.origin.field_1351 - this.offsetFromBlockPos.field_1351, intersection.z - move2D.origin.field_1350 - this.offsetFromBlockPos.field_1350), pressingCtrl, snapX, snapY, snapZ));
                        break block83;
                    }
                    if (!((l1 = this.clickedTarget) instanceof GizmoTarget.Rotate)) break block86;
                    rotate = (GizmoTarget.Rotate)l1;
                    if (!this.enableAxes || !this.enableRotation) break block86;
                    l1 = player.method_33571().method_1020(this.offsetFromBlockPos);
                    l2 = l1.method_1019(lookDirection.method_1021(2000.0));
                    targetPositionD = this.targetPositionVec.method_1019(this.offsetFromBlockPos);
                    intersection = new Vector3d();
                    tau = 6.2831855f;
                    snap = pressingCtrl != false ? Math.max(this.rotationSnapRadians, 0.2617994f) : this.rotationSnapRadians;
                    switch (1.$SwitchMap$net$minecraft$core$Direction$Axis[rotate.axis.ordinal()]) {
                        case 1: {
                            vector3d = new Vector3d(1.0, 0.0, 0.0);
                            if (this.localRotation != null) {
                                this.localRotation.transform(vector3d);
                            }
                            if (Intersectiond.intersectLineSegmentPlane((double)l1.field_1352, (double)l1.field_1351, (double)l1.field_1350, (double)l2.field_1352, (double)l2.field_1351, (double)l2.field_1350, (double)vector3d.x, (double)vector3d.y, (double)vector3d.z, (double)(-(planeConstant = vector3d.x * targetPositionD.field_1352 + vector3d.y * targetPositionD.field_1351 + vector3d.z * targetPositionD.field_1350)), (Vector3d)intersection)) {
                                diff = new Vector3d(intersection.x - targetPositionD.field_1352, intersection.y - targetPositionD.field_1351, intersection.z - targetPositionD.field_1350);
                                if (this.localRotation != null) {
                                    this.localRotation.transformInverse(diff);
                                }
                                angle = (float)Math.atan2(diff.z, diff.y);
                                if (rotate.firstTime) {
                                    rotate.startAngle = angle;
                                    rotate.firstTime = false;
                                    break;
                                }
                                angleFromStart = angle - rotate.startAngle;
                                if (!Tool.isShiftDown()) {
                                    angleFromStart = (float)Math.round(angleFromStart / snap) * snap;
                                }
                                angleFromStart %= tau;
                                if (this.rotation != null && this.rotation.axis == class_2350.class_2351.field_11048) {
                                    if (this.rotation.radians <= -tau / 4.0f) {
                                        if (angleFromStart > 0.0f) {
                                            angleFromStart -= tau;
                                        }
                                    } else if (this.rotation.radians >= tau / 4.0f) {
                                        if (angleFromStart < 0.0f) {
                                            angleFromStart += tau;
                                        }
                                    } else {
                                        if ((double)angleFromStart < -3.141592653589793) {
                                            angleFromStart += tau;
                                        }
                                        if ((double)angleFromStart > 3.141592653589793) {
                                            angleFromStart -= tau;
                                        }
                                    }
                                }
                                this.rotation = new GizmoRotation(class_2350.class_2351.field_11048, angleFromStart);
                                break;
                            }
                            break block83;
                        }
                        case 2: {
                            vector3d = new Vector3d(0.0, 1.0, 0.0);
                            if (this.localRotation != null) {
                                this.localRotation.transform(vector3d);
                            }
                            if (Intersectiond.intersectLineSegmentPlane((double)l1.field_1352, (double)l1.field_1351, (double)l1.field_1350, (double)l2.field_1352, (double)l2.field_1351, (double)l2.field_1350, (double)vector3d.x, (double)vector3d.y, (double)vector3d.z, (double)(-(planeConstant = vector3d.x * targetPositionD.field_1352 + vector3d.y * targetPositionD.field_1351 + vector3d.z * targetPositionD.field_1350)), (Vector3d)intersection)) {
                                diff = new Vector3d(intersection.x - targetPositionD.field_1352, intersection.y - targetPositionD.field_1351, intersection.z - targetPositionD.field_1350);
                                if (this.localRotation != null) {
                                    this.localRotation.transformInverse(diff);
                                }
                                angle = (float)Math.atan2(diff.x, diff.z);
                                if (rotate.firstTime) {
                                    rotate.startAngle = angle;
                                    rotate.firstTime = false;
                                    break;
                                }
                                angleFromStart = angle - rotate.startAngle;
                                if (!Tool.isShiftDown()) {
                                    angleFromStart = (float)Math.round(angleFromStart / snap) * snap;
                                }
                                angleFromStart %= tau;
                                if (this.rotation != null && this.rotation.axis == class_2350.class_2351.field_11052) {
                                    if (this.rotation.radians <= -tau / 4.0f) {
                                        if (angleFromStart > 0.0f) {
                                            angleFromStart -= tau;
                                        }
                                    } else if (this.rotation.radians >= tau / 4.0f) {
                                        if (angleFromStart < 0.0f) {
                                            angleFromStart += tau;
                                        }
                                    } else {
                                        if ((double)angleFromStart < -3.141592653589793) {
                                            angleFromStart += tau;
                                        }
                                        if ((double)angleFromStart > 3.141592653589793) {
                                            angleFromStart -= tau;
                                        }
                                    }
                                }
                                this.rotation = new GizmoRotation(class_2350.class_2351.field_11052, angleFromStart);
                                break;
                            }
                            break block83;
                        }
                        case 3: {
                            vector3d = new Vector3d(0.0, 0.0, 1.0);
                            if (this.localRotation != null) {
                                this.localRotation.transform(vector3d);
                            }
                            if (!Intersectiond.intersectLineSegmentPlane((double)l1.field_1352, (double)l1.field_1351, (double)l1.field_1350, (double)l2.field_1352, (double)l2.field_1351, (double)l2.field_1350, (double)vector3d.x, (double)vector3d.y, (double)vector3d.z, (double)(-(planeConstant = vector3d.x * targetPositionD.field_1352 + vector3d.y * targetPositionD.field_1351 + vector3d.z * targetPositionD.field_1350)), (Vector3d)intersection)) break;
                            diff = new Vector3d(intersection.x - targetPositionD.field_1352, intersection.y - targetPositionD.field_1351, intersection.z - targetPositionD.field_1350);
                            if (this.localRotation != null) {
                                this.localRotation.transformInverse(diff);
                            }
                            angle = (float)Math.atan2(diff.y, diff.x);
                            if (rotate.firstTime) {
                                rotate.startAngle = angle;
                                rotate.firstTime = false;
                                break;
                            }
                            angleFromStart = angle - rotate.startAngle;
                            if (!Tool.isShiftDown()) {
                                angleFromStart = (float)Math.round(angleFromStart / snap) * snap;
                            }
                            angleFromStart %= tau;
                            if (this.rotation != null && this.rotation.axis == class_2350.class_2351.field_11051) {
                                if (this.rotation.radians < -tau / 4.0f) {
                                    if (angleFromStart > 0.0f) {
                                        angleFromStart -= tau;
                                    }
                                } else if (this.rotation.radians > tau / 4.0f) {
                                    if (angleFromStart < 0.0f) {
                                        angleFromStart += tau;
                                    }
                                } else {
                                    if ((double)angleFromStart < -3.141592653589793) {
                                        angleFromStart += tau;
                                    }
                                    if ((double)angleFromStart > 3.141592653589793) {
                                        angleFromStart -= tau;
                                    }
                                }
                            }
                            this.rotation = new GizmoRotation(class_2350.class_2351.field_11051, angleFromStart);
                        }
                    }
                    break block83;
                }
                if (!((l1 = this.clickedTarget) instanceof GizmoTarget.Scale1D)) ** GOTO lbl-1000
                scale1D = (GizmoTarget.Scale1D)l1;
                if (this.enableAxes && this.enableScale) {
                    target = this.targetPositionVec;
                    l1 = player.method_33571().method_1020(this.offsetFromBlockPos);
                    l2 = l1.method_1019(lookDirection.method_1021(2000.0));
                    intersection = new Vector3d();
                    Intersectiond.findClosestPointsLineSegments((double)(target.field_1352 - scale1D.vector.field_1352 * 500.0), (double)(target.field_1351 - scale1D.vector.field_1351 * 500.0), (double)(target.field_1350 - scale1D.vector.field_1350 * 500.0), (double)(target.field_1352 + scale1D.vector.field_1352 * 500.0), (double)(target.field_1351 + scale1D.vector.field_1351 * 500.0), (double)(target.field_1350 + scale1D.vector.field_1350 * 500.0), (double)l1.field_1352, (double)l1.field_1351, (double)l1.field_1350, (double)l2.field_1352, (double)l2.field_1351, (double)l2.field_1350, (Vector3d)intersection, (Vector3d)new Vector3d());
                    distanceToCenter = intersection.distance(target.field_1352, target.field_1351, target.field_1350);
                    this.scale = new GizmoScale(scale1D.clickedAxis, pressingCtrl, (float)(distanceToCenter / (double)scale1D.clickedLength));
                } else lbl-1000:
                // 2 sources

                {
                    this.clickedTarget = null;
                    this.hoveredTarget = null;
                }
                break block83;
            }
            if (showHover && lookDirection != null) {
                this.hoveredTarget = this.calculateAxisTarget(lookDirection);
                this.plusX = this.targetPlusX;
                this.plusY = this.targetPlusY;
                this.plusZ = this.targetPlusZ;
            } else if (lookDirection != null) {
                this.hoveredTarget = null;
                this.plusX = this.targetPlusX;
                this.plusY = this.targetPlusY;
                this.plusZ = this.targetPlusZ;
            }
        }
        if (this.lastTime < time) {
            delta = (float)(time - this.lastTime) / 1000000.0f / 50.0f;
            this.axisMarkerTime -= delta;
            if (this.axisMarkerTime < 0.0f) {
                this.axisMarkerTime = 0.0f;
            }
            this.interpAmount += delta;
            if (this.interpAmount > 1.0f) {
                this.interpAmount = 1.0f;
            }
        }
        this.lastTime = time;
    }

    public void render(class_4587 matrices, class_4184 camera, boolean pressedCtrl) {
        class_243 renderPos = this.interpFromPosition.method_35590(this.getLowerCornerOfTargetPosition(), (double)this.interpAmount);
        renderPos = renderPos.method_1019(this.offsetFromBlockPos);
        matrices.method_22903();
        matrices.method_22904(renderPos.method_10216() + 0.5 - camera.method_19326().field_1352, renderPos.method_10214() + 0.5 - camera.method_19326().field_1351, renderPos.method_10215() + 0.5 - camera.method_19326().field_1350);
        if (this.localRotation != null) {
            matrices.method_22907((Quaternionfc)this.localRotation);
        }
        if (this.axisMarkerTime > 0.0f) {
            this.renderAxisMarkers(matrices);
        }
        this.renderPlacementHandles(matrices, camera, pressedCtrl);
        matrices.method_22909();
    }

    private void renderAxisMarkers(class_4587 matrices) {
        VertexConsumerProvider provider = VertexConsumerProvider.shared();
        class_287 bufferBuilder = provider.begin(VertexFormat.class_5596.field_27377, class_290.field_29337);
        this.renderAxisMarker(matrices, bufferBuilder, 1, 0, 0);
        this.renderAxisMarker(matrices, bufferBuilder, 0, 1, 0);
        this.renderAxisMarker(matrices, bufferBuilder, 0, 0, 1);
        AxiomRenderPipelines.LINES_WITHOUT_WRITE_DEPTH.render(provider.build());
    }

    private void renderAxisMarker(class_4587 matrices, class_287 builder, int r, int g2, int b) {
        float opacity = 1.0f;
        if (this.axisMarkerTime < 10.0f) {
            opacity = this.axisMarkerTime / 10.0f;
        }
        class_4587.class_4665 pose = matrices.method_23760();
        for (int i = -5; i <= 4; ++i) {
            builder.method_56824(pose, (float)(i * 20 * r), (float)(i * 20 * g2), (float)(i * 20 * b)).method_22915((float)r, (float)g2, (float)b, 0.5f * opacity).method_60831(pose, (float)r, (float)g2, (float)b);
            builder.method_56824(pose, (float)((i + 1) * 20 * r), (float)((i + 1) * 20 * g2), (float)((i + 1) * 20 * b)).method_22915((float)r, (float)g2, (float)b, 0.5f * opacity).method_60831(pose, (float)r, (float)g2, (float)b);
        }
    }

    private float getDistanceMultiplier(class_243 cameraPosition) {
        if (this.lockedDistanceMultiplier > 0.5f) {
            return this.lockedDistanceMultiplier;
        }
        float distanceMultiplier = (float)cameraPosition.method_1022(this.targetPositionVec);
        if (distanceMultiplier < this.minVisualScale) {
            distanceMultiplier = this.minVisualScale;
        }
        return distanceMultiplier / 20.0f;
    }

    /*
     * Unable to fully structure code
     */
    private void renderPlacementHandles(class_4587 matrices, class_4184 camera, boolean pressedCtrl) {
        block79: {
            block84: {
                block83: {
                    block82: {
                        block81: {
                            block80: {
                                provider = VertexConsumerProvider.shared();
                                distanceMultiplier = this.getDistanceMultiplier(camera.method_19326());
                                axisLen = 4.0f * distanceMultiplier;
                                boxSize = 0.3f * distanceMultiplier;
                                if (!this.enableAxes) break block79;
                                mX = this.plusX != false ? 1 : -1;
                                mY = this.plusY != false ? 1 : -1;
                                mZ = this.plusZ != false ? 1 : -1;
                                clickedAny = this.clickedTarget != null;
                                var14_14 = this.clickedTarget;
                                if (!(var14_14 instanceof GizmoTarget.Move2D)) ** GOTO lbl-1000
                                move2D = (GizmoTarget.Move2D)var14_14;
                                if (move2D.axis == class_2350.class_2351.field_11048) {
                                    v0 = true;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    v0 = false;
                                }
                                click2DX = v0;
                                var15_19 = this.clickedTarget;
                                if (!(var15_19 instanceof GizmoTarget.Move2D)) ** GOTO lbl-1000
                                move2D = (GizmoTarget.Move2D)var15_19;
                                if (move2D.axis == class_2350.class_2351.field_11052) {
                                    v1 = true;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    v1 = false;
                                }
                                click2DY = v1;
                                var16_21 = this.clickedTarget;
                                if (!(var16_21 instanceof GizmoTarget.Move2D)) ** GOTO lbl-1000
                                move2D = (GizmoTarget.Move2D)var16_21;
                                if (move2D.axis == class_2350.class_2351.field_11051) {
                                    v2 = true;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    v2 = false;
                                }
                                click2DZ = v2;
                                var17_23 = this.hoveredTarget;
                                if (!(var17_23 instanceof GizmoTarget.Move1D)) break block80;
                                move1D = (GizmoTarget.Move1D)var17_23;
                                if (move1D.clickedAxis == class_2350.class_2351.field_11048) ** GOTO lbl-1000
                            }
                            if (click2DY || click2DZ) lbl-1000:
                            // 2 sources

                            {
                                v3 = true;
                            } else {
                                v3 = false;
                            }
                            hoverAxisX = v3;
                            var18_25 = this.hoveredTarget;
                            if (!(var18_25 instanceof GizmoTarget.Move1D)) break block81;
                            move1D = (GizmoTarget.Move1D)var18_25;
                            if (move1D.clickedAxis == class_2350.class_2351.field_11052) ** GOTO lbl-1000
                        }
                        if (click2DX || click2DZ) lbl-1000:
                        // 2 sources

                        {
                            v4 = true;
                        } else {
                            v4 = false;
                        }
                        hoverAxisY = v4;
                        var19_27 = this.hoveredTarget;
                        if (!(var19_27 instanceof GizmoTarget.Move1D)) break block82;
                        move1D = (GizmoTarget.Move1D)var19_27;
                        if (move1D.clickedAxis == class_2350.class_2351.field_11051) ** GOTO lbl-1000
                    }
                    if (click2DX || click2DY) lbl-1000:
                    // 2 sources

                    {
                        v5 = true;
                    } else {
                        v5 = false;
                    }
                    hoverAxisZ = v5;
                    clickAnyAxis = this.clickedTarget instanceof GizmoTarget.Move1D != false || this.clickedTarget instanceof GizmoTarget.Move2D != false;
                    var21_29 = this.hoveredTarget;
                    if (!(var21_29 instanceof GizmoTarget.Move2D)) ** GOTO lbl-1000
                    move2D = (GizmoTarget.Move2D)var21_29;
                    if (move2D.axis == class_2350.class_2351.field_11048) {
                        v6 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v6 = false;
                    }
                    hover2DX = v6;
                    var22_33 = this.hoveredTarget;
                    if (!(var22_33 instanceof GizmoTarget.Move2D)) ** GOTO lbl-1000
                    move2D = (GizmoTarget.Move2D)var22_33;
                    if (move2D.axis == class_2350.class_2351.field_11052) {
                        v7 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v7 = false;
                    }
                    hover2DY = v7;
                    var23_35 = this.hoveredTarget;
                    if (!(var23_35 instanceof GizmoTarget.Move2D)) ** GOTO lbl-1000
                    move2D = (GizmoTarget.Move2D)var23_35;
                    if (move2D.axis == class_2350.class_2351.field_11051) {
                        v8 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v8 = false;
                    }
                    hover2DZ = v8;
                    clickAny2D = this.clickedTarget instanceof GizmoTarget.Move2D;
                    var25_37 = this.hoveredTarget;
                    if (!(var25_37 instanceof GizmoTarget.Rotate)) ** GOTO lbl-1000
                    rotate = (GizmoTarget.Rotate)var25_37;
                    if (rotate.axis == class_2350.class_2351.field_11048) {
                        v9 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v9 = false;
                    }
                    hoverRotX = v9;
                    var26_41 = this.hoveredTarget;
                    if (!(var26_41 instanceof GizmoTarget.Rotate)) ** GOTO lbl-1000
                    rotate = (GizmoTarget.Rotate)var26_41;
                    if (rotate.axis == class_2350.class_2351.field_11052) {
                        v10 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v10 = false;
                    }
                    hoverRotY = v10;
                    var27_43 = this.hoveredTarget;
                    if (!(var27_43 instanceof GizmoTarget.Rotate)) ** GOTO lbl-1000
                    rotate = (GizmoTarget.Rotate)var27_43;
                    if (rotate.axis == class_2350.class_2351.field_11051) {
                        v11 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v11 = false;
                    }
                    hoverRotZ = v11;
                    clickAnyRot = this.clickedTarget instanceof GizmoTarget.Rotate;
                    UNSELECTED_RED = -1430323200;
                    UNSELECTED_GREEN = -1442791680;
                    UNSELECTED_BLUE = -1442840385;
                    SELECTED_RED = -26215;
                    SELECTED_GREEN = -4194369;
                    SELECTED_BLUE = -8355585;
                    colourAxisX = hoverAxisX != false ? -26215 : -1430323200;
                    colourAxisY = hoverAxisY != false ? -4194369 : -1442791680;
                    colourAxisZ = hoverAxisZ != false ? -8355585 : -1442840385;
                    colour2DX = hover2DX != false ? -26215 : -1430323200;
                    colour2DY = hover2DY != false ? -4194369 : -1442791680;
                    colour2DZ = hover2DZ != false ? -8355585 : -1442840385;
                    colourRotX = hoverRotX != false ? -26215 : -1430323200;
                    colourRotY = hoverRotY != false ? -4194369 : -1442791680;
                    colourRotZ = hoverRotZ != false ? -8355585 : -1442840385;
                    pose = matrices.method_23760();
                    if (clickAnyAxis || !clickedAny) {
                        bufferBuilder = provider.begin(VertexFormat.class_5596.field_27377, class_290.field_29337);
                        RenderSystem.lineWidth((float)3.0f);
                        bufferBuilder.method_56824(pose, (float)mX * boxSize, 0.0f, 0.0f).method_39415(colourAxisX).method_60831(pose, 1.0f, 0.0f, 0.0f);
                        bufferBuilder.method_56824(pose, (float)mX * axisLen, 0.0f, 0.0f).method_39415(colourAxisX).method_60831(pose, 1.0f, 0.0f, 0.0f);
                        bufferBuilder.method_56824(pose, 0.0f, (float)mY * boxSize, 0.0f).method_39415(colourAxisY).method_60831(pose, 0.0f, 1.0f, 0.0f);
                        bufferBuilder.method_56824(pose, 0.0f, (float)mY * axisLen, 0.0f).method_39415(colourAxisY).method_60831(pose, 0.0f, 1.0f, 0.0f);
                        bufferBuilder.method_56824(pose, 0.0f, 0.0f, (float)mZ * boxSize).method_39415(colourAxisZ).method_60831(pose, 0.0f, 0.0f, 1.0f);
                        bufferBuilder.method_56824(pose, 0.0f, 0.0f, (float)mZ * axisLen).method_39415(colourAxisZ).method_60831(pose, 0.0f, 0.0f, 1.0f);
                        AxiomRenderPipelines.GIZMO_LINES.render(provider.build());
                    }
                    coneLen = axisLen / 5.0f;
                    coneRadius = coneLen / 3.0f;
                    if (clickAnyAxis || !clickedAny) {
                        Shapes.drawCone(provider, pose.method_23761(), new class_243((double)((float)mX * axisLen), 0.0, 0.0), new class_243((double)((float)mX * (axisLen + coneLen)), 0.0, 0.0), 0, coneRadius, colourAxisX, AxiomRenderPipelines.GIZMO_POSITION_COLOR);
                        Shapes.drawCone(provider, pose.method_23761(), new class_243(0.0, (double)((float)mY * axisLen), 0.0), new class_243(0.0, (double)((float)mY * (axisLen + coneLen)), 0.0), 1, coneRadius, colourAxisY, AxiomRenderPipelines.GIZMO_POSITION_COLOR);
                        Shapes.drawCone(provider, pose.method_23761(), new class_243(0.0, 0.0, (double)((float)mZ * axisLen)), new class_243(0.0, 0.0, (double)((float)mZ * (axisLen + coneLen))), 2, coneRadius, colourAxisZ, AxiomRenderPipelines.GIZMO_POSITION_COLOR);
                    }
                    if (this.enableRotation && (clickAnyRot || !clickedAny)) {
                        bufferBuilder = provider.begin(VertexFormat.class_5596.field_27377, class_290.field_29337);
                        RenderSystem.lineWidth((float)3.0f);
                        cameraPosition = class_310.method_1551().field_1719.method_33571();
                        target = this.targetPositionVec;
                        deltaToCamera = target.method_1020(cameraPosition);
                        offsetTarget = target.method_1019(deltaToCamera.method_1021(0.05));
                        intersection = new Vector3d();
                        vector1 = new Vector3d();
                        vector2 = new Vector3d();
                        deltaToCamera = deltaToCamera.method_1029();
                        planarK = offsetTarget.field_1352 * deltaToCamera.field_1352 + offsetTarget.field_1351 * deltaToCamera.field_1351 + offsetTarget.field_1350 * deltaToCamera.field_1350;
                        for (t = 0; t < 32; ++t) {
                            x1 = 5.0f * distanceMultiplier * class_3532.method_15374((float)((float)((double)t * 3.141592653589793 * 2.0 / 32.0)));
                            x2 = 5.0f * distanceMultiplier * class_3532.method_15374((float)((float)((double)(t + 1) * 3.141592653589793 * 2.0 / 32.0)));
                            z1 = 5.0f * distanceMultiplier * class_3532.method_15362((float)((float)((double)t * 3.141592653589793 * 2.0 / 32.0)));
                            z2 = 5.0f * distanceMultiplier * class_3532.method_15362((float)((float)((double)(t + 1) * 3.141592653589793 * 2.0 / 32.0)));
                            length = (float)Math.sqrt((x2 - x1) * (x2 - x1) + (z2 - z1) * (z2 - z1));
                            if (!(clickAnyRot && !hoverRotX || this.yAxisRotationOnly)) {
                                vector1.set(0.0, (double)x1, (double)z1);
                                vector2.set(0.0, (double)x2, (double)z2);
                                if (this.localRotation != null) {
                                    this.localRotation.transform(vector1);
                                    this.localRotation.transform(vector2);
                                }
                                firstPointInside = clickAnyRot != false || (target.field_1352 + vector1.x) * deltaToCamera.field_1352 + (target.field_1351 + vector1.y) * deltaToCamera.field_1351 + (target.field_1350 + vector1.z) * deltaToCamera.field_1350 < planarK;
                                v12 = secondPointInside = clickAnyRot != false || (target.field_1352 + vector2.x) * deltaToCamera.field_1352 + (target.field_1351 + vector2.y) * deltaToCamera.field_1351 + (target.field_1350 + vector1.z) * deltaToCamera.field_1350 < planarK;
                                if (firstPointInside) {
                                    if (secondPointInside) {
                                        bufferBuilder.method_56824(pose, 0.0f, x1, z1).method_39415(colourRotX).method_60831(pose, 0.0f, (x2 - x1) / length, (z2 - z1) / length);
                                        bufferBuilder.method_56824(pose, 0.0f, x2, z2).method_39415(colourRotX).method_60831(pose, 0.0f, (x2 - x1) / length, (z2 - z1) / length);
                                    } else {
                                        intersected = Intersectiond.intersectLineSegmentPlane((double)(target.field_1352 + vector1.x), (double)(target.field_1351 + vector1.y), (double)(target.field_1350 + vector1.z), (double)(target.field_1352 + vector2.x), (double)(target.field_1351 + vector2.y), (double)(target.field_1350 + vector2.z), (double)deltaToCamera.field_1352, (double)deltaToCamera.field_1351, (double)deltaToCamera.field_1350, (double)(-planarK), (Vector3d)intersection);
                                        if (intersected) {
                                            intersection.sub(target.field_1352, target.field_1351, target.field_1350);
                                            if (this.localRotation != null) {
                                                this.localRotation.transformInverse(intersection);
                                            }
                                            intersectY = (float)intersection.y;
                                            intersectZ = (float)intersection.z;
                                            bufferBuilder.method_56824(pose, 0.0f, x1, z1).method_39415(colourRotX).method_60831(pose, 0.0f, (x2 - x1) / length, (z2 - z1) / length);
                                            bufferBuilder.method_56824(pose, 0.0f, intersectY, intersectZ).method_39415(colourRotX).method_60831(pose, 0.0f, (x2 - x1) / length, (z2 - z1) / length);
                                        }
                                    }
                                } else if (secondPointInside && (intersected = Intersectiond.intersectLineSegmentPlane((double)(target.field_1352 + vector1.x), (double)(target.field_1351 + vector1.y), (double)(target.field_1350 + vector1.z), (double)(target.field_1352 + vector2.x), (double)(target.field_1351 + vector2.y), (double)(target.field_1350 + vector2.z), (double)deltaToCamera.field_1352, (double)deltaToCamera.field_1351, (double)deltaToCamera.field_1350, (double)(-planarK), (Vector3d)intersection))) {
                                    intersection.sub(target.field_1352, target.field_1351, target.field_1350);
                                    if (this.localRotation != null) {
                                        this.localRotation.transformInverse(intersection);
                                    }
                                    intersectY = (float)intersection.y;
                                    intersectZ = (float)intersection.z;
                                    bufferBuilder.method_56824(pose, 0.0f, intersectY, intersectZ).method_39415(colourRotX).method_60831(pose, 0.0f, (x2 - x1) / length, (z2 - z1) / length);
                                    bufferBuilder.method_56824(pose, 0.0f, x2, z2).method_39415(colourRotX).method_60831(pose, 0.0f, (x2 - x1) / length, (z2 - z1) / length);
                                }
                            }
                            if (!clickAnyRot || hoverRotY) {
                                vector1.set((double)x1, 0.0, (double)z1);
                                vector2.set((double)x2, 0.0, (double)z2);
                                if (this.localRotation != null) {
                                    this.localRotation.transform(vector1);
                                    this.localRotation.transform(vector2);
                                }
                                firstPointInside = clickAnyRot != false || (target.field_1352 + vector1.x) * deltaToCamera.field_1352 + (target.field_1351 + vector1.y) * deltaToCamera.field_1351 + (target.field_1350 + vector1.z) * deltaToCamera.field_1350 < planarK;
                                v13 = secondPointInside = clickAnyRot != false || (target.field_1352 + vector2.x) * deltaToCamera.field_1352 + (target.field_1351 + vector2.y) * deltaToCamera.field_1351 + (target.field_1350 + vector1.z) * deltaToCamera.field_1350 < planarK;
                                if (firstPointInside) {
                                    if (secondPointInside) {
                                        bufferBuilder.method_56824(pose, x1, 0.0f, z1).method_39415(colourRotY).method_60831(pose, (x2 - x1) / length, 0.0f, (z2 - z1) / length);
                                        bufferBuilder.method_56824(pose, x2, 0.0f, z2).method_39415(colourRotY).method_60831(pose, (x2 - x1) / length, 0.0f, (z2 - z1) / length);
                                    } else {
                                        intersected = Intersectiond.intersectLineSegmentPlane((double)(target.field_1352 + vector1.x), (double)(target.field_1351 + vector1.y), (double)(target.field_1350 + vector1.z), (double)(target.field_1352 + vector2.x), (double)(target.field_1351 + vector2.y), (double)(target.field_1350 + vector2.z), (double)deltaToCamera.field_1352, (double)deltaToCamera.field_1351, (double)deltaToCamera.field_1350, (double)(-planarK), (Vector3d)intersection);
                                        if (intersected) {
                                            intersection.sub(target.field_1352, target.field_1351, target.field_1350);
                                            if (this.localRotation != null) {
                                                this.localRotation.transformInverse(intersection);
                                            }
                                            intersectX = (float)intersection.x;
                                            intersectZ = (float)intersection.z;
                                            bufferBuilder.method_56824(pose, x1, 0.0f, z1).method_39415(colourRotY).method_60831(pose, (x2 - x1) / length, 0.0f, (z2 - z1) / length);
                                            bufferBuilder.method_56824(pose, intersectX, 0.0f, intersectZ).method_39415(colourRotY).method_60831(pose, (x2 - x1) / length, 0.0f, (z2 - z1) / length);
                                        }
                                    }
                                } else if (secondPointInside && (intersected = Intersectiond.intersectLineSegmentPlane((double)(target.field_1352 + vector1.x), (double)(target.field_1351 + vector1.y), (double)(target.field_1350 + vector1.z), (double)(target.field_1352 + vector2.x), (double)(target.field_1351 + vector2.y), (double)(target.field_1350 + vector2.z), (double)deltaToCamera.field_1352, (double)deltaToCamera.field_1351, (double)deltaToCamera.field_1350, (double)(-planarK), (Vector3d)intersection))) {
                                    intersection.sub(target.field_1352, target.field_1351, target.field_1350);
                                    if (this.localRotation != null) {
                                        this.localRotation.transformInverse(intersection);
                                    }
                                    intersectX = (float)intersection.x;
                                    intersectZ = (float)intersection.z;
                                    bufferBuilder.method_56824(pose, intersectX, 0.0f, intersectZ).method_39415(colourRotY).method_60831(pose, (x2 - x1) / length, 0.0f, (z2 - z1) / length);
                                    bufferBuilder.method_56824(pose, x2, 0.0f, z2).method_39415(colourRotY).method_60831(pose, (x2 - x1) / length, 0.0f, (z2 - z1) / length);
                                }
                            }
                            if (clickAnyRot && !hoverRotZ || this.yAxisRotationOnly) continue;
                            vector1.set((double)x1, (double)z1, 0.0);
                            vector2.set((double)x2, (double)z2, 0.0);
                            if (this.localRotation != null) {
                                this.localRotation.transform(vector1);
                                this.localRotation.transform(vector2);
                            }
                            firstPointInside = clickAnyRot != false || (target.field_1352 + vector1.x) * deltaToCamera.field_1352 + (target.field_1351 + vector1.y) * deltaToCamera.field_1351 + (target.field_1350 + vector1.z) * deltaToCamera.field_1350 < planarK;
                            v14 = secondPointInside = clickAnyRot != false || (target.field_1352 + vector2.x) * deltaToCamera.field_1352 + (target.field_1351 + vector2.y) * deltaToCamera.field_1351 + (target.field_1350 + vector1.z) * deltaToCamera.field_1350 < planarK;
                            if (firstPointInside) {
                                if (secondPointInside) {
                                    bufferBuilder.method_56824(pose, x1, z1, 0.0f).method_39415(colourRotZ).method_60831(pose, (x2 - x1) / length, (z2 - z1) / length, 0.0f);
                                    bufferBuilder.method_56824(pose, x2, z2, 0.0f).method_39415(colourRotZ).method_60831(pose, (x2 - x1) / length, (z2 - z1) / length, 0.0f);
                                    continue;
                                }
                                intersected = Intersectiond.intersectLineSegmentPlane((double)(target.field_1352 + vector1.x), (double)(target.field_1351 + vector1.y), (double)(target.field_1350 + vector1.z), (double)(target.field_1352 + vector2.x), (double)(target.field_1351 + vector2.y), (double)(target.field_1350 + vector2.z), (double)deltaToCamera.field_1352, (double)deltaToCamera.field_1351, (double)deltaToCamera.field_1350, (double)(-planarK), (Vector3d)intersection);
                                if (!intersected) continue;
                                intersection.sub(target.field_1352, target.field_1351, target.field_1350);
                                if (this.localRotation != null) {
                                    this.localRotation.transformInverse(intersection);
                                }
                                intersectX = (float)intersection.x;
                                intersectY = (float)intersection.y;
                                bufferBuilder.method_56824(pose, x1, z1, 0.0f).method_39415(colourRotZ).method_60831(pose, (x2 - x1) / length, (z2 - z1) / length, 0.0f);
                                bufferBuilder.method_56824(pose, intersectX, intersectY, 0.0f).method_39415(colourRotZ).method_60831(pose, (x2 - x1) / length, (z2 - z1) / length, 0.0f);
                                continue;
                            }
                            if (!secondPointInside || !(intersected = Intersectiond.intersectLineSegmentPlane((double)(target.field_1352 + vector1.x), (double)(target.field_1351 + vector1.y), (double)(target.field_1350 + vector1.z), (double)(target.field_1352 + vector2.x), (double)(target.field_1351 + vector2.y), (double)(target.field_1350 + vector2.z), (double)deltaToCamera.field_1352, (double)deltaToCamera.field_1351, (double)deltaToCamera.field_1350, (double)(-planarK), (Vector3d)intersection))) continue;
                            intersection.sub(target.field_1352, target.field_1351, target.field_1350);
                            if (this.localRotation != null) {
                                this.localRotation.transformInverse(intersection);
                            }
                            intersectX = (float)intersection.x;
                            intersectY = (float)intersection.y;
                            bufferBuilder.method_56824(pose, intersectX, intersectY, 0.0f).method_39415(colourRotZ).method_60831(pose, (x2 - x1) / length, (z2 - z1) / length, 0.0f);
                            bufferBuilder.method_56824(pose, x2, z2, 0.0f).method_39415(colourRotZ).method_60831(pose, (x2 - x1) / length, (z2 - z1) / length, 0.0f);
                        }
                        AxiomRenderPipelines.GIZMO_LINES.render(provider.build());
                    }
                    if (this.enableRotation && clickAnyRot && this.rotation != null) {
                        rotate = (GizmoTarget.Rotate)this.clickedTarget;
                        bufferBuilder = provider.begin(VertexFormat.class_5596.field_27381, class_290.field_1576);
                        bufferBuilder.method_56824(pose, 0.0f, 0.0f, 0.0f).method_39415(0);
                        tau = 6.2831855f;
                        start = rotate.startAngle;
                        end = rotate.startAngle + this.rotation.radians;
                        if (end < start) {
                            temp = start;
                            start = end;
                            end = temp;
                        }
                        divisions = Math.max(32, (int)(tau / this.rotationSnapRadians));
                        endT = Math.round(end / tau * (float)divisions);
                        for (t = Math.round(start / tau * (float)divisions); t < endT; ++t) {
                            x1 = 5.0f * distanceMultiplier * class_3532.method_15374((float)((float)((double)t * 3.141592653589793 * 2.0 / (double)divisions)));
                            x2 = 5.0f * distanceMultiplier * class_3532.method_15374((float)((float)((double)(t + 1) * 3.141592653589793 * 2.0 / (double)divisions)));
                            z1 = 5.0f * distanceMultiplier * class_3532.method_15362((float)((float)((double)t * 3.141592653589793 * 2.0 / (double)divisions)));
                            z2 = 5.0f * distanceMultiplier * class_3532.method_15362((float)((float)((double)(t + 1) * 3.141592653589793 * 2.0 / (double)divisions)));
                            if (hoverRotX) {
                                bufferBuilder.method_56824(pose, 0.0f, z1, x1).method_39415(colourRotX);
                                bufferBuilder.method_56824(pose, 0.0f, z2, x2).method_39415(colourRotX);
                                continue;
                            }
                            if (hoverRotY) {
                                bufferBuilder.method_56824(pose, x1, 0.0f, z1).method_39415(colourRotY);
                                bufferBuilder.method_56824(pose, x2, 0.0f, z2).method_39415(colourRotY);
                                continue;
                            }
                            if (!hoverRotZ) continue;
                            bufferBuilder.method_56824(pose, z1, x1, 0.0f).method_39415(colourRotZ);
                            bufferBuilder.method_56824(pose, z2, x2, 0.0f).method_39415(colourRotZ);
                        }
                        AxiomRenderPipelines.GIZMO_POSITION_COLOR.render(provider.build());
                    }
                    if (clickAny2D || !clickedAny) {
                        bufferBuilder = provider.begin(VertexFormat.class_5596.field_27382, class_290.field_1576);
                        bufferBuilder.method_56824(pose, 0.0f, (float)mY * boxSize * 5.5f, (float)mZ * boxSize * 5.5f).method_39415(colour2DX);
                        bufferBuilder.method_56824(pose, 0.0f, (float)mY * boxSize * 5.5f, (float)mZ * boxSize * 8.5f).method_39415(colour2DX);
                        bufferBuilder.method_56824(pose, 0.0f, (float)mY * boxSize * 8.5f, (float)mZ * boxSize * 8.5f).method_39415(colour2DX);
                        bufferBuilder.method_56824(pose, 0.0f, (float)mY * boxSize * 8.5f, (float)mZ * boxSize * 5.5f).method_39415(colour2DX);
                        bufferBuilder.method_56824(pose, (float)mX * boxSize * 5.5f, 0.0f, (float)mZ * boxSize * 5.5f).method_39415(colour2DY);
                        bufferBuilder.method_56824(pose, (float)mX * boxSize * 5.5f, 0.0f, (float)mZ * boxSize * 8.5f).method_39415(colour2DY);
                        bufferBuilder.method_56824(pose, (float)mX * boxSize * 8.5f, 0.0f, (float)mZ * boxSize * 8.5f).method_39415(colour2DY);
                        bufferBuilder.method_56824(pose, (float)mX * boxSize * 8.5f, 0.0f, (float)mZ * boxSize * 5.5f).method_39415(colour2DY);
                        bufferBuilder.method_56824(pose, (float)mX * boxSize * 5.5f, (float)mY * boxSize * 5.5f, 0.0f).method_39415(colour2DZ);
                        bufferBuilder.method_56824(pose, (float)mX * boxSize * 5.5f, (float)mY * boxSize * 8.5f, 0.0f).method_39415(colour2DZ);
                        bufferBuilder.method_56824(pose, (float)mX * boxSize * 8.5f, (float)mY * boxSize * 8.5f, 0.0f).method_39415(colour2DZ);
                        bufferBuilder.method_56824(pose, (float)mX * boxSize * 8.5f, (float)mY * boxSize * 5.5f, 0.0f).method_39415(colour2DZ);
                        AxiomRenderPipelines.GIZMO_POSITION_COLOR.render(provider.build());
                    }
                    clickAnyScale = this.clickedTarget instanceof GizmoTarget.Scale1D;
                    if (!this.enableScale || !clickAnyScale && clickedAny) break block79;
                    tau = this.clickedTarget;
                    if (tau instanceof GizmoTarget.Scale1D) {
                        scale1D = (GizmoTarget.Scale1D)tau;
                        if (this.scale != null) {
                            bufferBuilder = provider.begin(VertexFormat.class_5596.field_27377, class_290.field_29337);
                            RenderSystem.lineWidth((float)3.0f);
                            end = (axisLen + coneLen + axisLen / 5.0f) * this.scale.scale - boxSize;
                            if (pressedCtrl) {
                                bufferBuilder.method_56824(pose, (float)mX * boxSize, 0.0f, 0.0f).method_39415(colourAxisX).method_60831(pose, 1.0f, 0.0f, 0.0f);
                                bufferBuilder.method_56824(pose, (float)mX * end, 0.0f, 0.0f).method_39415(colourAxisX).method_60831(pose, 1.0f, 0.0f, 0.0f);
                                bufferBuilder.method_56824(pose, 0.0f, (float)mY * boxSize, 0.0f).method_39415(colourAxisY).method_60831(pose, 0.0f, 1.0f, 0.0f);
                                bufferBuilder.method_56824(pose, 0.0f, (float)mY * end, 0.0f).method_39415(colourAxisY).method_60831(pose, 0.0f, 1.0f, 0.0f);
                                bufferBuilder.method_56824(pose, 0.0f, 0.0f, (float)mZ * boxSize).method_39415(colourAxisZ).method_60831(pose, 0.0f, 0.0f, 1.0f);
                                bufferBuilder.method_56824(pose, 0.0f, 0.0f, (float)mZ * end).method_39415(colourAxisZ).method_60831(pose, 0.0f, 0.0f, 1.0f);
                            } else {
                                switch (1.$SwitchMap$net$minecraft$core$Direction$Axis[scale1D.clickedAxis.ordinal()]) {
                                    case 1: {
                                        bufferBuilder.method_56824(pose, (float)mX * boxSize, 0.0f, 0.0f).method_39415(colourAxisX).method_60831(pose, 1.0f, 0.0f, 0.0f);
                                        bufferBuilder.method_56824(pose, (float)mX * end, 0.0f, 0.0f).method_39415(colourAxisX).method_60831(pose, 1.0f, 0.0f, 0.0f);
                                        break;
                                    }
                                    case 2: {
                                        bufferBuilder.method_56824(pose, 0.0f, (float)mY * boxSize, 0.0f).method_39415(colourAxisY).method_60831(pose, 0.0f, 1.0f, 0.0f);
                                        bufferBuilder.method_56824(pose, 0.0f, (float)mY * end, 0.0f).method_39415(colourAxisY).method_60831(pose, 0.0f, 1.0f, 0.0f);
                                        break;
                                    }
                                    case 3: {
                                        bufferBuilder.method_56824(pose, 0.0f, 0.0f, (float)mZ * boxSize).method_39415(colourAxisZ).method_60831(pose, 0.0f, 0.0f, 1.0f);
                                        bufferBuilder.method_56824(pose, 0.0f, 0.0f, (float)mZ * end).method_39415(colourAxisZ).method_60831(pose, 0.0f, 0.0f, 1.0f);
                                    }
                                }
                            }
                            AxiomRenderPipelines.GIZMO_LINES.render(provider.build());
                        }
                    }
                    bufferBuilder = provider.begin(VertexFormat.class_5596.field_27379, class_290.field_1576);
                    end = this.clickedTarget;
                    if (!(end instanceof GizmoTarget.Scale1D)) break block83;
                    scale1D = (GizmoTarget.Scale1D)end;
                    if (this.scale == null) break block83;
                    x = pressedCtrl != false || scale1D.clickedAxis == class_2350.class_2351.field_11048;
                    y = pressedCtrl != false || scale1D.clickedAxis == class_2350.class_2351.field_11052;
                    v15 = z = pressedCtrl != false || scale1D.clickedAxis == class_2350.class_2351.field_11051;
                    if (x) {
                        matrices.method_22903();
                        matrices.method_46416((float)mX * (axisLen + coneLen + axisLen / 5.0f) * this.scale.scale, 0.0f, 0.0f);
                        Gizmo.drawBox(bufferBuilder, matrices.method_23760().method_23761(), boxSize, -65536);
                        matrices.method_22909();
                    }
                    if (y) {
                        matrices.method_22903();
                        matrices.method_46416(0.0f, (float)mY * (axisLen + coneLen + axisLen / 5.0f) * this.scale.scale, 0.0f);
                        Gizmo.drawBox(bufferBuilder, matrices.method_23760().method_23761(), boxSize, -16711936);
                        matrices.method_22909();
                    }
                    if (z) {
                        matrices.method_22903();
                        matrices.method_46416(0.0f, 0.0f, (float)mZ * (axisLen + coneLen + axisLen / 5.0f) * this.scale.scale);
                        Gizmo.drawBox(bufferBuilder, matrices.method_23760().method_23761(), boxSize, -16776961);
                        matrices.method_22909();
                    }
                    break block84;
                }
                if (!((z = this.hoveredTarget) instanceof GizmoTarget.Scale1D)) ** GOTO lbl-1000
                scale1D = (GizmoTarget.Scale1D)z;
                if (scale1D.clickedAxis == class_2350.class_2351.field_11048) {
                    v16 = -65536;
                } else lbl-1000:
                // 2 sources

                {
                    v16 = -2130771968;
                }
                colourX = v16;
                endT = this.hoveredTarget;
                if (!(endT instanceof GizmoTarget.Scale1D)) ** GOTO lbl-1000
                scale1D = (GizmoTarget.Scale1D)endT;
                if (scale1D.clickedAxis == class_2350.class_2351.field_11052) {
                    v17 = -16711936;
                } else lbl-1000:
                // 2 sources

                {
                    v17 = -2147418368;
                }
                colourY = v17;
                var52_85 = this.hoveredTarget;
                if (!(var52_85 instanceof GizmoTarget.Scale1D)) ** GOTO lbl-1000
                scale1D = (GizmoTarget.Scale1D)var52_85;
                if (scale1D.clickedAxis == class_2350.class_2351.field_11051) {
                    v18 = -16776961;
                } else lbl-1000:
                // 2 sources

                {
                    v18 = -2147483393;
                }
                colourZ = v18;
                matrices.method_22903();
                matrices.method_46416((float)mX * (axisLen + coneLen + axisLen / 5.0f), 0.0f, 0.0f);
                Gizmo.drawBox(bufferBuilder, matrices.method_23760().method_23761(), boxSize, colourX);
                matrices.method_22909();
                matrices.method_22903();
                matrices.method_46416(0.0f, (float)mY * (axisLen + coneLen + axisLen / 5.0f), 0.0f);
                Gizmo.drawBox(bufferBuilder, matrices.method_23760().method_23761(), boxSize, colourY);
                matrices.method_22909();
                matrices.method_22903();
                matrices.method_46416(0.0f, 0.0f, (float)mZ * (axisLen + coneLen + axisLen / 5.0f));
                Gizmo.drawBox(bufferBuilder, matrices.method_23760().method_23761(), boxSize, colourZ);
                matrices.method_22909();
            }
            meshData = bufferBuilder.method_60794();
            if (meshData != null) {
                AxiomRenderPipelines.GIZMO_POSITION_COLOR_WITH_BLENDING.render(meshData);
            }
        }
        bufferBuilder = provider.begin(VertexFormat.class_5596.field_27379, class_290.field_1576);
        Gizmo.drawBox(bufferBuilder, matrices.method_23760().method_23761(), boxSize, this.hoveredTarget instanceof GizmoTarget.Move3D != false ? -16777216 | this.centerColour : -2147483648 | this.centerColour);
        meshData = bufferBuilder.method_60794();
        if (meshData != null) {
            AxiomRenderPipelines.GIZMO_POSITION_COLOR_WITH_BLENDING.render(meshData);
        }
    }

    private GizmoTarget calculateAxisTarget(class_243 lookDirection) {
        int mZ;
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return null;
        }
        class_243 targetPositionD = this.targetPositionVec.method_1019(this.offsetFromBlockPos);
        float distanceMultiplier = this.getDistanceMultiplier(player.method_33571());
        float axisLen = 4.0f * distanceMultiplier;
        float boxSize = 0.32f * distanceMultiplier;
        class_243 b1 = targetPositionD.method_1031((double)(-boxSize), (double)(-boxSize), (double)(-boxSize));
        class_243 b2 = targetPositionD.method_1031((double)boxSize, (double)boxSize, (double)boxSize);
        class_243 l1 = player.method_33571();
        class_243 l2 = l1.method_1019(lookDirection.method_1021(2000.0));
        Vector3d r1 = new Vector3d(l1.field_1352 - targetPositionD.field_1352, l1.field_1351 - targetPositionD.field_1351, l1.field_1350 - targetPositionD.field_1350);
        if (this.localRotation != null) {
            this.localRotation.transformInverse(r1);
        }
        r1.add(targetPositionD.field_1352, targetPositionD.field_1351, targetPositionD.field_1350);
        Vector3d r2 = new Vector3d(l2.field_1352 - targetPositionD.field_1352, l2.field_1351 - targetPositionD.field_1351, l2.field_1350 - targetPositionD.field_1350);
        if (this.localRotation != null) {
            this.localRotation.transformInverse(r2);
        }
        r2.add(targetPositionD.field_1352, targetPositionD.field_1351, targetPositionD.field_1350);
        int mX = this.plusX ? 1 : -1;
        int mY = this.plusY ? 1 : -1;
        int n = mZ = this.plusZ ? 1 : -1;
        if (Intersectiond.intersectLineSegmentAab((double)r1.x, (double)r1.y, (double)r1.z, (double)r2.x, (double)r2.y, (double)r2.z, (double)b1.field_1352, (double)b1.field_1351, (double)b1.field_1350, (double)b2.field_1352, (double)b2.field_1351, (double)b2.field_1350, (Vector2d)new Vector2d()) != -1) {
            float distance = (float)Math.sqrt(player.method_5707(targetPositionD.method_1031(0.0, (double)(-player.method_5751()), 0.0)));
            return new GizmoTarget.Move3D(distance);
        }
        if (this.enableAxes) {
            if (this.enableScale) {
                class_2350.class_2351 axis = null;
                float offset = axisLen + 2.0f * axisLen / 5.0f;
                if (Intersectiond.intersectLineSegmentAab((double)r1.x, (double)r1.y, (double)r1.z, (double)r2.x, (double)r2.y, (double)r2.z, (double)(b1.field_1352 + (double)((float)mX * offset)), (double)b1.field_1351, (double)b1.field_1350, (double)(b2.field_1352 + (double)((float)mX * offset)), (double)b2.field_1351, (double)b2.field_1350, (Vector2d)new Vector2d()) != -1) {
                    axis = class_2350.class_2351.field_11048;
                } else if (Intersectiond.intersectLineSegmentAab((double)r1.x, (double)r1.y, (double)r1.z, (double)r2.x, (double)r2.y, (double)r2.z, (double)b1.field_1352, (double)(b1.field_1351 + (double)((float)mY * offset)), (double)b1.field_1350, (double)b2.field_1352, (double)(b2.field_1351 + (double)((float)mY * offset)), (double)b2.field_1350, (Vector2d)new Vector2d()) != -1) {
                    axis = class_2350.class_2351.field_11052;
                } else if (Intersectiond.intersectLineSegmentAab((double)r1.x, (double)r1.y, (double)r1.z, (double)r2.x, (double)r2.y, (double)r2.z, (double)b1.field_1352, (double)b1.field_1351, (double)(b1.field_1350 + (double)((float)mZ * offset)), (double)b2.field_1352, (double)b2.field_1351, (double)(b2.field_1350 + (double)((float)mZ * offset)), (Vector2d)new Vector2d()) != -1) {
                    axis = class_2350.class_2351.field_11051;
                }
                if (axis != null) {
                    Vector3f vector3f = new Vector3f((float)axis.method_10173(1, 0, 0), (float)axis.method_10173(0, 1, 0), (float)axis.method_10173(0, 0, 1));
                    if (this.localRotation != null) {
                        this.localRotation.transform(vector3f);
                    }
                    Vector3d intersection = new Vector3d();
                    Intersectiond.findClosestPointsLineSegments((double)(targetPositionD.field_1352 - (double)(vector3f.x * 500.0f)), (double)(targetPositionD.field_1351 - (double)(vector3f.y * 500.0f)), (double)(targetPositionD.field_1350 - (double)(vector3f.z * 500.0f)), (double)(targetPositionD.field_1352 + (double)(vector3f.x * 500.0f)), (double)(targetPositionD.field_1351 + (double)(vector3f.y * 500.0f)), (double)(targetPositionD.field_1350 + (double)(vector3f.z * 500.0f)), (double)l1.field_1352, (double)l1.field_1351, (double)l1.field_1350, (double)l2.field_1352, (double)l2.field_1351, (double)l2.field_1350, (Vector3d)intersection, (Vector3d)new Vector3d());
                    double distanceToCenter = intersection.distance(targetPositionD.field_1352, targetPositionD.field_1351, targetPositionD.field_1350);
                    return new GizmoTarget.Scale1D(new class_243(vector3f), (float)distanceToCenter, axis);
                }
            }
            float mX1 = this.plusX ? 5.5f : -8.5f;
            float mY1 = this.plusY ? 5.5f : -8.5f;
            float mZ1 = this.plusZ ? 5.5f : -8.5f;
            float mX2 = this.plusX ? 8.5f : -5.5f;
            float mY2 = this.plusY ? 8.5f : -5.5f;
            float mZ2 = this.plusZ ? 8.5f : -5.5f;
            b1 = targetPositionD.method_1031(0.0, (double)(mY1 * boxSize), (double)(mZ1 * boxSize));
            b2 = targetPositionD.method_1031(0.0, (double)(mY2 * boxSize), (double)(mZ2 * boxSize));
            Vector2d result = new Vector2d();
            if (Intersectiond.intersectLineSegmentAab((double)r1.x, (double)r1.y, (double)r1.z, (double)r2.x, (double)r2.y, (double)r2.z, (double)b1.field_1352, (double)b1.field_1351, (double)b1.field_1350, (double)b2.field_1352, (double)b2.field_1351, (double)b2.field_1350, (Vector2d)result) != -1) {
                class_243 origin = l1.method_1019(l2.method_1020(l1).method_18805(result.x, result.x, result.x)).method_1020(targetPositionD);
                return new GizmoTarget.Move2D(origin, class_2350.class_2351.field_11048);
            }
            b1 = targetPositionD.method_1031((double)(mX1 * boxSize), 0.0, (double)(mZ1 * boxSize));
            b2 = targetPositionD.method_1031((double)(mX2 * boxSize), 0.0, (double)(mZ2 * boxSize));
            if (Intersectiond.intersectLineSegmentAab((double)r1.x, (double)r1.y, (double)r1.z, (double)r2.x, (double)r2.y, (double)r2.z, (double)b1.field_1352, (double)b1.field_1351, (double)b1.field_1350, (double)b2.field_1352, (double)b2.field_1351, (double)b2.field_1350, (Vector2d)result) != -1) {
                class_243 origin = l1.method_1019(l2.method_1020(l1).method_18805(result.x, result.x, result.x)).method_1020(targetPositionD);
                return new GizmoTarget.Move2D(origin, class_2350.class_2351.field_11052);
            }
            b1 = targetPositionD.method_1031((double)(mX1 * boxSize), (double)(mY1 * boxSize), 0.0);
            b2 = targetPositionD.method_1031((double)(mX2 * boxSize), (double)(mY2 * boxSize), 0.0);
            if (Intersectiond.intersectLineSegmentAab((double)r1.x, (double)r1.y, (double)r1.z, (double)r2.x, (double)r2.y, (double)r2.z, (double)b1.field_1352, (double)b1.field_1351, (double)b1.field_1350, (double)b2.field_1352, (double)b2.field_1351, (double)b2.field_1350, (Vector2d)result) != -1) {
                class_243 origin = l1.method_1019(l2.method_1020(l1).method_18805(result.x, result.x, result.x)).method_1020(targetPositionD);
                return new GizmoTarget.Move2D(origin, class_2350.class_2351.field_11051);
            }
            float closestDot = 0.0f;
            Vector3d closestIntersectionDir = null;
            Vector3d xIntersection = new Vector3d();
            Vector3d yIntersection = new Vector3d();
            Vector3d zIntersection = new Vector3d();
            int intersectionId = -1;
            Vector3d intersection = null;
            class_2350.class_2351 clickedAxis = null;
            Vector3d vector = new Vector3d((double)((this.plusX ? 1.3f : -1.3f) * axisLen), 0.0, 0.0);
            if (this.localRotation != null) {
                this.localRotation.transform(vector);
            }
            Intersectiond.findClosestPointsLineSegments((double)targetPositionD.field_1352, (double)targetPositionD.field_1351, (double)targetPositionD.field_1350, (double)(targetPositionD.field_1352 + vector.x), (double)(targetPositionD.field_1351 + vector.y), (double)(targetPositionD.field_1350 + vector.z), (double)l1.field_1352, (double)l1.field_1351, (double)l1.field_1350, (double)l2.field_1352, (double)l2.field_1351, (double)l2.field_1350, (Vector3d)xIntersection, (Vector3d)new Vector3d());
            Vector3d xIntersectionDir = xIntersection.sub(l1.field_1352, l1.field_1351, l1.field_1350, new Vector3d()).normalize();
            float dotX = (float)xIntersectionDir.dot(lookDirection.field_1352, lookDirection.field_1351, lookDirection.field_1350);
            if (dotX >= SELECT_THRESHOLD) {
                intersection = new Vector3d((Vector3dc)xIntersection);
                closestIntersectionDir = xIntersectionDir;
                closestDot = dotX;
                intersectionId = 0;
                clickedAxis = class_2350.class_2351.field_11048;
            }
            vector.set(0.0, (double)((this.plusY ? 1.3f : -1.3f) * axisLen), 0.0);
            if (this.localRotation != null) {
                this.localRotation.transform(vector);
            }
            Intersectiond.findClosestPointsLineSegments((double)targetPositionD.field_1352, (double)targetPositionD.field_1351, (double)targetPositionD.field_1350, (double)(targetPositionD.field_1352 + vector.x), (double)(targetPositionD.field_1351 + vector.y), (double)(targetPositionD.field_1350 + vector.z), (double)l1.field_1352, (double)l1.field_1351, (double)l1.field_1350, (double)l2.field_1352, (double)l2.field_1351, (double)l2.field_1350, (Vector3d)yIntersection, (Vector3d)new Vector3d());
            Vector3d yIntersectionDir = yIntersection.sub(l1.field_1352, l1.field_1351, l1.field_1350, new Vector3d()).normalize();
            float dotY = (float)yIntersectionDir.dot(lookDirection.field_1352, lookDirection.field_1351, lookDirection.field_1350);
            if (this.shouldSelectHandle(closestIntersectionDir, intersection, closestDot, yIntersectionDir, yIntersection, dotY, l1)) {
                intersection = new Vector3d((Vector3dc)yIntersection);
                closestIntersectionDir = yIntersectionDir;
                closestDot = dotY;
                intersectionId = 0;
                clickedAxis = class_2350.class_2351.field_11052;
            }
            vector.set(0.0, 0.0, (double)((this.plusZ ? 1.3f : -1.3f) * axisLen));
            if (this.localRotation != null) {
                this.localRotation.transform(vector);
            }
            Intersectiond.findClosestPointsLineSegments((double)targetPositionD.field_1352, (double)targetPositionD.field_1351, (double)targetPositionD.field_1350, (double)(targetPositionD.field_1352 + vector.x), (double)(targetPositionD.field_1351 + vector.y), (double)(targetPositionD.field_1350 + vector.z), (double)l1.field_1352, (double)l1.field_1351, (double)l1.field_1350, (double)l2.field_1352, (double)l2.field_1351, (double)l2.field_1350, (Vector3d)zIntersection, (Vector3d)new Vector3d());
            Vector3d zIntersectionDir = zIntersection.sub(l1.field_1352, l1.field_1351, l1.field_1350, new Vector3d()).normalize();
            float dotZ = (float)zIntersectionDir.dot(lookDirection.field_1352, lookDirection.field_1351, lookDirection.field_1350);
            if (this.shouldSelectHandle(closestIntersectionDir, intersection, closestDot, zIntersectionDir, zIntersection, dotZ, l1)) {
                intersection = new Vector3d((Vector3dc)zIntersection);
                closestIntersectionDir = zIntersectionDir;
                closestDot = dotZ;
                intersectionId = 0;
                clickedAxis = class_2350.class_2351.field_11051;
            }
            if (this.enableRotation) {
                float dot;
                double xIntersectionMin = Double.MAX_VALUE;
                double yIntersectionMin = Double.MAX_VALUE;
                double zIntersectionMin = Double.MAX_VALUE;
                Vector3d xIntersectionNew = new Vector3d();
                Vector3d yIntersectionNew = new Vector3d();
                Vector3d zIntersectionNew = new Vector3d();
                Vector3d vector1 = new Vector3d();
                Vector3d vector2 = new Vector3d();
                class_243 cameraPosition = class_310.method_1551().field_1719.method_33571();
                class_243 target = this.targetPositionVec;
                class_243 deltaToCamera = target.method_1020(cameraPosition);
                class_243 offsetTarget = target.method_1019(deltaToCamera.method_1021(0.05));
                deltaToCamera = deltaToCamera.method_1029();
                double planarK = offsetTarget.field_1352 * deltaToCamera.field_1352 + offsetTarget.field_1351 * deltaToCamera.field_1351 + offsetTarget.field_1350 * deltaToCamera.field_1350;
                for (int t2 = 0; t2 < 32; ++t2) {
                    float x1 = 5.0f * distanceMultiplier * class_3532.method_15374((float)((float)((double)t2 * Math.PI * 2.0 / 32.0)));
                    float x2 = 5.0f * distanceMultiplier * class_3532.method_15374((float)((float)((double)(t2 + 1) * Math.PI * 2.0 / 32.0)));
                    float z1 = 5.0f * distanceMultiplier * class_3532.method_15362((float)((float)((double)t2 * Math.PI * 2.0 / 32.0)));
                    float z2 = 5.0f * distanceMultiplier * class_3532.method_15362((float)((float)((double)(t2 + 1) * Math.PI * 2.0 / 32.0)));
                    if (!this.yAxisRotationOnly) {
                        vector1.set(0.0, (double)x1, (double)z1);
                        vector2.set(0.0, (double)x2, (double)z2);
                        if (this.localRotation != null) {
                            this.localRotation.transform(vector1);
                            this.localRotation.transform(vector2);
                        }
                        double xIntersectionDist = Intersectiond.findClosestPointsLineSegments((double)(targetPositionD.field_1352 + vector1.x), (double)(targetPositionD.field_1351 + vector1.y), (double)(targetPositionD.field_1350 + vector1.z), (double)(targetPositionD.field_1352 + vector2.x), (double)(targetPositionD.field_1351 + vector2.y), (double)(targetPositionD.field_1350 + vector2.z), (double)l1.field_1352, (double)l1.field_1351, (double)l1.field_1350, (double)l2.field_1352, (double)l2.field_1351, (double)l2.field_1350, (Vector3d)xIntersectionNew, (Vector3d)new Vector3d());
                        if (xIntersectionNew.x * deltaToCamera.field_1352 + xIntersectionNew.y * deltaToCamera.field_1351 + xIntersectionNew.z * deltaToCamera.field_1350 < planarK && xIntersectionDist < xIntersectionMin) {
                            xIntersectionMin = xIntersectionDist;
                            xIntersection = new Vector3d((Vector3dc)xIntersectionNew);
                        }
                    }
                    vector1.set((double)x1, 0.0, (double)z1);
                    vector2.set((double)x2, 0.0, (double)z2);
                    if (this.localRotation != null) {
                        this.localRotation.transform(vector1);
                        this.localRotation.transform(vector2);
                    }
                    double yIntersectionDist = Intersectiond.findClosestPointsLineSegments((double)(targetPositionD.field_1352 + vector1.x), (double)(targetPositionD.field_1351 + vector1.y), (double)(targetPositionD.field_1350 + vector1.z), (double)(targetPositionD.field_1352 + vector2.x), (double)(targetPositionD.field_1351 + vector2.y), (double)(targetPositionD.field_1350 + vector2.z), (double)l1.field_1352, (double)l1.field_1351, (double)l1.field_1350, (double)l2.field_1352, (double)l2.field_1351, (double)l2.field_1350, (Vector3d)yIntersectionNew, (Vector3d)new Vector3d());
                    if (yIntersectionNew.x * deltaToCamera.field_1352 + yIntersectionNew.y * deltaToCamera.field_1351 + yIntersectionNew.z * deltaToCamera.field_1350 < planarK && yIntersectionDist < yIntersectionMin) {
                        yIntersectionMin = yIntersectionDist;
                        yIntersection = new Vector3d((Vector3dc)yIntersectionNew);
                    }
                    if (this.yAxisRotationOnly) continue;
                    vector1.set((double)x1, (double)z1, 0.0);
                    vector2.set((double)x2, (double)z2, 0.0);
                    if (this.localRotation != null) {
                        this.localRotation.transform(vector1);
                        this.localRotation.transform(vector2);
                    }
                    double zIntersectionDist = Intersectiond.findClosestPointsLineSegments((double)(targetPositionD.field_1352 + vector1.x), (double)(targetPositionD.field_1351 + vector1.y), (double)(targetPositionD.field_1350 + vector1.z), (double)(targetPositionD.field_1352 + vector2.x), (double)(targetPositionD.field_1351 + vector2.y), (double)(targetPositionD.field_1350 + vector2.z), (double)l1.field_1352, (double)l1.field_1351, (double)l1.field_1350, (double)l2.field_1352, (double)l2.field_1351, (double)l2.field_1350, (Vector3d)zIntersectionNew, (Vector3d)new Vector3d());
                    if (!(zIntersectionNew.x * deltaToCamera.field_1352 + zIntersectionNew.y * deltaToCamera.field_1351 + zIntersectionNew.z * deltaToCamera.field_1350 < planarK) || !(zIntersectionDist < zIntersectionMin)) continue;
                    zIntersectionMin = zIntersectionDist;
                    zIntersection = new Vector3d((Vector3dc)zIntersectionNew);
                }
                Vector3d toIntersection = xIntersection.sub(l1.field_1352, l1.field_1351, l1.field_1350, new Vector3d()).normalize();
                if (this.shouldSelectHandle(closestIntersectionDir, intersection, closestDot, toIntersection, xIntersection, dot = (float)toIntersection.dot(lookDirection.field_1352, lookDirection.field_1351, lookDirection.field_1350), l1)) {
                    intersection = xIntersection;
                    closestIntersectionDir = toIntersection;
                    closestDot = dot;
                    intersectionId = 1;
                }
                if (this.shouldSelectHandle(closestIntersectionDir, intersection, closestDot, toIntersection = yIntersection.sub(l1.field_1352, l1.field_1351, l1.field_1350, new Vector3d()).normalize(), yIntersection, dot = (float)toIntersection.dot(lookDirection.field_1352, lookDirection.field_1351, lookDirection.field_1350), l1)) {
                    intersection = yIntersection;
                    closestIntersectionDir = toIntersection;
                    closestDot = dot;
                    intersectionId = 2;
                }
                if (this.shouldSelectHandle(closestIntersectionDir, intersection, closestDot, toIntersection = zIntersection.sub(l1.field_1352, l1.field_1351, l1.field_1350, new Vector3d()).normalize(), zIntersection, dot = (float)toIntersection.dot(lookDirection.field_1352, lookDirection.field_1351, lookDirection.field_1350), l1)) {
                    intersection = zIntersection;
                    closestIntersectionDir = toIntersection;
                    closestDot = dot;
                    intersectionId = 3;
                }
            }
            if (intersection != null) {
                if (intersectionId == 0) {
                    return new GizmoTarget.Move1D(new class_243(intersection.x, intersection.y, intersection.z).method_1020(targetPositionD), this.targetPositionVec, clickedAxis);
                }
                Vector3d diff = new Vector3d(intersection.x - targetPositionD.field_1352, intersection.y - targetPositionD.field_1351, intersection.z - targetPositionD.field_1350);
                if (this.localRotation != null) {
                    this.localRotation.transformInverse(diff);
                }
                if (intersectionId == 1 && !this.yAxisRotationOnly) {
                    return new GizmoTarget.Rotate((float)Math.atan2(diff.z, diff.y), class_2350.class_2351.field_11048);
                }
                if (intersectionId == 2) {
                    return new GizmoTarget.Rotate((float)Math.atan2(diff.x, diff.z), class_2350.class_2351.field_11052);
                }
                if (intersectionId == 3 && !this.yAxisRotationOnly) {
                    return new GizmoTarget.Rotate((float)Math.atan2(diff.y, diff.x), class_2350.class_2351.field_11051);
                }
            }
        }
        return null;
    }

    private boolean shouldSelectHandle(Vector3d closestIntersectionDir, Vector3d closestIntersection, float closestDot, Vector3d newIntersectionDir, Vector3d newIntersection, float newDot, class_243 origin) {
        if (newDot < SELECT_THRESHOLD) {
            return false;
        }
        if (closestIntersectionDir != null) {
            double tooCloseDot = closestIntersectionDir.dot((Vector3dc)newIntersectionDir);
            if (tooCloseDot > (double)SUPER_TOO_CLOSE_THRESHOLD) {
                return newIntersection.distanceSquared(origin.field_1352, origin.field_1351, origin.field_1350) < closestIntersection.distanceSquared(origin.field_1352, origin.field_1351, origin.field_1350);
            }
            if (tooCloseDot > (double)TOO_CLOSE_THRESHOLD) {
                double tooCloseFactor = (tooCloseDot - (double)TOO_CLOSE_THRESHOLD) / (double)(SUPER_TOO_CLOSE_THRESHOLD - TOO_CLOSE_THRESHOLD);
                if (newIntersection.distanceSquared(origin.field_1352, origin.field_1351, origin.field_1350) < closestIntersection.distanceSquared(origin.field_1352, origin.field_1351, origin.field_1350)) {
                    newDot = 1.0f - (1.0f - newDot) * (1.0f - (float)tooCloseFactor);
                } else {
                    closestDot = 1.0f - (1.0f - closestDot) * (1.0f - (float)tooCloseFactor);
                }
            }
        }
        return newDot > closestDot;
    }

    private static void drawBox(class_287 bufferBuilder, Matrix4f matrix4f, float boxSize, int boxColour) {
        float alpha = (float)(boxColour >> 24 & 0xFF) / 255.0f;
        float red = (float)(boxColour >> 16 & 0xFF) / 255.0f;
        float green = (float)(boxColour >> 8 & 0xFF) / 255.0f;
        float blue = (float)(boxColour & 0xFF) / 255.0f;
        float XF = 0.7f;
        float YPF = 1.0f;
        float YNF = 0.6f;
        float ZF = 0.87f;
        bufferBuilder.method_22918(matrix4f, -boxSize, -boxSize, -boxSize).method_22915(red * 0.7f, green * 0.7f, blue * 0.7f, alpha);
        bufferBuilder.method_22918(matrix4f, -boxSize, -boxSize, boxSize).method_22915(red * 0.7f, green * 0.7f, blue * 0.7f, alpha);
        bufferBuilder.method_22918(matrix4f, -boxSize, boxSize, -boxSize).method_22915(red * 0.7f, green * 0.7f, blue * 0.7f, alpha);
        bufferBuilder.method_22918(matrix4f, -boxSize, boxSize, boxSize).method_22915(red * 0.7f, green * 0.7f, blue * 0.7f, alpha);
        bufferBuilder.method_22918(matrix4f, -boxSize, boxSize, -boxSize).method_22915(red * 0.7f, green * 0.7f, blue * 0.7f, alpha);
        bufferBuilder.method_22918(matrix4f, -boxSize, -boxSize, boxSize).method_22915(red * 0.7f, green * 0.7f, blue * 0.7f, alpha);
        bufferBuilder.method_22918(matrix4f, -boxSize, boxSize, boxSize).method_22915(red * 0.87f, green * 0.87f, blue * 0.87f, alpha);
        bufferBuilder.method_22918(matrix4f, -boxSize, -boxSize, boxSize).method_22915(red * 0.87f, green * 0.87f, blue * 0.87f, alpha);
        bufferBuilder.method_22918(matrix4f, boxSize, boxSize, boxSize).method_22915(red * 0.87f, green * 0.87f, blue * 0.87f, alpha);
        bufferBuilder.method_22918(matrix4f, boxSize, -boxSize, boxSize).method_22915(red * 0.87f, green * 0.87f, blue * 0.87f, alpha);
        bufferBuilder.method_22918(matrix4f, boxSize, boxSize, boxSize).method_22915(red * 0.87f, green * 0.87f, blue * 0.87f, alpha);
        bufferBuilder.method_22918(matrix4f, -boxSize, -boxSize, boxSize).method_22915(red * 0.87f, green * 0.87f, blue * 0.87f, alpha);
        bufferBuilder.method_22918(matrix4f, boxSize, -boxSize, boxSize).method_22915(red * 0.7f, green * 0.7f, blue * 0.7f, alpha);
        bufferBuilder.method_22918(matrix4f, boxSize, -boxSize, -boxSize).method_22915(red * 0.7f, green * 0.7f, blue * 0.7f, alpha);
        bufferBuilder.method_22918(matrix4f, boxSize, boxSize, boxSize).method_22915(red * 0.7f, green * 0.7f, blue * 0.7f, alpha);
        bufferBuilder.method_22918(matrix4f, boxSize, boxSize, -boxSize).method_22915(red * 0.7f, green * 0.7f, blue * 0.7f, alpha);
        bufferBuilder.method_22918(matrix4f, boxSize, boxSize, boxSize).method_22915(red * 0.7f, green * 0.7f, blue * 0.7f, alpha);
        bufferBuilder.method_22918(matrix4f, boxSize, -boxSize, -boxSize).method_22915(red * 0.7f, green * 0.7f, blue * 0.7f, alpha);
        bufferBuilder.method_22918(matrix4f, boxSize, boxSize, -boxSize).method_22915(red * 0.87f, green * 0.87f, blue * 0.87f, alpha);
        bufferBuilder.method_22918(matrix4f, boxSize, -boxSize, -boxSize).method_22915(red * 0.87f, green * 0.87f, blue * 0.87f, alpha);
        bufferBuilder.method_22918(matrix4f, -boxSize, boxSize, -boxSize).method_22915(red * 0.87f, green * 0.87f, blue * 0.87f, alpha);
        bufferBuilder.method_22918(matrix4f, -boxSize, -boxSize, -boxSize).method_22915(red * 0.87f, green * 0.87f, blue * 0.87f, alpha);
        bufferBuilder.method_22918(matrix4f, -boxSize, boxSize, -boxSize).method_22915(red * 0.87f, green * 0.87f, blue * 0.87f, alpha);
        bufferBuilder.method_22918(matrix4f, boxSize, -boxSize, -boxSize).method_22915(red * 0.87f, green * 0.87f, blue * 0.87f, alpha);
        bufferBuilder.method_22918(matrix4f, -boxSize, -boxSize, -boxSize).method_22915(red * 0.6f, green * 0.6f, blue * 0.6f, alpha);
        bufferBuilder.method_22918(matrix4f, boxSize, -boxSize, -boxSize).method_22915(red * 0.6f, green * 0.6f, blue * 0.6f, alpha);
        bufferBuilder.method_22918(matrix4f, -boxSize, -boxSize, boxSize).method_22915(red * 0.6f, green * 0.6f, blue * 0.6f, alpha);
        bufferBuilder.method_22918(matrix4f, boxSize, -boxSize, boxSize).method_22915(red * 0.6f, green * 0.6f, blue * 0.6f, alpha);
        bufferBuilder.method_22918(matrix4f, -boxSize, -boxSize, boxSize).method_22915(red * 0.6f, green * 0.6f, blue * 0.6f, alpha);
        bufferBuilder.method_22918(matrix4f, boxSize, -boxSize, -boxSize).method_22915(red * 0.6f, green * 0.6f, blue * 0.6f, alpha);
        bufferBuilder.method_22918(matrix4f, -boxSize, boxSize, -boxSize).method_22915(red * 1.0f, green * 1.0f, blue * 1.0f, alpha);
        bufferBuilder.method_22918(matrix4f, -boxSize, boxSize, boxSize).method_22915(red * 1.0f, green * 1.0f, blue * 1.0f, alpha);
        bufferBuilder.method_22918(matrix4f, boxSize, boxSize, -boxSize).method_22915(red * 1.0f, green * 1.0f, blue * 1.0f, alpha);
        bufferBuilder.method_22918(matrix4f, boxSize, boxSize, boxSize).method_22915(red * 1.0f, green * 1.0f, blue * 1.0f, alpha);
        bufferBuilder.method_22918(matrix4f, boxSize, boxSize, -boxSize).method_22915(red * 1.0f, green * 1.0f, blue * 1.0f, alpha);
        bufferBuilder.method_22918(matrix4f, -boxSize, boxSize, boxSize).method_22915(red * 1.0f, green * 1.0f, blue * 1.0f, alpha);
    }

    public record GizmoRotation(class_2350.class_2351 axis, float radians) {
        public Quaternionf toQuaternion() {
            return switch (this.axis) {
                default -> throw new IncompatibleClassChangeError();
                case class_2350.class_2351.field_11048 -> new Quaternionf().rotateX(this.radians);
                case class_2350.class_2351.field_11052 -> new Quaternionf().rotateY(this.radians);
                case class_2350.class_2351.field_11051 -> new Quaternionf().rotateZ(this.radians);
            };
        }
    }

    public record GizmoScale(class_2350.class_2351 axis, boolean scaleAll, float scale) {
        public float getScaleX() {
            return this.scaleAll || this.axis == class_2350.class_2351.field_11048 ? this.scale : 1.0f;
        }

        public float getScaleY() {
            return this.scaleAll || this.axis == class_2350.class_2351.field_11052 ? this.scale : 1.0f;
        }

        public float getScaleZ() {
            return this.scaleAll || this.axis == class_2350.class_2351.field_11051 ? this.scale : 1.0f;
        }
    }
}

