/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.windows.save_world;

import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixUtils;
import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.block_maps.BlockEntityMap;
import com.moulberry.axiom.capabilities.ReplaceMode;
import com.moulberry.axiom.custom_blocks.CustomBlock;
import com.moulberry.axiom.custom_blocks.CustomBlockState;
import com.moulberry.axiom.downgrade.DowngradeVersion;
import com.moulberry.axiom.downgrade.Downgrader;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.widgets.SelectBlockWidget;
import com.moulberry.axiom.editor.windows.save_world.ConflictResolution;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.utils.DFUHelper;
import com.moulberry.axiom.world_modification.CompressedBlockEntity;
import com.moulberry.axi\u03bfm.utils.Authorization;
import imgui.ImGui;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2259;
import net.minecraft.class_2338;
import net.minecraft.class_2479;
import net.minecraft.class_2487;
import net.minecraft.class_2495;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class SaveSchematicAction {
    private final Path path;
    private final ChunkedBlockRegion blockRegion;
    private final Long2ObjectMap<CompressedBlockEntity> blockEntities;
    private final int minX;
    private final int minY;
    private final int minZ;
    private final int maxX;
    private final int maxY;
    private final int maxZ;
    private final String serializedAir;
    private final String name;
    private final String author;
    @Nullable
    private final class_2487 additionalSchematicData;
    private boolean finished = false;
    private int index;
    private final class_2540 blockData;
    private final Object2IntMap<String> paletteMap;
    private final List<String> paletteList;
    private final byte[] legacyBlockIds;
    private final byte[] legacyBlockData;
    private final Map<class_2680, String> serializedMap = new HashMap<class_2680, String>();
    private final Downgrader downgrader;
    private final DowngradeVersion downgradeVersion;
    private final boolean isLegacy;
    private final Map<class_2248, ConflictResolution> conflictResolutionForBlock = new HashMap<class_2248, ConflictResolution>();
    private final Map<class_2248, CustomBlock> otherBlockForBlock = new HashMap<class_2248, CustomBlock>();
    private ConflictResolution doesntExistResolution = null;
    private ConflictResolution substituteResolution = null;
    private final SelectBlockWidget selectBlockWidget = new SelectBlockWidget(false);
    private boolean doThisForAllConflicts = false;
    private class_2680 promptBlockState = null;
    private Set<class_2680> promptWriteSerialized = new HashSet<class_2680>();
    private String promptDowngrade = null;
    private int promptType = -1;
    private static final Map<String, String> REVERSE_BLOCK_ENTITY_ID_FIX_MAP = (Map)DataFixUtils.make((Object)Maps.newHashMap(), hashMap -> {
        hashMap.put("minecraft:end_portal", "Airportal");
        hashMap.put("minecraft:banner", "Banner");
        hashMap.put("minecraft:beacon", "Beacon");
        hashMap.put("minecraft:brewing_stand", "Cauldron");
        hashMap.put("minecraft:chest", "Chest");
        hashMap.put("minecraft:comparator", "Comparator");
        hashMap.put("minecraft:command_block", "Control");
        hashMap.put("minecraft:daylight_detector", "DLDetector");
        hashMap.put("minecraft:dropper", "Dropper");
        hashMap.put("minecraft:enchanting_table", "EnchantTable");
        hashMap.put("minecraft:end_gateway", "EndGateway");
        hashMap.put("minecraft:ender_chest", "EnderChest");
        hashMap.put("minecraft:flower_pot", "FlowerPot");
        hashMap.put("minecraft:furnace", "Furnace");
        hashMap.put("minecraft:hopper", "Hopper");
        hashMap.put("minecraft:mob_spawner", "MobSpawner");
        hashMap.put("minecraft:noteblock", "Music");
        hashMap.put("minecraft:piston", "Piston");
        hashMap.put("minecraft:jukebox", "RecordPlayer");
        hashMap.put("minecraft:sign", "Sign");
        hashMap.put("minecraft:skull", "Skull");
        hashMap.put("minecraft:structure_block", "Structure");
        hashMap.put("minecraft:dispenser", "Trap");
    });

    public SaveSchematicAction(Path path, ChunkedBlockRegion blockRegion, Long2ObjectMap<CompressedBlockEntity> blockEntities, DowngradeVersion downgradeVersion, String name, String author, @Nullable class_2487 additionalSchematicData) {
        this.path = path;
        this.blockRegion = blockRegion;
        this.blockEntities = blockEntities;
        this.name = name;
        this.author = author;
        this.additionalSchematicData = additionalSchematicData;
        this.minX = this.blockRegion.min().method_10263();
        this.minY = this.blockRegion.min().method_10264();
        this.minZ = this.blockRegion.min().method_10260();
        this.maxX = this.blockRegion.max().method_10263();
        this.maxY = this.blockRegion.max().method_10264();
        this.maxZ = this.blockRegion.max().method_10260();
        int currentDataVersion = DFUHelper.DATA_VERSION;
        if (downgradeVersion == null || downgradeVersion.getMinDataVersion() <= currentDataVersion && currentDataVersion <= downgradeVersion.getMaxDataVersion()) {
            this.downgrader = null;
            this.downgradeVersion = null;
            this.serializedAir = class_2259.method_9685((class_2680)class_2246.field_10124.method_9564());
        } else {
            this.downgrader = new Downgrader(downgradeVersion);
            this.downgradeVersion = downgradeVersion;
            String serializedAir = this.downgrader.downgrade(class_2259.method_9685((class_2680)class_2246.field_10124.method_9564()));
            if (serializedAir != null && serializedAir.startsWith("?")) {
                serializedAir = serializedAir.substring(1);
            }
            if (serializedAir == null || serializedAir.isEmpty()) {
                serializedAir = this.downgradeVersion.getMaxDataVersion() >= 1631 ? class_2259.method_9685((class_2680)class_2246.field_10124.method_9564()) : "0";
            }
            this.serializedAir = serializedAir;
        }
        if (this.downgradeVersion == null || this.downgradeVersion.getMaxDataVersion() >= 1631) {
            this.isLegacy = false;
            this.blockData = new class_2540(Unpooled.buffer());
            this.paletteMap = new Object2IntOpenHashMap();
            this.paletteList = new ArrayList<String>();
            this.legacyBlockIds = null;
            this.legacyBlockData = null;
        } else {
            this.isLegacy = true;
            this.blockData = null;
            this.paletteMap = null;
            this.paletteList = null;
            int sizeX = this.maxX - this.minX + 1;
            int sizeY = this.maxY - this.minY + 1;
            int sizeZ = this.maxZ - this.minZ + 1;
            int count = sizeX * sizeY * sizeZ;
            this.legacyBlockIds = new byte[count];
            this.legacyBlockData = new byte[count];
        }
    }

    public boolean render() {
        if (this.finished) {
            throw new FaultyImplementationError();
        }
        if (this.promptType >= 0) {
            String text;
            if (!ImGui.isPopupOpen("###ExportPrompt")) {
                ImGui.openPopup("###ExportPrompt");
            }
            String string = text = this.promptType == 1 ? "Don't know how to downgrade this block to " + this.downgradeVersion.getVersionString() : "Block doesn't exist in " + this.downgradeVersion.getVersionString();
            if (ImGuiHelper.beginPopupModal(text + "###ExportPrompt", 64)) {
                Enum conflictResolution = null;
                if (this.promptType == 0 || this.promptType == 2) {
                    ImGuiHelper.blockStateButton((CustomBlockState)this.promptBlockState, 0, 64);
                    if (this.promptType == 2) {
                        ImGuiHelper.separatorWithText("Substitute");
                        ImGui.text(this.promptDowngrade);
                    }
                    ImGuiHelper.separatorWithText("Actions");
                    if (this.promptType == 2 && ImGui.button("Replace with Substitute")) {
                        conflictResolution = ConflictResolution.REPLACE_WITH_SUBSTITUTE;
                    }
                    if (ImGui.button("Replace with Air")) {
                        conflictResolution = ConflictResolution.REPLACE_WITH_AIR;
                    }
                    if (!this.isLegacy && ImGui.button("Force write anyways (dangerous!)")) {
                        conflictResolution = ConflictResolution.FORCE_WRITE_ANYWAYS;
                    }
                    if (ImGui.button("Replace with other block")) {
                        this.selectBlockWidget.open();
                    }
                    this.selectBlockWidget.render(AxiomI18n.get("axiom.widget.select_block"), EditorUI.getBlockList());
                    CustomBlockState blockState = this.selectBlockWidget.getResultState();
                    if (blockState != null) {
                        if (!this.promptWriteSerialized.contains(this.promptBlockState)) {
                            throw new FaultyImplementationError();
                        }
                        for (class_2680 write : this.promptWriteSerialized) {
                            String serialized;
                            String fromKey = write.method_26204().method_40142().method_40237().method_29177().toString();
                            String toValue = blockState.getVanillaState().method_26204().method_40142().method_40237().method_29177().toString();
                            Axiom.configuration.internal.customDowngradeSuggestions.put(fromKey, toValue);
                            this.conflictResolutionForBlock.put(write.method_26204(), ConflictResolution.REPLACE_WITH_OTHER_BLOCK);
                            this.otherBlockForBlock.put(write.method_26204(), blockState.getCustomBlock());
                            class_2680 newState = blockState.getVanillaState();
                            for (class_2769 property : write.method_28501()) {
                                if (!newState.method_28498(property)) continue;
                                newState = ReplaceMode.copyProperty((CustomBlockState)write, newState, property);
                            }
                            if (this.serializedMap.containsKey(newState)) {
                                serialized = this.serializedMap.get(newState);
                                if (newState == write) continue;
                                this.serializedMap.put(write, serialized);
                                continue;
                            }
                            serialized = this.tryDowngrade(newState);
                            if (serialized == null) {
                                ImGui.endPopup();
                                return false;
                            }
                            this.serializedMap.put(newState, serialized);
                            if (newState == write) continue;
                            this.serializedMap.put(write, serialized);
                        }
                        this.promptType = -1;
                        this.promptWriteSerialized.clear();
                        this.promptBlockState = null;
                        this.promptDowngrade = null;
                        ImGui.endPopup();
                        return this.run();
                    }
                    if (ImGui.checkbox("Do this for all conflicts", this.doThisForAllConflicts)) {
                        this.doThisForAllConflicts = !this.doThisForAllConflicts;
                    }
                    ImGui.sameLine();
                } else if (this.promptType == 1) {
                    String namespace = this.promptBlockState.method_26204().method_40142().method_40237().method_29177().method_12836();
                    if (!namespace.equals("minecraft")) {
                        ImGui.text("This block seems to be modded (" + namespace + ").");
                    } else {
                        ImGui.text("This is likely an issue with Axiom.");
                    }
                    ImGuiHelper.blockStateButton((CustomBlockState)this.promptBlockState, 0, 64);
                    ImGuiHelper.separatorWithText("Actions");
                    if (ImGui.button("Replace with Air")) {
                        conflictResolution = ConflictResolution.REPLACE_WITH_AIR;
                    }
                    if (!this.isLegacy && ImGui.button("Force write anyways (dangerous!)")) {
                        conflictResolution = ConflictResolution.FORCE_WRITE_ANYWAYS;
                    }
                    if (ImGui.checkbox("Do this for all unknown blocks", this.doThisForAllConflicts)) {
                        this.doThisForAllConflicts = !this.doThisForAllConflicts;
                    }
                    ImGui.sameLine();
                }
                if (ImGui.button("Cancel Export")) {
                    ImGui.endPopup();
                    return true;
                }
                ImGui.endPopup();
                if (conflictResolution == null) {
                    return false;
                }
                String resolved = switch (1.$SwitchMap$com$moulberry$axiom$editor$windows$save_world$ConflictResolution[conflictResolution.ordinal()]) {
                    default -> throw new IncompatibleClassChangeError();
                    case 1 -> this.promptDowngrade;
                    case 2 -> this.serializedAir;
                    case 3 -> class_2259.method_9685((class_2680)this.promptBlockState);
                    case 4 -> throw new FaultyImplementationError();
                };
                if (!this.promptWriteSerialized.contains(this.promptBlockState)) {
                    throw new FaultyImplementationError();
                }
                for (class_2680 write : this.promptWriteSerialized) {
                    this.serializedMap.put(write, resolved);
                    this.conflictResolutionForBlock.put(write.method_26204(), (ConflictResolution)conflictResolution);
                }
                if (this.doThisForAllConflicts) {
                    this.doThisForAllConflicts = false;
                    if (this.promptType == 0 || this.promptType == 1) {
                        this.doesntExistResolution = conflictResolution;
                    } else {
                        this.substituteResolution = conflictResolution;
                    }
                }
            }
        } else {
            if (!ImGui.isPopupOpen("###ExportPrompt")) {
                ImGui.openPopup("###ExportPrompt");
            }
            if (ImGuiHelper.beginPopupModal("Exporting...###ExportPrompt", 64)) {
                ImGui.text("Exporting...");
                if (ImGui.button("Cancel")) {
                    return true;
                }
                ImGui.endPopup();
            }
        }
        this.promptType = -1;
        this.promptWriteSerialized.clear();
        this.promptBlockState = null;
        this.promptDowngrade = null;
        return this.run();
    }

    private String tryDowngrade(class_2680 blockState) {
        String fromKey;
        String customSuggestion;
        String originalSerialized = class_2259.method_9685((class_2680)blockState);
        if (this.downgrader == null) {
            return originalSerialized;
        }
        Object downgraded = this.downgrader.downgrade(originalSerialized);
        if ((downgraded == null || ((String)downgraded).isEmpty() || ((String)downgraded).startsWith("?")) && (customSuggestion = Axiom.configuration.internal.customDowngradeSuggestions.get(fromKey = blockState.method_26204().method_40142().method_40237().method_29177().toString())) != null) {
            try {
                class_2960 resourceLocation = class_2960.method_60654((String)customSuggestion);
                class_2248 block = class_7923.field_41175.method_17966(resourceLocation).orElse(null);
                if (block != null) {
                    class_2680 newState = block.method_9564();
                    for (class_2769 property : blockState.method_28501()) {
                        if (!newState.method_28498(property)) continue;
                        newState = ReplaceMode.copyProperty((CustomBlockState)blockState, newState, property);
                    }
                    String newDowngraded = this.downgrader.downgrade(class_2259.method_9685((class_2680)newState));
                    if (newDowngraded != null && !newDowngraded.isEmpty()) {
                        downgraded = !newDowngraded.startsWith("?") ? "?" + newDowngraded : newDowngraded;
                    }
                }
            }
            catch (Exception resourceLocation) {
                // empty catch block
            }
        }
        if (downgraded == null || ((String)downgraded).isEmpty()) {
            ConflictResolution conflictResolution = this.conflictResolutionForBlock.get(blockState.method_26204());
            if (conflictResolution == null) {
                conflictResolution = this.doesntExistResolution;
            }
            if (conflictResolution == ConflictResolution.REPLACE_WITH_OTHER_BLOCK && this.otherBlockForBlock.containsKey(blockState.method_26204())) {
                String newDowngraded;
                CustomBlock otherBlock = this.otherBlockForBlock.get(blockState.method_26204());
                class_2680 newState = otherBlock.axiom$defaultCustomState().getVanillaState();
                for (Object property : blockState.method_28501()) {
                    if (!newState.method_28498((class_2769)property)) continue;
                    newState = ReplaceMode.copyProperty((CustomBlockState)blockState, newState, property);
                }
                if (this.serializedMap.containsKey(newState)) {
                    newDowngraded = this.serializedMap.get(newState);
                    if (newState != blockState) {
                        this.serializedMap.put(blockState, newDowngraded);
                    }
                    return newDowngraded;
                }
                newDowngraded = this.tryDowngrade(newState);
                if (newDowngraded == null) {
                    return null;
                }
                this.serializedMap.put(newState, newDowngraded);
                if (newState != blockState) {
                    this.serializedMap.put(blockState, newDowngraded);
                }
                return newDowngraded;
            }
            if (conflictResolution == ConflictResolution.REPLACE_WITH_AIR) {
                this.serializedMap.put(blockState, this.serializedAir);
                return this.serializedAir;
            }
            if (conflictResolution == ConflictResolution.FORCE_WRITE_ANYWAYS) {
                this.serializedMap.put(blockState, originalSerialized);
                return originalSerialized;
            }
            this.promptType = downgraded == null ? 0 : 1;
            this.promptBlockState = blockState;
            this.promptWriteSerialized.add(blockState);
            this.promptDowngrade = null;
            return null;
        }
        if (((String)downgraded).startsWith("?")) {
            String substitute = ((String)downgraded).substring(1);
            ConflictResolution conflictResolution = this.conflictResolutionForBlock.get(blockState.method_26204());
            if (conflictResolution == null) {
                conflictResolution = this.substituteResolution;
            }
            if (conflictResolution == ConflictResolution.REPLACE_WITH_OTHER_BLOCK && this.otherBlockForBlock.containsKey(blockState.method_26204())) {
                String newDowngraded;
                CustomBlock otherBlock = this.otherBlockForBlock.get(blockState.method_26204());
                class_2680 newState = otherBlock.axiom$defaultCustomState().getVanillaState();
                for (class_2769 property : blockState.method_28501()) {
                    if (!newState.method_28498(property)) continue;
                    newState = ReplaceMode.copyProperty((CustomBlockState)blockState, newState, property);
                }
                if (this.serializedMap.containsKey(newState)) {
                    newDowngraded = this.serializedMap.get(newState);
                    if (newState != blockState) {
                        this.serializedMap.put(blockState, newDowngraded);
                    }
                    return newDowngraded;
                }
                newDowngraded = this.tryDowngrade(newState);
                if (newDowngraded == null) {
                    return null;
                }
                this.serializedMap.put(newState, newDowngraded);
                if (newState != blockState) {
                    this.serializedMap.put(blockState, newDowngraded);
                }
                return newDowngraded;
            }
            if (conflictResolution == ConflictResolution.REPLACE_WITH_SUBSTITUTE) {
                this.serializedMap.put(blockState, substitute);
                return substitute;
            }
            if (conflictResolution == ConflictResolution.REPLACE_WITH_AIR) {
                this.serializedMap.put(blockState, this.serializedAir);
                return this.serializedAir;
            }
            if (conflictResolution == ConflictResolution.FORCE_WRITE_ANYWAYS) {
                this.serializedMap.put(blockState, originalSerialized);
                return originalSerialized;
            }
            this.promptType = 2;
            this.promptBlockState = blockState;
            this.promptWriteSerialized.add(blockState);
            this.promptDowngrade = substitute;
            return null;
        }
        this.serializedMap.put(blockState, (String)downgraded);
        return downgraded;
    }

    public boolean run() {
        if (!this.isLegacy) {
            return this.runSpongeV2();
        }
        return this.runLegacy();
    }

    private boolean runSpongeV2() {
        if (this.finished) {
            throw new FaultyImplementationError();
        }
        int width = this.maxX - this.minX + 1;
        int height = this.maxY - this.minY + 1;
        int length = this.maxZ - this.minZ + 1;
        int maxIndex = width * height * length;
        while (this.index < maxIndex) {
            int entry;
            String serialized;
            int x = this.index % width + this.minX;
            int y = this.index / (width * length) + this.minY;
            int z = this.index % (width * length) / width + this.minZ;
            class_2680 blockState = this.blockRegion.getBlockStateOrAir(x, y, z);
            if (this.serializedMap.containsKey(blockState)) {
                serialized = this.serializedMap.get(blockState);
            } else {
                serialized = this.tryDowngrade(blockState);
                if (serialized == null) {
                    return false;
                }
            }
            if (this.paletteMap.containsKey((Object)serialized)) {
                entry = this.paletteMap.getInt((Object)serialized);
            } else {
                entry = this.paletteMap.size();
                this.paletteMap.put((Object)serialized, entry);
                this.paletteList.add(serialized);
            }
            this.blockData.method_10804(entry);
            ++this.index;
        }
        class_2487 schematic = new class_2487();
        schematic.method_10569("Version", 2);
        if (this.downgradeVersion == null) {
            schematic.method_10569("DataVersion", DFUHelper.DATA_VERSION);
        } else {
            schematic.method_10569("DataVersion", this.downgradeVersion.getMinDataVersion());
        }
        schematic.method_10575("Width", (short)(width & 0xFFFF));
        schematic.method_10575("Height", (short)(height & 0xFFFF));
        schematic.method_10575("Length", (short)(length & 0xFFFF));
        class_2487 metadata = new class_2487();
        metadata.method_10582("Name", this.name);
        metadata.method_10582("Author", this.author);
        metadata.method_10582("CreatedBy", Authorization.getUserAgent());
        metadata.method_10544("Date", System.currentTimeMillis());
        schematic.method_10566("Metadata", (class_2520)metadata);
        schematic.method_10539("Offset", new int[]{0, 0, 0});
        byte[] bytes = new byte[this.blockData.writerIndex()];
        this.blockData.method_52952(0, bytes);
        schematic.method_10566("BlockData", (class_2520)new class_2479(bytes));
        class_2499 blockEntities = new class_2499();
        this.blockEntities.forEach((pos, compressedBlockEntity) -> {
            int z;
            int y;
            int x = class_2338.method_10061((long)pos);
            class_2680 blockState = this.blockRegion.getBlockStateOrAir(x, y = class_2338.method_10071((long)pos), z = class_2338.method_10083((long)pos));
            class_2591<?> type2 = BlockEntityMap.get(blockState.method_26204());
            class_2960 resourceLocation = class_2591.method_11033(type2);
            if (resourceLocation != null) {
                class_2487 tag = compressedBlockEntity.decompress();
                tag.method_10539("Pos", new int[]{x - this.minX, y - this.minY, z - this.minZ});
                tag.method_10582("Id", resourceLocation.toString());
                blockEntities.add((Object)tag);
            }
        });
        schematic.method_10566("BlockEntities", (class_2520)blockEntities);
        class_2487 palette = new class_2487();
        for (int i = 0; i < this.paletteList.size(); ++i) {
            palette.method_10569(this.paletteList.get(i), i);
        }
        schematic.method_10566("Palette", (class_2520)palette);
        schematic.method_10569("PaletteMax", this.paletteList.size());
        this.putAdditional(schematic, false);
        try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(this.path, new OpenOption[0]));
             DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(outputStream)));){
            dataOutputStream.writeByte(schematic.method_10711());
            dataOutputStream.writeUTF("Schematic");
            schematic.method_10713((DataOutput)dataOutputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.finished = true;
        return true;
    }

    private void putAdditional(class_2487 schematic, boolean legacy) {
        if (this.additionalSchematicData == null) {
            return;
        }
        for (String key : this.additionalSchematicData.method_10541()) {
            class_2499 listTag;
            class_2487 compoundTag;
            class_2520 tag = this.additionalSchematicData.method_10580(key);
            if (tag == null) continue;
            if (legacy) {
                if (key.equals("Metadata") && tag instanceof class_2487) {
                    class_2520 worldEditOffsetZ;
                    class_2520 worldEditOffsetY;
                    class_2487 compound = (class_2487)tag;
                    class_2520 worldEditOffsetX = compound.method_10580("WEOffsetX");
                    if (worldEditOffsetX != null) {
                        schematic.method_10566("WEOffsetX", worldEditOffsetX);
                        compound.method_10551("WEOffsetX");
                    }
                    if ((worldEditOffsetY = compound.method_10580("WEOffsetY")) != null) {
                        schematic.method_10566("WEOffsetY", worldEditOffsetY);
                        compound.method_10551("WEOffsetY");
                    }
                    if ((worldEditOffsetZ = compound.method_10580("WEOffsetZ")) != null) {
                        schematic.method_10566("WEOffsetZ", worldEditOffsetZ);
                        compound.method_10551("WEOffsetZ");
                    }
                } else {
                    class_2495 intArrayTag;
                    if (key.equals("Offset") && tag instanceof class_2495 && (intArrayTag = (class_2495)tag).size() == 3) {
                        schematic.method_10566("WEOriginX", (class_2520)intArrayTag.method_10589(0));
                        schematic.method_10566("WEOriginY", (class_2520)intArrayTag.method_10589(1));
                        schematic.method_10566("WEOriginZ", (class_2520)intArrayTag.method_10589(2));
                        continue;
                    }
                    if (key.equals("Version")) continue;
                }
            }
            if (tag instanceof class_2487 && (compoundTag = (class_2487)tag).method_33133() || tag instanceof class_2499 && (listTag = (class_2499)tag).isEmpty()) continue;
            this.merge(schematic, key, tag);
        }
    }

    private void merge(class_2487 into, String key, class_2520 tag) {
        if (!into.method_10545(key)) {
            into.method_10566(key, tag);
            return;
        }
        Optional existingOptional = into.method_10562(key);
        if (existingOptional.isPresent() && tag instanceof class_2487) {
            class_2487 compoundTag = (class_2487)tag;
            class_2487 existing = (class_2487)existingOptional.get();
            for (String subkey : compoundTag.method_10541()) {
                class_2520 subtag = compoundTag.method_10580(subkey);
                if (subtag == null) continue;
                this.merge(existing, subkey, subtag);
            }
        }
    }

    private boolean runLegacy() {
        if (this.finished) {
            throw new FaultyImplementationError();
        }
        int width = this.maxX - this.minX + 1;
        int height = this.maxY - this.minY + 1;
        int length = this.maxZ - this.minZ + 1;
        int maxIndex = width * height * length;
        while (this.index < maxIndex) {
            byte blockData;
            byte blockId;
            String serialized;
            int x = this.index % width + this.minX;
            int y = this.index / (width * length) + this.minY;
            int z = this.index % (width * length) / width + this.minZ;
            class_2680 blockState = this.blockRegion.getBlockStateOrAir(x, y, z);
            if (this.serializedMap.containsKey(blockState)) {
                serialized = this.serializedMap.get(blockState);
            } else {
                serialized = this.tryDowngrade(blockState);
                if (serialized == null) {
                    return false;
                }
            }
            if (serialized.contains(":")) {
                String[] split = serialized.split(":");
                blockId = (byte)Integer.parseInt(split[0]);
                blockData = Byte.parseByte(split[1]);
            } else {
                blockId = (byte)Integer.parseInt(serialized);
                blockData = 0;
            }
            this.legacyBlockIds[this.index] = blockId;
            this.legacyBlockData[this.index] = blockData;
            ++this.index;
        }
        class_2487 schematic = new class_2487();
        schematic.method_10582("Materials", "Alpha");
        schematic.method_10575("Width", (short)(width & 0xFFFF));
        schematic.method_10575("Height", (short)(height & 0xFFFF));
        schematic.method_10575("Length", (short)(length & 0xFFFF));
        schematic.method_10570("Blocks", this.legacyBlockIds);
        schematic.method_10570("Data", this.legacyBlockData);
        class_2499 blockEntities = new class_2499();
        this.blockEntities.forEach((pos, compressedBlockEntity) -> {
            int z;
            int y;
            int x = class_2338.method_10061((long)pos);
            class_2680 blockState = this.blockRegion.getBlockStateOrAir(x, y = class_2338.method_10071((long)pos), z = class_2338.method_10083((long)pos));
            class_2591<?> type2 = BlockEntityMap.get(blockState.method_26204());
            class_2960 resourceLocation = class_2591.method_11033(type2);
            if (resourceLocation != null) {
                class_2487 tag = compressedBlockEntity.decompress();
                String id = resourceLocation.toString();
                if (this.downgradeVersion.getMinDataVersion() <= 704 && (id = REVERSE_BLOCK_ENTITY_ID_FIX_MAP.get(id)) == null) {
                    return;
                }
                tag.method_10582("id", id);
                tag.method_10569("x", x - this.minX);
                tag.method_10569("y", y - this.minY);
                tag.method_10569("z", z - this.minZ);
                blockEntities.add((Object)tag);
            }
        });
        schematic.method_10566("TileEntities", (class_2520)blockEntities);
        schematic.method_10566("Entities", (class_2520)new class_2499());
        this.putAdditional(schematic, true);
        try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(this.path, new OpenOption[0]));
             DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(outputStream)));){
            dataOutputStream.writeByte(schematic.method_10711());
            dataOutputStream.writeUTF("Schematic");
            schematic.method_10713((DataOutput)dataOutputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.finished = true;
        return true;
    }
}

