/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.windows.operations;

import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.editor.EditorWindowType;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.operations.AnalyzeBlocksOperation;
import imgui.ImGui;
import java.text.NumberFormat;

public class AnalyzeBlocksWindow {
    private static AnalyzeBlocksOperation.Information blockCountInformation = null;
    private static boolean filterBlockEntities = false;

    public static void render() {
        if (!EditorWindowType.ANALYZE.isOpen()) {
            return;
        }
        if (EditorWindowType.ANALYZE.begin("###AnalyzeBlocks", true)) {
            boolean disable;
            if (blockCountInformation != null && ImGui.beginTable("##BlockCounts", 3, 1920)) {
                ImGui.tableNextColumn();
                ImGui.text(AxiomI18n.get("axiom.editorui.window.analyze.block_type"));
                ImGui.tableNextColumn();
                ImGui.text(AxiomI18n.get("axiom.editorui.window.analyze.block_count"));
                ImGui.tableNextColumn();
                ImGui.text(AxiomI18n.get("axiom.editorui.window.analyze.block_distribution"));
                ImGui.tableNextColumn();
                ImGui.tableNextColumn();
                ImGui.tableNextColumn();
                ImGui.tableNextColumn();
                for (AnalyzeBlocksOperation.InformationEntry entry : blockCountInformation.list()) {
                    String countString = NumberFormat.getInstance().format(entry.count());
                    String blockName = AxiomI18n.get(entry.block().axiom$translationKey());
                    float ratio = (float)entry.count() * 100.0f / (float)blockCountInformation.total();
                    ImGui.text(blockName);
                    ImGui.tableNextColumn();
                    ImGui.text(countString);
                    ImGui.tableNextColumn();
                    ImGui.text(String.format("%.1f%%", Float.valueOf(ratio)));
                    ImGui.tableNextColumn();
                }
                ImGui.tableNextColumn();
                ImGui.tableNextColumn();
                ImGui.tableNextColumn();
                ImGui.text(AxiomI18n.get("axiom.editorui.window.block_distribution_total"));
                ImGui.tableNextColumn();
                ImGui.text(NumberFormat.getInstance().format(blockCountInformation.total()));
                ImGui.tableNextColumn();
                ImGui.text("100.0%");
                ImGui.endTable();
            }
            if (ImGui.checkbox(AxiomI18n.get("axiom.editorui.window.analyze.filter_block_entities"), filterBlockEntities)) {
                boolean bl = filterBlockEntities = !filterBlockEntities;
            }
            if (disable = Selection.getSelectionBuffer().isEmpty()) {
                ImGui.beginDisabled();
            }
            if (ImGui.button(AxiomI18n.get("axiom.editorui.window.analyze.do_analyze"))) {
                blockCountInformation = AnalyzeBlocksOperation.analyze(filterBlockEntities);
            }
            if (disable) {
                ImGui.endDisabled();
            }
            ImGui.sameLine();
            if (ImGui.button(AxiomI18n.get("axiom.editorui.window.analyze.clear_information"))) {
                blockCountInformation = null;
            }
        }
        EditorWindowType.ANALYZE.end();
    }
}

