/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.windows.global_mask;

import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.custom_blocks.CustomBlock;
import com.moulberry.axiom.custom_blocks.CustomBlockState;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.EditorWindowType;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.palette.CustomBlockStateOrTombstone;
import com.moulberry.axiom.editor.palette.EditorPalette;
import com.moulberry.axiom.editor.widgets.PresetWidget;
import com.moulberry.axiom.editor.windows.global_mask.visualcode.AndMaskWidget;
import com.moulberry.axiom.editor.windows.global_mask.visualcode.AngleMaskWidget;
import com.moulberry.axiom.editor.windows.global_mask.visualcode.BiomeMaskWidget;
import com.moulberry.axiom.editor.windows.global_mask.visualcode.BlockAboveMaskWidget;
import com.moulberry.axiom.editor.windows.global_mask.visualcode.BlockAdjacentMaskWidget;
import com.moulberry.axiom.editor.windows.global_mask.visualcode.BlockBelowMaskWidget;
import com.moulberry.axiom.editor.windows.global_mask.visualcode.BlockMaskWidget;
import com.moulberry.axiom.editor.windows.global_mask.visualcode.BlockNearMaskWidget;
import com.moulberry.axiom.editor.windows.global_mask.visualcode.BlockNeighborMaskWidget;
import com.moulberry.axiom.editor.windows.global_mask.visualcode.CanSeeSkyMaskWidget;
import com.moulberry.axiom.editor.windows.global_mask.visualcode.CoordMaskWidget;
import com.moulberry.axiom.editor.windows.global_mask.visualcode.InSelectionMaskWidget;
import com.moulberry.axiom.editor.windows.global_mask.visualcode.MaskWidget;
import com.moulberry.axiom.editor.windows.global_mask.visualcode.NotMaskWidget;
import com.moulberry.axiom.editor.windows.global_mask.visualcode.OffsetMaskWidget;
import com.moulberry.axiom.editor.windows.global_mask.visualcode.OrMaskWidget;
import com.moulberry.axiom.editor.windows.global_mask.visualcode.SurfaceMaskWidget;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.mask.CmdStringConverter;
import com.moulberry.axiom.mask.LuaHelper;
import com.moulberry.axiom.mask.MaskElement;
import com.moulberry.axiom.mask.MaskManager;
import com.moulberry.axiom.mask.VisualCodeConverter;
import com.moulberry.axiom.utils.BooleanWrapper;
import imgui.ImGui;
import imgui.ImVec2;
import imgui.extension.texteditor.TextEditor;
import imgui.extension.texteditor.TextEditorLanguageDefinition;
import imgui.type.ImString;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2487;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaValue;

public class ToolMaskWindow {
    private static final ImString stringMask = ImGuiHelper.createResizableString(256);
    private static CmdStringConverter.CmdStringParseException lastParseException = null;
    private static MaskWidget widget = null;
    private static final List<FloatingWidget> floatingWidgets = new ArrayList<FloatingWidget>();
    private static final Set<MaskWidget> removeFloating = new HashSet<MaskWidget>();
    private static MaskWidget dragDroppingWidget = null;
    private static boolean visualCodeDirty = false;
    private static int switchMaskTab = 0;
    private static boolean maskChangedForPresetWidget = false;
    private static final PresetWidget presetWidgetMask = new PresetWidget(ToolMaskWindow::loadSettings, ToolMaskWindow::writeSettings, "tool_masks");
    private static boolean scriptChangedForPresetWidget = false;
    private static final PresetWidget presetWidgetScript = new PresetWidget(ToolMaskWindow::loadSettingsScript, ToolMaskWindow::writeSettingsScript, "tool_masks_lua");
    private static final TextEditor LUA_EDITOR = new TextEditor();
    private static long lastLuaCompile;
    private static boolean luaDirty;
    public static String luaExecutionError;
    private static final String LUA_DESCRIPTION;

    public static void render() {
        MaskWidget maskWidget;
        if (!EditorWindowType.TOOL_MASKS.isOpen()) {
            return;
        }
        ImGuiHelper.pushStyleVar(12, 0.0f);
        ImGui.setNextWindowSizeConstraints(510.0f, 350.0f, 5000.0f, 3000.0f);
        if (EditorWindowType.TOOL_MASKS.begin("###ToolMasks", false)) {
            if (Axiom.configuration.internal.showToolMaskOpenWarning) {
                ImGui.textColored(-11184641, "Warning: ");
                ImGui.sameLine();
                ImGui.textWrapped("Masks only apply to tools while this window is open, docked or minimised. Closing this window will result in the mask deactivating");
                if (ImGui.button(AxiomI18n.get("axiom.editorui.warning_confirmation"))) {
                    Axiom.configuration.internal.showToolMaskOpenWarning = false;
                }
                ImGui.separator();
            }
            if (ImGui.beginTabBar("##TabBar")) {
                int switchMaskTabTo = switchMaskTab;
                switchMaskTab = 0;
                if (ImGui.beginTabItem("Mask", switchMaskTabTo == 1 ? 2 : 0)) {
                    presetWidgetMask.displayImgui(maskChangedForPresetWidget);
                    maskChangedForPresetWidget = false;
                    ImGui.sameLine();
                    ImGui.text("Presets");
                    MaskManager.useLuaScript = false;
                    ToolMaskWindow.renderMaskSection();
                    ImGui.endTabItem();
                }
                if (ImGui.beginTabItem("Scripting", switchMaskTabTo == 2 ? 2 : 0)) {
                    presetWidgetScript.displayImgui(scriptChangedForPresetWidget);
                    scriptChangedForPresetWidget = false;
                    ImGui.sameLine();
                    ImGui.text("Presets");
                    MaskManager.useLuaScript = true;
                    ToolMaskWindow.renderScriptingSection();
                    ImGui.endTabItem();
                }
                if (ImGui.beginTabItem("Examples")) {
                    MaskElement maskElement;
                    ImGuiHelper.separatorWithText("Mask");
                    if (ImGui.button("Single block##SingleBlockMask")) {
                        maskElement = CmdStringConverter.fromCmdString("block = stone");
                        MaskManager.setConfiguredMask(maskElement, true, true);
                        switchMaskTab = 1;
                    }
                    if (ImGui.button("Multiple blocks")) {
                        maskElement = CmdStringConverter.fromCmdString("block = [stone,granite]");
                        MaskManager.setConfiguredMask(maskElement, true, true);
                        switchMaskTab = 1;
                    }
                    if (ImGui.button("Grass surface")) {
                        maskElement = CmdStringConverter.fromCmdString("sky & block = air & below = grass_block & angle >= 70");
                        MaskManager.setConfiguredMask(maskElement, true, true);
                        switchMaskTab = 1;
                    }
                    if (ImGui.button("Lower edge")) {
                        maskElement = CmdStringConverter.fromCmdString("offset(0,1,0){ adjacent = #axiom:solid & block = air }");
                        MaskManager.setConfiguredMask(maskElement, true, true);
                        switchMaskTab = 1;
                    }
                    if (ImGui.button("Upper edge")) {
                        maskElement = CmdStringConverter.fromCmdString("adjacent = air & above = air");
                        MaskManager.setConfiguredMask(maskElement, true, true);
                        switchMaskTab = 1;
                    }
                    if (ImGui.button("Shoreline")) {
                        maskElement = CmdStringConverter.fromCmdString("near(4) = water & above = air");
                        MaskManager.setConfiguredMask(maskElement, true, true);
                        switchMaskTab = 1;
                    }
                    ImGuiHelper.separatorWithText("Scripting");
                    if (ImGui.button("Single block##SingleBlockScript")) {
                        LUA_EDITOR.setTextLines(new String[]{"return getBlock(x, y, z) == blocks.stone"});
                        luaDirty = true;
                        switchMaskTab = 2;
                    }
                    if (ImGui.button("Top 3-4 blocks")) {
                        LUA_EDITOR.setTextLines(new String[]{"local depth = getHighestBlockYAt(x, z) - y", "", "if depth == 3 then", "    return math.random() < 0.25", "end", "", "return depth >= 0 and depth < 3"});
                        luaDirty = true;
                        switchMaskTab = 2;
                    }
                    if (ImGui.button("Simplex noise")) {
                        LUA_EDITOR.setTextLines(new String[]{"local scale = 8", "local threshold = 0.5", "local noise = getSimplexNoise(x/scale, y/scale, z/scale)", "return noise < threshold"});
                        luaDirty = true;
                        switchMaskTab = 2;
                    }
                    if (ImGui.button("Voronoi edges noise")) {
                        LUA_EDITOR.setTextLines(new String[]{"local scale = 8", "local noise = getVoronoiEdgeNoise(x/scale, y/scale, z/scale)", "return noise < 0.5/scale"});
                        luaDirty = true;
                        switchMaskTab = 2;
                    }
                    if (ImGui.button("Invalid soil blocks")) {
                        LUA_EDITOR.setTextLines(new String[]{"local soil = {", "    [blocks.grass_block] = true,", "    [blocks.dirt] = true", "}", "", "local block = getBlock(x, y, z)", "if not soil[block] then", "    return false", "end", "", "local i = y+1", "while true do", "    local above = getBlock(x, i, z)", "    if not isSolid(above) then", "       return false", "    end", "    if soil[above] then", "        i = i + 1", "    else", "        return true", "    end", "end"});
                        luaDirty = true;
                        switchMaskTab = 2;
                    }
                    ImGui.endTabItem();
                }
                ImGui.endTabBar();
            }
        }
        EditorWindowType.TOOL_MASKS.end();
        Object t2 = ImGui.getDragDropPayload("MaskWidget");
        if (t2 instanceof MaskWidget && (maskWidget = (MaskWidget)t2) == dragDroppingWidget) {
            if (ImGui.beginDragDropSource(16)) {
                maskWidget.render(false, new BooleanWrapper(false));
                ImGui.endDragDropSource();
            }
        } else {
            dragDroppingWidget = null;
        }
        if (visualCodeDirty) {
            if (widget != null) {
                MaskElement maskElement = VisualCodeConverter.fromVisualCode(widget);
                MaskManager.setConfiguredMask(maskElement, true, false);
            } else {
                MaskManager.setConfiguredMask(null, true, false);
            }
            visualCodeDirty = false;
        }
        ImGuiHelper.popStyleVar();
    }

    private static void renderMaskSection() {
        String clearText = AxiomI18n.get("axiom.editorui.mainmenu.toolmasks.clear");
        float clearWidth = ImGuiHelper.calcTextWidth(clearText);
        ImGui.setNextItemWidth(-clearWidth - ImGui.getStyle().getFramePaddingX() * 2.0f - ImGui.getStyle().getItemSpacingX());
        if (ImGui.inputText("##StringMask", stringMask)) {
            String string = ImGuiHelper.getString(stringMask).trim();
            if (string.isEmpty()) {
                MaskManager.setConfiguredMask(null, false, true);
            } else {
                try {
                    MaskElement maskElement = CmdStringConverter.fromCmdString(string);
                    MaskManager.setConfiguredMask(maskElement, false, true);
                    lastParseException = null;
                }
                catch (CmdStringConverter.CmdStringParseException e) {
                    lastParseException = e;
                }
            }
        }
        ImGui.sameLine();
        if (ImGui.button(clearText)) {
            MaskManager.setConfiguredMask(null, true, true);
            maskChangedForPresetWidget = false;
            presetWidgetMask.setDefault();
        }
        if (lastParseException != null) {
            ToolMaskWindow.renderParseException();
        }
        ImGui.separator();
        BooleanWrapper allowDragDropTarget = new BooleanWrapper(true);
        if (ImGui.beginTable("##Table", 2, 0x2000200)) {
            ImGui.tableSetupColumn("##MaskColumn", 8);
            ImGui.tableSetupColumn("##ToolboxColumn", 16);
            ImVec2 startPos = ImGui.getCursorScreenPos();
            ImGui.tableNextColumn();
            if (ImGui.beginChild("##MaskChild", -1.0f, -2.0f)) {
                if (widget != null) {
                    widget.render(true, allowDragDropTarget);
                }
                ImGuiHelper.pushStyleVar(0, ImGui.getStyle().getAlpha() * ImGui.getStyle().getDisabledAlpha());
                for (FloatingWidget floatingWidget2 : floatingWidgets) {
                    ImGui.setCursorPos(floatingWidget2.x, floatingWidget2.y);
                    ImGui.beginGroup();
                    floatingWidget2.widget.render(true, allowDragDropTarget);
                    ImGui.endGroup();
                }
                ImGuiHelper.popStyleVar();
                floatingWidgets.removeIf(floatingWidget -> removeFloating.contains(floatingWidget.widget));
                removeFloating.clear();
            }
            ImGui.endChild();
            ImVec2 mousePos = ImGui.getMousePos();
            CustomBlockState dragDropped = ImGuiHelper.blockStateDragDropTarget();
            if (dragDropped != null) {
                widget = new BlockMaskWidget(dragDropped.getCustomBlock());
                ToolMaskWindow.markDirty(widget);
            }
            if (ImGui.beginDragDropTarget()) {
                EditorPalette droppedPalette = ImGui.acceptDragDropPayload(EditorPalette.class);
                ArrayList<CustomBlock> customBlocks = new ArrayList<CustomBlock>();
                if (droppedPalette != null) {
                    for (CustomBlockStateOrTombstone block : droppedPalette.getBlocks()) {
                        if (!(block instanceof CustomBlockState)) continue;
                        CustomBlockState customBlockState = (CustomBlockState)block;
                        customBlocks.add(customBlockState.getCustomBlock());
                    }
                }
                if (!customBlocks.isEmpty()) {
                    if (customBlocks.size() == 1) {
                        widget = new BlockMaskWidget((CustomBlock)customBlocks.get(0));
                        ToolMaskWindow.markDirty(widget);
                    } else {
                        OrMaskWidget orMask = new OrMaskWidget();
                        for (CustomBlock customBlock : customBlocks) {
                            orMask.addChild(-1, new BlockMaskWidget(customBlock));
                        }
                        widget = orMask;
                        ToolMaskWindow.markDirty(widget);
                    }
                }
                ImGui.endDragDropTarget();
            }
            if (ImGui.beginDragDropTarget()) {
                MaskWidget maskWidget = (MaskWidget)ImGui.acceptDragDropPayload("MaskWidget", 3072);
                if (maskWidget != null && maskWidget.isDragging()) {
                    boolean snap;
                    boolean bl = snap = widget == null && mousePos.y < startPos.y + 100.0f;
                    if (snap) {
                        ImGui.getWindowDrawList().addRect(startPos.x, startPos.y + 2.0f, startPos.x + ImGui.getContentRegionAvailX(), startPos.y + 3.0f, ImGui.getColorU32(50));
                    }
                    if (ImGui.isMouseReleased(0)) {
                        if (snap) {
                            widget = maskWidget;
                            ToolMaskWindow.markDirty(widget);
                        } else {
                            FloatingWidget floatingWidget3 = new FloatingWidget(mousePos.x - startPos.x, mousePos.y - startPos.y, maskWidget);
                            floatingWidgets.add(floatingWidget3);
                        }
                        maskWidget.setDragging(false);
                    }
                }
                ImGui.endDragDropTarget();
            }
            ImGui.tableNextColumn();
            ToolMaskWindow.renderDefaultMaskWidgets();
            ImGui.endTable();
        }
    }

    private static void renderDefaultMaskWidgets() {
        boolean canDragDrop = ImGui.getDragDropPayload("MaskWidget") == null;
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.editorui.window.tool_masks.logic"));
        ImGui.button(AxiomI18n.get("axiom.editorui.window.tool_masks.mask_or") + " (|)");
        ImGuiHelper.tooltip("If any input is true, then the output is true");
        if (ImGui.isItemHovered()) {
            ImGui.setMouseCursor(7);
        }
        if (canDragDrop && ImGui.beginDragDropSource()) {
            ToolMaskWindow.setDragDroppingWidget(new OrMaskWidget());
            ImGui.endDragDropSource();
        }
        ImGui.button(AxiomI18n.get("axiom.editorui.window.tool_masks.mask_and") + " (&)");
        ImGuiHelper.tooltip("All inputs must be true for the output to be true");
        if (ImGui.isItemHovered()) {
            ImGui.setMouseCursor(7);
        }
        if (canDragDrop && ImGui.beginDragDropSource()) {
            ToolMaskWindow.setDragDroppingWidget(new AndMaskWidget());
            ImGui.endDragDropSource();
        }
        ImGui.button(AxiomI18n.get("axiom.editorui.window.tool_masks.mask_not") + " (!)");
        ImGuiHelper.tooltip("Inverts the input; the input must be false for the output to be true");
        if (ImGui.isItemHovered()) {
            ImGui.setMouseCursor(7);
        }
        if (canDragDrop && ImGui.beginDragDropSource()) {
            ToolMaskWindow.setDragDroppingWidget(new NotMaskWidget());
            ImGui.endDragDropSource();
        }
        ImGui.button(AxiomI18n.get("axiom.editorui.window.tool_masks.mask_offset"));
        ImGuiHelper.tooltip("Offsets the target position, affecting all masks inside");
        if (ImGui.isItemHovered()) {
            ImGui.setMouseCursor(7);
        }
        if (canDragDrop && ImGui.beginDragDropSource()) {
            ToolMaskWindow.setDragDroppingWidget(new OffsetMaskWidget(0, 0, 0));
            ImGui.endDragDropSource();
        }
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.editorui.window.tool_masks.masks"));
        ImGui.button(AxiomI18n.get("axiom.editorui.window.tool_masks.mask_block") + " =");
        ImGuiHelper.tooltip("Matches the block at the target position");
        if (ImGui.isItemHovered()) {
            ImGui.setMouseCursor(7);
        }
        if (canDragDrop && ImGui.beginDragDropSource()) {
            ToolMaskWindow.setDragDroppingWidget(new BlockMaskWidget());
            ImGui.endDragDropSource();
        }
        ImGui.button(AxiomI18n.get("axiom.editorui.window.tool_masks.mask_above") + " =");
        ImGuiHelper.tooltip("Matches the block above the target position");
        if (ImGui.isItemHovered()) {
            ImGui.setMouseCursor(7);
        }
        if (canDragDrop && ImGui.beginDragDropSource()) {
            ToolMaskWindow.setDragDroppingWidget(new BlockAboveMaskWidget());
            ImGui.endDragDropSource();
        }
        ImGui.button(AxiomI18n.get("axiom.editorui.window.tool_masks.mask_below") + " =");
        ImGuiHelper.tooltip("Matches the block below the target position");
        if (ImGui.isItemHovered()) {
            ImGui.setMouseCursor(7);
        }
        if (canDragDrop && ImGui.beginDragDropSource()) {
            ToolMaskWindow.setDragDroppingWidget(new BlockBelowMaskWidget());
            ImGui.endDragDropSource();
        }
        ImGui.button(AxiomI18n.get("axiom.editorui.window.tool_masks.mask_near") + " =");
        ImGuiHelper.tooltip("Checks if any block in a radius from the target position matches");
        if (ImGui.isItemHovered()) {
            ImGui.setMouseCursor(7);
        }
        if (canDragDrop && ImGui.beginDragDropSource()) {
            ToolMaskWindow.setDragDroppingWidget(new BlockNearMaskWidget());
            ImGui.endDragDropSource();
        }
        ImGui.button(AxiomI18n.get("axiom.editorui.window.tool_masks.mask_neighbor") + " =");
        ImGuiHelper.tooltip("Checks if any block touching the target position matches");
        if (ImGui.isItemHovered()) {
            ImGui.setMouseCursor(7);
        }
        if (canDragDrop && ImGui.beginDragDropSource()) {
            ToolMaskWindow.setDragDroppingWidget(new BlockNeighborMaskWidget());
            ImGui.endDragDropSource();
        }
        ImGui.button(AxiomI18n.get("axiom.editorui.window.tool_masks.mask_adjacent") + " =");
        ImGuiHelper.tooltip("Checks if any block horizontally touching the target position matches");
        if (ImGui.isItemHovered()) {
            ImGui.setMouseCursor(7);
        }
        if (canDragDrop && ImGui.beginDragDropSource()) {
            ToolMaskWindow.setDragDroppingWidget(new BlockAdjacentMaskWidget());
            ImGui.endDragDropSource();
        }
        ImGui.separator();
        ImGui.button(AxiomI18n.get("axiom.editorui.window.tool_masks.mask_biome") + " =");
        ImGuiHelper.tooltip("Matches the biome at the target position");
        if (ImGui.isItemHovered()) {
            ImGui.setMouseCursor(7);
        }
        if (canDragDrop && ImGui.beginDragDropSource()) {
            ToolMaskWindow.setDragDroppingWidget(new BiomeMaskWidget());
            ImGui.endDragDropSource();
        }
        ImGui.separator();
        ImGui.button("Y =");
        ImGuiHelper.tooltip("Compares a constant value to the target y position");
        if (ImGui.isItemHovered()) {
            ImGui.setMouseCursor(7);
        }
        if (canDragDrop && ImGui.beginDragDropSource()) {
            ToolMaskWindow.setDragDroppingWidget(new CoordMaskWidget());
            ImGui.endDragDropSource();
        }
        ImGui.button(AxiomI18n.get("axiom.editorui.window.tool_masks.mask_angle") + " =");
        ImGuiHelper.tooltip("Compares a constant value to the vertical angle of the surface");
        if (ImGui.isItemHovered()) {
            ImGui.setMouseCursor(7);
        }
        if (canDragDrop && ImGui.beginDragDropSource()) {
            ToolMaskWindow.setDragDroppingWidget(new AngleMaskWidget());
            ImGui.endDragDropSource();
        }
        ImGui.separator();
        ImGui.button(AxiomI18n.get("axiom.editorui.window.tool_masks.mask_inselection"));
        ImGuiHelper.tooltip("Checks if the target position is inside the selection");
        if (ImGui.isItemHovered()) {
            ImGui.setMouseCursor(7);
        }
        if (canDragDrop && ImGui.beginDragDropSource()) {
            ToolMaskWindow.setDragDroppingWidget(new InSelectionMaskWidget());
            ImGui.endDragDropSource();
        }
        ImGui.button(AxiomI18n.get("axiom.editorui.window.tool_masks.mask_can_see_sky"));
        ImGuiHelper.tooltip("Checks if the target position has direct access to the sky");
        if (ImGui.isItemHovered()) {
            ImGui.setMouseCursor(7);
        }
        if (canDragDrop && ImGui.beginDragDropSource()) {
            ToolMaskWindow.setDragDroppingWidget(new CanSeeSkyMaskWidget());
            ImGui.endDragDropSource();
        }
        ImGui.button(AxiomI18n.get("axiom.editorui.window.tool_masks.mask_surface"));
        ImGuiHelper.tooltip("Checks if the target position is on the surface");
        if (ImGui.isItemHovered()) {
            ImGui.setMouseCursor(7);
        }
        if (canDragDrop && ImGui.beginDragDropSource()) {
            ToolMaskWindow.setDragDroppingWidget(new SurfaceMaskWidget());
            ImGui.endDragDropSource();
        }
    }

    private static void renderParseException() {
        float factor;
        float width;
        float framePaddingX = ImGui.getStyle().getFramePaddingX();
        String string = ImGuiHelper.getString(stringMask);
        if (string.isBlank()) {
            return;
        }
        if (ImGuiHelper.calcTextWidth(string) > ImGui.getContentRegionAvailX() - framePaddingX * 2.0f) {
            ImGui.textWrapped(ToolMaskWindow.lastParseException.message);
            return;
        }
        int startIndex = ToolMaskWindow.lastParseException.start - 1;
        int endIndex = ToolMaskWindow.lastParseException.end - 1;
        boolean trimming = true;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (trimming) {
                if (c <= ' ') {
                    ++startIndex;
                    ++endIndex;
                    continue;
                }
                trimming = false;
            }
            if (endIndex <= i) break;
            if (c == ':') {
                if (startIndex > i) {
                    startIndex = Math.max(i, startIndex - 8);
                }
                endIndex = Math.max(i, endIndex - 8);
                continue;
            }
            if (c != '#') continue;
            if (startIndex > i) {
                startIndex = Math.max(i, startIndex - 10);
            }
            endIndex = Math.max(i, endIndex - 10);
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (startIndex == endIndex) {
            ++endIndex;
        }
        if (endIndex > string.length()) {
            endIndex = string.length();
        }
        if (startIndex > 0 && startIndex == endIndex) {
            --startIndex;
        }
        String startString = string.substring(0, startIndex);
        String endString = string.substring(0, endIndex);
        float startWidth = ImGuiHelper.calcTextWidth(startString);
        float endWidth = ImGuiHelper.calcTextWidth(endString);
        StringBuilder current = new StringBuilder();
        float lastWidth = 0.0f;
        while (true) {
            current.append(' ');
            width = ImGuiHelper.calcTextWidth(current.toString());
            if (width > startWidth) {
                factor = (startWidth - lastWidth) / (width - lastWidth);
                if ((double)factor < 0.75) {
                    current.setLength(current.length() - 1);
                    break;
                }
                lastWidth = width;
                break;
            }
            lastWidth = width;
        }
        while (true) {
            current.append('^');
            width = ImGuiHelper.calcTextWidth(current.toString());
            if (width > endWidth) {
                factor = (endWidth - lastWidth) / (width - lastWidth);
                if (!((double)factor < 0.25) || current.length() <= 0) break;
                current.setLength(current.length() - 1);
                break;
            }
            lastWidth = width;
        }
        ImGui.setCursorPosX(ImGui.getCursorPosX() + framePaddingX);
        ImGui.text(current.toString());
        ImGui.textWrapped(ToolMaskWindow.lastParseException.message);
    }

    private static void renderScriptingSection() {
        long time;
        if (luaExecutionError != null) {
            ImGui.textColored(-16776961, "An error occurred while executing the script");
            ImGui.textWrapped(luaExecutionError);
            if (ImGui.button(AxiomI18n.get("axiom.generic.close"))) {
                luaExecutionError = null;
            }
            ImGui.separator();
        }
        ImGuiHelper.separatorWithText("Lua Script Mask (Hover for help)");
        ImGuiHelper.tooltip(LUA_DESCRIPTION);
        EditorUI.imguiGlfw.enableTabInput();
        LUA_EDITOR.render("TextEditor");
        EditorUI.imguiGlfw.disableTabInput();
        if (LUA_EDITOR.isTextChanged()) {
            luaDirty = true;
        }
        if (luaDirty && (time = System.currentTimeMillis()) > lastLuaCompile + 250L) {
            lastLuaCompile = time;
            luaDirty = false;
            Globals globals = LuaHelper.createSandboxed();
            try {
                String script = LUA_EDITOR.getText();
                LuaValue luaValue = globals.load(script);
                if (!luaValue.isfunction()) {
                    LUA_EDITOR.setErrorMarkers(Map.of(1, "not a function"));
                    MaskManager.luaScript = null;
                } else {
                    LUA_EDITOR.setErrorMarkers(Map.of());
                    MaskManager.luaScript = script;
                    scriptChangedForPresetWidget = true;
                }
            }
            catch (LuaError luaError) {
                int totalLines;
                String message = luaError.getMessage();
                Pattern pattern = Pattern.compile(":(\\d+):");
                Matcher matcher = pattern.matcher(message);
                int line = 1;
                if (matcher.find()) {
                    line = Integer.parseInt(matcher.group(1));
                }
                if (line > (totalLines = LUA_EDITOR.getTotalLines())) {
                    line = totalLines;
                }
                String[] splitMessage = message.split(":");
                message = splitMessage[splitMessage.length - 1];
                LUA_EDITOR.setErrorMarkers(Map.of(line, message));
                MaskManager.luaScript = null;
            }
        }
    }

    public static void loadSettings(class_2487 compoundTag) {
        String mask = compoundTag.method_68564("mask", "").trim();
        if (mask.isEmpty()) {
            MaskManager.setConfiguredMask(null, true, true);
        } else {
            try {
                MaskElement maskElement = CmdStringConverter.fromCmdString(mask);
                MaskManager.setConfiguredMask(maskElement, true, true);
                lastParseException = null;
            }
            catch (CmdStringConverter.CmdStringParseException e) {
                lastParseException = e;
            }
        }
    }

    public static void writeSettings(class_2487 compoundTag) {
        compoundTag.method_10566("mask", (class_2520)class_2519.method_23256((String)ImGuiHelper.getString(stringMask)));
    }

    public static void loadSettingsScript(class_2487 compoundTag) {
        String lua2;
        MaskManager.luaScript = lua2 = compoundTag.method_68564("lua", "");
        LUA_EDITOR.setText(lua2);
    }

    public static void writeSettingsScript(class_2487 compoundTag) {
        if (MaskManager.luaScript != null) {
            compoundTag.method_10566("lua", (class_2520)class_2519.method_23256((String)MaskManager.luaScript));
        }
    }

    public static void setDragDroppingWidget(MaskWidget maskWidget) {
        if (dragDroppingWidget != null && dragDroppingWidget.isDragging()) {
            return;
        }
        if (EditorUI.isCtrlOrCmdDown()) {
            maskWidget = maskWidget.copy();
        } else {
            ToolMaskWindow.markDirty(maskWidget);
        }
        ImGui.setDragDropPayload("MaskWidget", maskWidget);
        maskWidget.setDragging(true);
        dragDroppingWidget = maskWidget;
        if (maskWidget.parent() != null) {
            maskWidget.parent().removeChild(maskWidget);
        } else if (widget == maskWidget) {
            widget = null;
        } else {
            removeFloating.add(maskWidget);
        }
    }

    public static void markDirty(MaskWidget maskWidget) {
        while (maskWidget.parent() != null) {
            maskWidget = maskWidget.parent();
        }
        if (maskWidget == widget) {
            visualCodeDirty = true;
        }
    }

    public static void onMaskUpdated(MaskElement maskElement, boolean updateCmdString, boolean updateVisualCode) {
        maskChangedForPresetWidget = true;
        if (maskElement == null) {
            if (updateCmdString) {
                stringMask.set("");
            }
            if (updateVisualCode) {
                widget = null;
            }
        } else {
            if (updateCmdString) {
                stringMask.set(CmdStringConverter.toCmdString(maskElement));
                lastParseException = null;
            }
            if (updateVisualCode) {
                widget = VisualCodeConverter.toVisualCode(maskElement);
            }
        }
    }

    static {
        TextEditorLanguageDefinition lang = TextEditorLanguageDefinition.lua();
        lang.setIdentifiers(Map.of("getBlock", "get the id of the block at position x, y, z", "getHighestBlockYAt", "get the y coordinate of the highest solid block at x, z", "getSimplexNoise", "sample simplex noise at position x, y, z", "getVoronoiEdgeNoise", "sample voronoi edge noise at position x, y, z", "isSolid", "get if the block argument is solid"));
        LUA_EDITOR.setLanguageDefinition(lang);
        LUA_EDITOR.setShowWhitespaces(false);
        lastLuaCompile = 0L;
        luaDirty = false;
        luaExecutionError = null;
        LUA_DESCRIPTION = "Create a mask using a Lua script\nFunction must return true/false\n\n" + LuaHelper.getAvailableLuaFunctions(false);
    }

    private record FloatingWidget(float x, float y, MaskWidget widget) {
    }
}

