/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.keybinds;

import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.VersionUtilsClient;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.keybinds.KeybindHelper;
import com.moulberry.axiom.editor.keybinds.Keybinds;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.lattice.keybind.KeybindInterface;
import com.moulberry.lattice.keybind.LatticeInputType;
import imgui.ImGui;
import imgui.ImGuiIO;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import org.lwjgl.glfw.GLFW;

public class Keybind
implements KeybindInterface {
    private final String description;
    private int key;
    private boolean shiftMod;
    private boolean ctrlMod;
    private boolean altMod;
    private boolean superMod;
    private boolean ingameDownLastTime = false;

    public Keybind(String description, int key, boolean shiftMod, boolean ctrlMod, boolean altMod, boolean superMod) {
        this.description = description;
        this.key = key;
        this.shiftMod = shiftMod;
        this.ctrlMod = ctrlMod;
        this.altMod = altMod;
        this.superMod = superMod;
        Keybinds.updateMapping(this, 0);
    }

    public int getKey() {
        return this.key;
    }

    public boolean isShiftMod() {
        return this.shiftMod;
    }

    public boolean isCtrlMod() {
        return this.ctrlMod;
    }

    public boolean isAltMod() {
        return this.altMod;
    }

    public boolean isSuperMod() {
        return this.superMod;
    }

    public void clear() {
        int oldKey = this.key;
        this.key = 0;
        this.shiftMod = false;
        this.ctrlMod = false;
        this.altMod = false;
        this.superMod = false;
        Keybinds.updateMapping(this, oldKey);
    }

    public void set(Keybind other) {
        if (other.description.equals(this.description)) {
            int oldKey = this.key;
            this.key = other.key;
            this.shiftMod = other.shiftMod;
            this.ctrlMod = other.ctrlMod;
            this.altMod = other.altMod;
            this.superMod = other.superMod;
            Keybinds.updateMapping(this, oldKey);
        }
    }

    public String toConfigValue() {
        if (this.key == 0) {
            return "none";
        }
        String key = KeybindHelper.glfwToConfig(this.key);
        if (key.equals("none")) {
            return "none";
        }
        StringBuilder builder = new StringBuilder();
        if (this.shiftMod) {
            builder.append("shift+");
        }
        if (this.ctrlMod) {
            builder.append("ctrl+");
        }
        if (this.altMod) {
            builder.append("alt+");
        }
        if (this.superMod) {
            builder.append("super+");
        }
        builder.append(key);
        return builder.toString();
    }

    public void loadFromConfigValue(String configValue) {
        String originalConfigValue = configValue;
        configValue = configValue.toLowerCase(Locale.ROOT);
        if ((configValue = configValue.replaceAll("[^a-z0-9+_]", "")).equals("none")) {
            int oldKey = this.key;
            this.key = 0;
            this.superMod = false;
            this.altMod = false;
            this.ctrlMod = false;
            this.shiftMod = false;
            Keybinds.updateMapping(this, oldKey);
            return;
        }
        boolean shiftMod = false;
        boolean ctrlMod = false;
        boolean altMod = false;
        boolean superMod = false;
        while (true) {
            if (configValue.startsWith("shift+")) {
                shiftMod = true;
                configValue = configValue.substring(6);
                continue;
            }
            if (configValue.startsWith("ctrl+")) {
                ctrlMod = true;
                configValue = configValue.substring(5);
                continue;
            }
            if (configValue.startsWith("alt+")) {
                altMod = true;
                configValue = configValue.substring(4);
                continue;
            }
            if (!configValue.startsWith("super+")) break;
            superMod = true;
            configValue = configValue.substring(6);
        }
        int key = KeybindHelper.configToGlfw(configValue = configValue.substring(configValue.lastIndexOf("+") + 1));
        if (key != 0) {
            int oldKey = this.key;
            this.key = key;
            this.shiftMod = shiftMod;
            this.ctrlMod = ctrlMod;
            this.altMod = altMod;
            this.superMod = superMod;
            Keybinds.updateMapping(this, oldKey);
        } else {
            Axiom.dbg("Invalid keybind in config for " + this.description + ": " + originalConfigValue);
        }
    }

    public Keybind copy() {
        return new Keybind(this.description, this.key, this.shiftMod, this.ctrlMod, this.altMod, this.superMod);
    }

    public void set(int key, boolean shiftMod, boolean ctrlMod, boolean altMod, boolean superMod) {
        int oldKey = this.key;
        this.key = key;
        this.shiftMod = shiftMod;
        this.ctrlMod = ctrlMod;
        this.altMod = altMod;
        this.superMod = superMod;
        Keybinds.updateMapping(this, oldKey);
    }

    public boolean hasSameMods(Keybind other) {
        return this.shiftMod == other.shiftMod && this.ctrlMod == other.ctrlMod && this.altMod == other.altMod && this.superMod == other.superMod;
    }

    private static String getKeyNameFor(int key) {
        return class_3675.method_15985((int)key, (int)-1).method_27445().getString();
    }

    public String shortKeyIdentifier() {
        if (this.key == 0) {
            return "";
        }
        Object keyName = this.key < 0 ? "M" + -this.key : Keybind.getKeyNameFor(this.key);
        if (!(this.shiftMod || this.ctrlMod || this.altMod || this.superMod)) {
            return keyName;
        }
        int macCmd = 8984;
        int alt = 9095;
        int shift = 8679;
        int superKey = 10070;
        StringBuilder builder = new StringBuilder();
        if (this.shiftMod) {
            builder.append('\u21e7');
        }
        if (this.ctrlMod) {
            if (class_310.field_1703) {
                builder.append('\u2318');
            } else {
                builder.append(AxiomI18n.get("axiom.keymod.ctrl")).append("+");
            }
        }
        if (this.altMod) {
            builder.append('\u2387');
        }
        if (this.superMod) {
            if (class_310.field_1703) {
                builder.append(AxiomI18n.get("axiom.keymod.ctrl")).append("+");
            } else {
                builder.append('\u2756');
            }
        }
        builder.append((String)keyName);
        return builder.toString();
    }

    public String longKeyIdentifier() {
        if (this.key == 0) {
            return AxiomI18n.get("key.keyboard.unknown");
        }
        String keyName = this.key < 0 ? class_3675.class_307.field_1672.method_1447(-this.key - 1).method_27445().getString() : Keybind.getKeyNameFor(this.key);
        if (!(this.shiftMod || this.ctrlMod || this.altMod || this.superMod)) {
            return keyName;
        }
        StringBuilder builder = new StringBuilder();
        if (this.shiftMod) {
            builder.append(AxiomI18n.get("axiom.keymod.shift")).append("+");
        }
        if (this.ctrlMod) {
            if (class_310.field_1703) {
                builder.append(AxiomI18n.get("axiom.keymod.mac_cmd")).append("+");
            } else {
                builder.append(AxiomI18n.get("axiom.keymod.ctrl")).append("+");
            }
        }
        if (this.altMod) {
            builder.append(AxiomI18n.get("axiom.keymod.alt")).append("+");
        }
        if (this.superMod) {
            if (class_310.field_1703) {
                builder.append(AxiomI18n.get("axiom.keymod.ctrl")).append("+");
            } else if (class_156.method_668() == class_156.class_158.field_1133) {
                builder.append(AxiomI18n.get("axiom.keymod.win_super")).append("+");
            } else {
                builder.append(AxiomI18n.get("axiom.keymod.super")).append("+");
            }
        }
        builder.append(keyName);
        return builder.toString();
    }

    public boolean wouldBePressed(int key, boolean shiftMod, boolean ctrlMod, boolean altMod, boolean superMod) {
        if (this.key == 0) {
            return false;
        }
        if (this.key != key) {
            return false;
        }
        if (this.shiftMod != shiftMod) {
            return false;
        }
        if (this.ctrlMod != (class_310.field_1703 ? superMod : ctrlMod)) {
            return false;
        }
        if (this.altMod != altMod) {
            return false;
        }
        return this.superMod == (class_310.field_1703 ? ctrlMod : superMod);
    }

    public boolean isDownUsingGLFW() {
        if (this.key == 0) {
            return false;
        }
        class_310 minecraft = class_310.method_1551();
        long window = minecraft.method_22683().method_4490();
        if (this.key < 0 ? GLFW.glfwGetMouseButton((long)window, (int)(-this.key - 1)) == 0 : GLFW.glfwGetKey((long)window, (int)this.key) == 0) {
            return false;
        }
        if (this.shiftMod != VersionUtilsClient.wasteFirstBoolean(minecraft, class_437.method_25442())) {
            return false;
        }
        if (this.ctrlMod != VersionUtilsClient.wasteFirstBoolean(minecraft, class_437.method_25441())) {
            return false;
        }
        return this.altMod == VersionUtilsClient.wasteFirstBoolean(minecraft, class_437.method_25443());
    }

    public boolean isDown() {
        return this.areAllModifiersDown() && this.isDownIgnoreMods();
    }

    public boolean isDownIgnoreMods() {
        if (this.key == 0) {
            return false;
        }
        if (EditorUI.isActive() && EditorUI.isImGuiContextActive()) {
            if (this.key < 0 ? !EditorUI.getIO().getMouseDown(-this.key - 1) : !EditorUI.getIO().getKeysDown(this.key)) {
                return false;
            }
        } else {
            long window = class_310.method_1551().method_22683().method_4490();
            if (this.key < 0 ? GLFW.glfwGetMouseButton((long)window, (int)(-this.key - 1)) == 0 : GLFW.glfwGetKey((long)window, (int)this.key) == 0) {
                return false;
            }
        }
        return true;
    }

    public boolean isPressed(boolean repeat) {
        return this.areAllModifiersDown() && this.isPressedIgnoreMods(repeat);
    }

    public boolean isPressedIgnoreMods(boolean repeat) {
        if (this.key == 0) {
            return false;
        }
        if (EditorUI.isActive() && EditorUI.isImGuiContextActive()) {
            return !(this.key < 0 ? !ImGui.isMouseClicked(-this.key - 1, repeat) : !ImGui.isKeyPressed(this.key, repeat));
        }
        boolean down = this.isDownIgnoreMods();
        boolean wasDown = this.ingameDownLastTime;
        this.ingameDownLastTime = down;
        return down && !wasDown;
    }

    public boolean areAllModifiersDown() {
        if (this.key == 0) {
            return false;
        }
        if (EditorUI.isActive() && EditorUI.isImGuiContextActive()) {
            ImGuiIO io = EditorUI.getIO();
            if (this.shiftMod != io.getKeyShift()) {
                return false;
            }
            if (this.ctrlMod != (class_310.field_1703 ? io.getKeySuper() : io.getKeyCtrl())) {
                return false;
            }
            if (this.altMod != io.getKeyAlt()) {
                return false;
            }
            if (this.superMod != (class_310.field_1703 ? io.getKeyCtrl() : io.getKeySuper())) {
                return false;
            }
        } else {
            class_310 minecraft = class_310.method_1551();
            if (this.shiftMod != VersionUtilsClient.wasteFirstBoolean(minecraft, class_437.method_25442())) {
                return false;
            }
            if (this.ctrlMod != VersionUtilsClient.wasteFirstBoolean(minecraft, class_437.method_25441())) {
                return false;
            }
            if (this.altMod != VersionUtilsClient.wasteFirstBoolean(minecraft, class_437.method_25443())) {
                return false;
            }
        }
        return true;
    }

    public String getDescriptionRaw() {
        return this.description;
    }

    public String getDescription() {
        return AxiomI18n.get("axiom.keybinds." + this.description);
    }

    public class_2561 getKeyMessage() {
        return class_2561.method_43470((String)this.longKeyIdentifier());
    }

    public void setKey(LatticeInputType type2, int value, boolean shiftMod, boolean ctrlMod, boolean altMod, boolean superMod) {
        int oldKey = this.key;
        switch (type2) {
            case KEYSYM: {
                this.key = value;
                break;
            }
            case SCANCODE: {
                return;
            }
            case MOUSE: {
                this.key = -value - 1;
            }
        }
        this.shiftMod = shiftMod;
        this.ctrlMod = class_310.field_1703 ? superMod : ctrlMod;
        this.altMod = altMod;
        this.superMod = class_310.field_1703 ? ctrlMod : superMod;
        Keybinds.updateMapping(this, oldKey);
    }

    public void setUnbound() {
        int oldKey = this.key;
        this.key = 0;
        this.superMod = false;
        this.altMod = false;
        this.ctrlMod = false;
        this.shiftMod = false;
        Keybinds.updateMapping(this, oldKey);
    }

    public Collection<class_2561> getConflicts() {
        return List.of();
    }
}

