/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.block_maps;

import com.moulberry.axiom.capabilities.Tinker;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.tools.Tool;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_5793;
import net.minecraft.class_5794;

public class HDVoxelMap {
    private static final Map<class_2248, HDVoxelBaseBlocks> VOXEL_BASE_BLOCKS_MAP = new HashMap<class_2248, HDVoxelBaseBlocks>();
    private static final Map<class_2248, HDVoxelBaseBlocks> VOXEL_BASE_BLOCKS_FULL_MAP = new HashMap<class_2248, HDVoxelBaseBlocks>();

    private static void process(class_2248 full, class_2248 stair, class_2248 slab) {
        HDVoxelBaseBlocks hdVoxelBaseBlocks = new HDVoxelBaseBlocks(full, stair, slab);
        VOXEL_BASE_BLOCKS_FULL_MAP.put(full, hdVoxelBaseBlocks);
        VOXEL_BASE_BLOCKS_MAP.put(full, hdVoxelBaseBlocks);
        VOXEL_BASE_BLOCKS_MAP.put(stair, hdVoxelBaseBlocks);
        VOXEL_BASE_BLOCKS_MAP.put(slab, hdVoxelBaseBlocks);
    }

    public static HDVoxelBaseBlocks getAssociatedBlocks(class_2248 block) {
        return VOXEL_BASE_BLOCKS_MAP.get(block);
    }

    public static HDVoxelBaseBlocks getAssociatedBlocksForFull(class_2248 block) {
        return VOXEL_BASE_BLOCKS_FULL_MAP.get(block);
    }

    public static void downsizePathTool(ChunkedBlockRegion doubleSizeRegion, ChunkedBlockRegion into) {
        class_2680 slab;
        class_2680 stair;
        class_2680 full;
        PositionSet tempSet = new PositionSet();
        doubleSizeRegion.forEachChunk((cx, cy, cz, blocks) -> {
            class_2680[] minusX = doubleSizeRegion.getChunk(cx - 1, cy, cz);
            class_2680[] plusX = doubleSizeRegion.getChunk(cx + 1, cy, cz);
            class_2680[] minusY = doubleSizeRegion.getChunk(cx, cy - 1, cz);
            class_2680[] plusY = doubleSizeRegion.getChunk(cx, cy + 1, cz);
            class_2680[] minusZ = doubleSizeRegion.getChunk(cx, cy, cz - 1);
            class_2680[] plusZ = doubleSizeRegion.getChunk(cx, cy, cz + 1);
            for (int x = 0; x < 16; x += 2) {
                for (int y = 0; y < 16; y += 2) {
                    for (int z = 0; z < 16; z += 2) {
                        int bits = 0;
                        if (blocks[x + y * 16 + z * 16 * 16] != null) {
                            bits |= 0x80;
                        }
                        if (blocks[x + y * 16 + (z + 1) * 16 * 16] != null) {
                            bits |= 0x40;
                        }
                        if (blocks[x + 1 + y * 16 + z * 16 * 16] != null) {
                            bits |= 0x20;
                        }
                        if (blocks[x + 1 + y * 16 + (z + 1) * 16 * 16] != null) {
                            bits |= 0x10;
                        }
                        if (blocks[x + (y + 1) * 16 + z * 16 * 16] != null) {
                            bits |= 8;
                        }
                        if (blocks[x + (y + 1) * 16 + (z + 1) * 16 * 16] != null) {
                            bits |= 4;
                        }
                        if (blocks[x + 1 + (y + 1) * 16 + z * 16 * 16] != null) {
                            bits |= 2;
                        }
                        if (blocks[x + 1 + (y + 1) * 16 + (z + 1) * 16 * 16] != null) {
                            bits |= 1;
                        }
                        if (bits == 0) continue;
                        int minError = Integer.MAX_VALUE;
                        int closestValid = 255;
                        for (int voxel : Tinker.validVoxel222) {
                            int different = (bits ^ voxel) & 0xFF;
                            int error2 = Integer.bitCount(different) * 3;
                            if ((different & 0x80) != 0 && (voxel & 0x80) != 0) {
                                error2 += HDVoxelMap.penalizeJagged(x, y, z, blocks, minusX, plusX, minusY, plusY, minusZ, plusZ) * 2;
                            }
                            if ((different & 0x40) != 0 && (voxel & 0x40) != 0) {
                                error2 += HDVoxelMap.penalizeJagged(x, y, z + 1, blocks, minusX, plusX, minusY, plusY, minusZ, plusZ) * 2;
                            }
                            if ((different & 0x20) != 0 && (voxel & 0x20) != 0) {
                                error2 += HDVoxelMap.penalizeJagged(x + 1, y, z, blocks, minusX, plusX, minusY, plusY, minusZ, plusZ) * 2;
                            }
                            if ((different & 0x10) != 0 && (voxel & 0x10) != 0) {
                                error2 += HDVoxelMap.penalizeJagged(x + 1, y, z + 1, blocks, minusX, plusX, minusY, plusY, minusZ, plusZ) * 2;
                            }
                            if ((different & 8) != 0 && (voxel & 8) != 0) {
                                error2 += HDVoxelMap.penalizeJagged(x, y + 1, z, blocks, minusX, plusX, minusY, plusY, minusZ, plusZ) * 2;
                            }
                            if ((different & 4) != 0 && (voxel & 4) != 0) {
                                error2 += HDVoxelMap.penalizeJagged(x, y + 1, z + 1, blocks, minusX, plusX, minusY, plusY, minusZ, plusZ) * 2;
                            }
                            if ((different & 2) != 0 && (voxel & 2) != 0) {
                                error2 += HDVoxelMap.penalizeJagged(x + 1, y + 1, z, blocks, minusX, plusX, minusY, plusY, minusZ, plusZ) * 2;
                            }
                            if ((different & 1) != 0 && (voxel & 1) != 0) {
                                error2 += HDVoxelMap.penalizeJagged(x + 1, y + 1, z + 1, blocks, minusX, plusX, minusY, plusY, minusZ, plusZ) * 2;
                            }
                            error2 *= 16;
                            if ((error2 += 8 - Integer.bitCount(voxel & 0xFF)) >= minError) continue;
                            minError = error2;
                            closestValid = voxel;
                        }
                        if ((closestValid & 0x80) != 0) {
                            tempSet.add(cx * 16 + x, cy * 16 + y, cz * 16 + z);
                        }
                        if ((closestValid & 0x40) != 0) {
                            tempSet.add(cx * 16 + x, cy * 16 + y, cz * 16 + z + 1);
                        }
                        if ((closestValid & 0x20) != 0) {
                            tempSet.add(cx * 16 + x + 1, cy * 16 + y, cz * 16 + z);
                        }
                        if ((closestValid & 0x10) != 0) {
                            tempSet.add(cx * 16 + x + 1, cy * 16 + y, cz * 16 + z + 1);
                        }
                        if ((closestValid & 8) != 0) {
                            tempSet.add(cx * 16 + x, cy * 16 + y + 1, cz * 16 + z);
                        }
                        if ((closestValid & 4) != 0) {
                            tempSet.add(cx * 16 + x, cy * 16 + y + 1, cz * 16 + z + 1);
                        }
                        if ((closestValid & 2) != 0) {
                            tempSet.add(cx * 16 + x + 1, cy * 16 + y + 1, cz * 16 + z);
                        }
                        if ((closestValid & 1) == 0) continue;
                        tempSet.add(cx * 16 + x + 1, cy * 16 + y + 1, cz * 16 + z + 1);
                    }
                }
            }
        });
        PositionSet tempSet2 = new PositionSet();
        tempSet.forEach((x, y, z) -> {
            tempSet2.add(x, y, z);
            if (tempSet.contains(x + 2, y, z)) {
                tempSet2.add(x + 1, y, z);
            }
            if (tempSet.contains(x, y + 2, z)) {
                tempSet2.add(x, y + 1, z);
            }
            if (tempSet.contains(x, y, z + 2)) {
                tempSet2.add(x, y, z + 1);
            }
        });
        class_2680 activeBlock = Tool.getActiveBlock();
        HDVoxelBaseBlocks blocks2 = HDVoxelMap.getAssociatedBlocks(activeBlock.method_26204());
        if (blocks2 == null) {
            full = class_2246.field_10340.method_9564();
            stair = class_2246.field_10440.method_9564();
            slab = class_2246.field_10454.method_9564();
        } else {
            full = blocks2.full().method_9564();
            stair = blocks2.stair().method_9564();
            slab = blocks2.slab().method_9564();
        }
        tempSet2.forEachChunk((cx, cy, cz, chunk) -> {
            for (int x = 0; x < 16; x += 2) {
                for (int y = 0; y < 16; y += 2) {
                    for (int z = 0; z < 16; z += 2) {
                        int bits = 0;
                        if ((chunk[y + z * 16] & 1 << x) != 0) {
                            bits |= 0x80;
                        }
                        if ((chunk[y + (z + 1) * 16] & 1 << x) != 0) {
                            bits |= 0x40;
                        }
                        if ((chunk[y + z * 16] & 1 << x + 1) != 0) {
                            bits |= 0x20;
                        }
                        if ((chunk[y + (z + 1) * 16] & 1 << x + 1) != 0) {
                            bits |= 0x10;
                        }
                        if ((chunk[y + 1 + z * 16] & 1 << x) != 0) {
                            bits |= 8;
                        }
                        if ((chunk[y + 1 + (z + 1) * 16] & 1 << x) != 0) {
                            bits |= 4;
                        }
                        if ((chunk[y + 1 + z * 16] & 1 << x + 1) != 0) {
                            bits |= 2;
                        }
                        if ((chunk[y + 1 + (z + 1) * 16] & 1 << x + 1) != 0) {
                            bits |= 1;
                        }
                        if (bits == 0) continue;
                        class_2680 validBlock = Tinker.createFromVoxel222(bits, full, stair, slab);
                        into.addBlockWithoutDirty(cx * 8 + x / 2, cy * 8 + y / 2, cz * 8 + z / 2, validBlock);
                    }
                }
            }
        });
    }

    private static int penalizeJagged(int x, int y, int z, class_2680[] blocks, class_2680[] minusX, class_2680[] plusX, class_2680[] minusY, class_2680[] plusY, class_2680[] minusZ, class_2680[] plusZ) {
        boolean minusEmpty;
        boolean plusEmpty;
        int jagged = 0;
        boolean bl = x == 15 ? plusX == null || plusX[0 + y * 16 + z * 16 * 16] == null : (plusEmpty = blocks[x + 1 + y * 16 + z * 16 * 16] == null);
        boolean bl2 = x == 0 ? minusX == null || minusX[15 + y * 16 + z * 16 * 16] == null : (minusEmpty = blocks[x - 1 + y * 16 + z * 16 * 16] == null);
        if (plusEmpty && minusEmpty) {
            ++jagged;
        }
        boolean bl3 = y == 15 ? plusY == null || plusY[x + 0 + z * 16 * 16] == null : (plusEmpty = blocks[x + (y + 1) * 16 + z * 16 * 16] == null);
        boolean bl4 = y == 0 ? minusY == null || minusY[x + 240 + z * 16 * 16] == null : (minusEmpty = blocks[x + (y - 1) * 16 + z * 16 * 16] == null);
        if (plusEmpty && minusEmpty) {
            ++jagged;
        }
        boolean bl5 = z == 15 ? plusZ == null || plusZ[x + y * 16 + 0] == null : (plusEmpty = blocks[x + y * 16 + (z + 1) * 16 * 16] == null);
        boolean bl6 = z == 0 ? minusZ == null || minusZ[x + y * 16 + 3840] == null : (minusEmpty = blocks[x + y * 16 + (z - 1) * 16 * 16] == null);
        if (plusEmpty && minusEmpty) {
            ++jagged;
        }
        return jagged;
    }

    static {
        class_5793.method_33467().forEach(blockFamily -> {
            class_2248 base = blockFamily.method_33469();
            class_2248 stairs = blockFamily.method_33470(class_5794.class_5796.field_28540);
            class_2248 slab = blockFamily.method_33470(class_5794.class_5796.field_28539);
            if (stairs != null && slab != null) {
                HDVoxelMap.process(base, stairs, slab);
            }
        });
    }

    public record HDVoxelBaseBlocks(class_2248 full, class_2248 stair, class_2248 slab) {
    }
}

