/*
 * Decompiled with CFR 0.152.
 */
package com.ezylang.axiom.evalex.operators.arithmetic;

import com.ezylang.axiom.evalex.EvaluationException;
import com.ezylang.axiom.evalex.Expression;
import com.ezylang.axiom.evalex.data.EvaluationValue;
import com.ezylang.axiom.evalex.operators.AbstractOperator;
import com.ezylang.axiom.evalex.operators.InfixOperator;
import com.ezylang.axiom.evalex.parser.Token;
import java.math.BigDecimal;

@InfixOperator(precedence=30)
public class InfixDivisionOperator
extends AbstractOperator {
    @Override
    public EvaluationValue evaluate(Expression expression, Token operatorToken, EvaluationValue ... operands) throws EvaluationException {
        EvaluationValue leftOperand = operands[0];
        EvaluationValue rightOperand = operands[1];
        if (leftOperand.isNumberValue() && rightOperand.isNumberValue()) {
            if (rightOperand.getNumberValue().equals(BigDecimal.ZERO)) {
                throw new EvaluationException(operatorToken, "Division by zero");
            }
            return new EvaluationValue(leftOperand.getNumberValue().divide(rightOperand.getNumberValue(), expression.getConfiguration().getMathContext()));
        }
        throw EvaluationException.ofUnsupportedDataTypeInOperation(operatorToken);
    }
}

